/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import org.apache.avalon.framework.CascadingThrowable;

public final class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static String printStackTrace(Throwable throwable) {
        return ExceptionUtil.printStackTrace(throwable, 0, true);
    }

    public static String printStackTrace(Throwable throwable, boolean printCascading) {
        return ExceptionUtil.printStackTrace(throwable, 0, printCascading);
    }

    public static String printStackTrace(Throwable throwable, int depth) {
        int dp = depth;
        String[] lines = ExceptionUtil.captureStackTrace(throwable);
        if (0 == dp || dp > lines.length) {
            dp = lines.length;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < dp) {
            sb.append(lines[i]);
            sb.append('\n');
            ++i;
        }
        return sb.toString();
    }

    public static String printStackTrace(Throwable throwable, int depth, boolean printCascading) {
        String result = ExceptionUtil.printStackTrace(throwable, depth);
        if (!printCascading || !(throwable instanceof CascadingThrowable)) {
            return result;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(result);
        Throwable cause = ((CascadingThrowable)((Object)throwable)).getCause();
        while (null != cause) {
            sb.append("rethrown from\n");
            sb.append(ExceptionUtil.printStackTrace(cause, depth));
            cause = cause instanceof CascadingThrowable ? ((CascadingThrowable)((Object)cause)).getCause() : null;
        }
        return sb.toString();
    }

    public static String[] captureStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)sw, true));
        return ExceptionUtil.splitString(sw.toString(), "\n");
    }

    public static String[] splitString(String string, String onToken) {
        StringTokenizer tokenizer = new StringTokenizer(string, onToken);
        String[] result = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < result.length) {
            result[i] = tokenizer.nextToken();
            ++i;
        }
        return result;
    }
}

