/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.source;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.avalon.framework.parameters.Parameters;

public final class SourceParameters
implements Serializable {
    static BitSet charactersDontNeedingEncoding = new BitSet(256);
    static final int characterCaseDiff = 32;
    private Map names = new HashMap(5);

    private String parseName(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    break;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                        i += 2;
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        String rest = s.substring(i);
                        sb.append(rest);
                        if (rest.length() != 2) break;
                        ++i;
                        break;
                    }
                }
                default: {
                    sb.append(c);
                    break;
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private void setParameter(String name, String value) {
        ArrayList<String> list;
        if (this.names.containsKey(name)) {
            ArrayList arrayList = (ArrayList)this.names.get(name);
        } else {
            list = new ArrayList<String>(3);
            this.names.put(name, list);
        }
        list.add(value);
    }

    public String getParameter(String name) {
        if (this.names.containsKey(name)) {
            return (String)((ArrayList)this.names.get(name)).get(0);
        }
        return null;
    }

    public String getParameter(String name, String defaultValue) {
        if (this.names.containsKey(name)) {
            return (String)((ArrayList)this.names.get(name)).get(0);
        }
        return defaultValue;
    }

    public int getParameterAsInteger(String name, int defaultValue) {
        if (this.names.containsKey(name)) {
            return new Integer((String)((ArrayList)this.names.get(name)).get(0));
        }
        return defaultValue;
    }

    public boolean getParameterAsBoolean(String name, boolean defaultValue) {
        if (this.names.containsKey(name)) {
            return new Boolean((String)((ArrayList)this.names.get(name)).get(0));
        }
        return defaultValue;
    }

    public boolean containsParameter(String name) {
        return this.names.containsKey(name);
    }

    public Iterator getParameterValues(String name) {
        if (this.names.containsKey(name)) {
            ArrayList list = (ArrayList)this.names.get(name);
            return ((AbstractList)list).iterator();
        }
        return null;
    }

    public Iterator getParameterNames() {
        return this.names.keySet().iterator();
    }

    public Parameters getFirstParameters() {
        Parameters result = new Parameters();
        Iterator iter = this.getParameterNames();
        while (iter.hasNext()) {
            String parName = (String)iter.next();
            result.setParameter(parName, this.getParameter(parName));
        }
        return result;
    }

    public String getQueryString() {
        StringBuffer result = new StringBuffer();
        Iterator iter = this.names.keySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Iterator listIterator = ((AbstractList)((ArrayList)this.names.get(key))).iterator();
            while (listIterator.hasNext()) {
                if (!first) {
                    result.append('&');
                }
                String value = (String)listIterator.next();
                result.append(key).append('=').append(value);
                first = false;
            }
        }
        return result.length() == 0 ? null : result.toString();
    }

    public String getEncodedQueryString() {
        StringBuffer result = new StringBuffer();
        Iterator iter = this.names.keySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Iterator listIterator = ((AbstractList)((ArrayList)this.names.get(key))).iterator();
            while (listIterator.hasNext()) {
                if (!first) {
                    result.append('&');
                }
                String value = (String)listIterator.next();
                result.append(key).append('=').append(this.encode(value));
                first = false;
            }
        }
        return result.length() == 0 ? null : result.toString();
    }

    public void add(SourceParameters parameters) {
        Iterator names = parameters.getParameterNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            Iterator values = parameters.getParameterValues(name);
            while (values.hasNext()) {
                String value = (String)values.next();
                this.setParameter(name, value);
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("SourceParameters: {");
        Iterator names = this.getParameterNames();
        boolean firstName = true;
        while (names.hasNext()) {
            String name = (String)names.next();
            if (!firstName) {
                buffer.append(", ");
            } else {
                firstName = false;
            }
            buffer.append(name).append(" = (");
            Iterator values = this.getParameterValues(name);
            boolean firstValue = true;
            while (values.hasNext()) {
                String value = (String)values.next();
                if (!firstValue) {
                    buffer.append(", ");
                } else {
                    firstValue = false;
                }
                buffer.append(value);
            }
            buffer.append(')');
        }
        buffer.append('}');
        return buffer.toString();
    }

    public Object clone() {
        SourceParameters newObject = new SourceParameters();
        Iterator names = this.getParameterNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            Iterator values = this.getParameterValues(name);
            while (values.hasNext()) {
                String value = (String)values.next();
                newObject.setParameter(name, value);
            }
        }
        return newObject;
    }

    public boolean hasParameters() {
        return this.names.size() > 0;
    }

    public void setSingleParameterValue(String name, String value) {
        this.removeParameter(name);
        this.setParameter(name, value);
    }

    public void removeParameter(String name) {
        if (this.names.containsKey(name)) {
            this.names.remove(name);
        }
    }

    private String encode(String s) {
        StringBuffer out = new StringBuffer(s.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(32);
        OutputStreamWriter writer = new OutputStreamWriter(buf);
        int i = 0;
        while (i < s.length()) {
            block10: {
                char c = s.charAt(i);
                if (charactersDontNeedingEncoding.get(c)) {
                    if (c == ' ') {
                        out.append("%20");
                    } else {
                        out.append(c);
                    }
                } else {
                    try {
                        writer.write(c);
                        writer.flush();
                    }
                    catch (IOException e) {
                        buf.reset();
                        break block10;
                    }
                    byte[] ba = buf.toByteArray();
                    int j = 0;
                    while (j < ba.length) {
                        out.append('%');
                        char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                        if (Character.isLetter(ch)) {
                            ch = (char)(ch - 32);
                        }
                        out.append(ch);
                        ch = Character.forDigit(ba[j] & 0xF, 16);
                        if (Character.isLetter(ch)) {
                            ch = (char)(ch - 32);
                        }
                        out.append(ch);
                        ++j;
                    }
                    buf.reset();
                }
            }
            ++i;
        }
        return out.toString();
    }

    public SourceParameters() {
    }

    public SourceParameters(String queryString) {
        if (queryString != null) {
            StringTokenizer st = new StringTokenizer(queryString, "&");
            while (st.hasMoreTokens()) {
                String pair = st.nextToken();
                int pos = pair.indexOf(61);
                if (pos == -1) continue;
                this.setParameter(this.parseName(pair.substring(0, pos)), this.parseName(pair.substring(pos + 1, pair.length())));
            }
        }
    }

    static {
        int i = 97;
        while (i <= 122) {
            charactersDontNeedingEncoding.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            charactersDontNeedingEncoding.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            charactersDontNeedingEncoding.set(i);
            ++i;
        }
        charactersDontNeedingEncoding.set(32);
        charactersDontNeedingEncoding.set(45);
        charactersDontNeedingEncoding.set(95);
        charactersDontNeedingEncoding.set(46);
        charactersDontNeedingEncoding.set(42);
        charactersDontNeedingEncoding.set(34);
    }
}

