/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.lang;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.excalibur.lang.ThreadContextAccessor;
import org.apache.avalon.excalibur.lang.ThreadContextPolicy;

public final class ThreadContext {
    private static final RuntimePermission c_setThreadContext = new RuntimePermission("ThreadContext.setThreadContext");
    private static final InheritableThreadLocal c_context = new InheritableThreadLocal();
    private final ThreadContextAccessor m_accessor;
    private final ThreadContextPolicy m_policy;
    private final HashMap m_map;

    public static ThreadContext getThreadContext() {
        return (ThreadContext)c_context.get();
    }

    public static void setThreadContext(ThreadContext threadContext) throws SecurityException {
        ThreadContext oldThreadContext;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(c_setThreadContext);
        }
        if ((oldThreadContext = (ThreadContext)c_context.get()) != null) {
            oldThreadContext.deactivate();
        }
        c_context.set(threadContext);
        if (threadContext != null) {
            threadContext.activate();
        }
    }

    private void activate() {
        this.m_policy.activate(this.m_accessor);
    }

    private void deactivate() {
        this.m_policy.deactivate(this.m_accessor);
    }

    public ThreadContext(ThreadContextPolicy policy, Map map) {
        ThreadContext threadContext = this;
        if (threadContext == null) {
            throw null;
        }
        this.m_accessor = threadContext.new InnerThreadContextAccessor();
        if (policy == null) {
            throw new NullPointerException("policy property is null");
        }
        if (map == null) {
            throw new NullPointerException("map property is null");
        }
        this.m_policy = policy;
        this.m_map = new HashMap();
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            Object value = map.get(key);
            String keyString = key.toString();
            this.m_policy.verifyKeyValue(keyString, value);
            this.m_map.put(keyString, value);
        }
    }

    private class InnerThreadContextAccessor
    implements ThreadContextAccessor {
        public boolean containsKey(String key) {
            if (ThreadContext.this.m_map == null) {
                return false;
            }
            return ThreadContext.this.m_map.containsKey(key);
        }

        public Object get(String key) {
            if (ThreadContext.this.m_map == null) {
                return null;
            }
            return ThreadContext.this.m_map.get(key);
        }

        InnerThreadContextAccessor() {
        }
    }
}

