/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.i18n;

import java.util.Map;
import org.apache.avalon.excalibur.i18n.Bundle;
import org.apache.avalon.excalibur.i18n.BundleInfo;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;

public abstract class AbstractBundle
extends AbstractLogEnabled
implements Bundle,
Component {
    private BundleInfo bundleInfo;
    private Bundle parent = null;
    private long lastModified = -1L;

    public BundleInfo getBundleInfo() {
        return this.bundleInfo;
    }

    public void setBundleInfo(BundleInfo bundleInfo) {
        this.bundleInfo = bundleInfo;
    }

    public Bundle getParent() {
        return this.parent;
    }

    public void setParent(Bundle parent) {
        this.parent = parent;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getString(String key, Map variables) {
        return this.substitute(this.getString(key), variables);
    }

    public String convertKey(String userKey) {
        return userKey;
    }

    public String substitute(String value, Map values) {
        if (value == null || values == null) {
            return value;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Substituting value: " + value);
        }
        StringBuffer result = new StringBuffer(value.length());
        int startPos = 0;
        int endPos = 0;
        int lastPos = value.length();
        String varValue = "";
        String varKey = "";
        String oldKey = "";
        while (endPos < lastPos) {
            startPos = endPos;
            if ((endPos = value.indexOf(123, startPos)) == -1) {
                endPos = lastPos;
            }
            result.append(value.substring(startPos, endPos));
            if (endPos < lastPos) {
                ++endPos;
            }
            if (endPos >= lastPos) continue;
            startPos = endPos;
            if ((endPos = value.indexOf(125, startPos)) == -1) {
                endPos = lastPos;
            }
            if (!(oldKey = varKey).equals(varKey = value.substring(startPos, endPos))) {
                varValue = values.get(varKey);
            }
            if (varValue != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Substituting var: " + varKey + " --> " + varValue);
                }
                result.append((Object)varValue);
            } else {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn(this.bundleInfo + ": var not found: " + varKey);
                }
                result.append('{').append(varKey).append('}');
            }
            if (endPos >= lastPos) continue;
            ++endPos;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Returning substituted value: " + result);
        }
        return result.toString();
    }

    public abstract void init(String var1) throws Exception;

    public abstract void setLoadOnInit(boolean var1);

    public abstract String getString(String var1);
}

