/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.camelot;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.avalon.camelot.Container;
import org.apache.avalon.camelot.ContainerException;
import org.apache.avalon.camelot.Entry;

public abstract class AbstractContainer
implements Container {
    protected final HashMap m_entries = new HashMap();
    protected Class m_entryClass;

    public void add(String name, Entry entry) throws ContainerException {
        this.checkEntry(name, entry);
        this.m_entries.put(name, entry);
    }

    public void remove(String name) throws ContainerException {
        if (this.m_entries.remove(name) == null) {
            throw new ContainerException("Name " + name + " not contained");
        }
    }

    public Entry getEntry(String name) throws ContainerException {
        Entry entry = (Entry)this.m_entries.get(name);
        if (entry == null) {
            throw new ContainerException("Name " + name + " not contained");
        }
        return entry;
    }

    public Iterator list() {
        return this.m_entries.keySet().iterator();
    }

    protected Iterator listEntries() {
        return this.m_entries.values().iterator();
    }

    protected void checkEntry(String name, Entry entry) throws ContainerException {
        if (this.m_entries.get(name) != null) {
            throw new ContainerException("Can not add component to container because entry already exists with name " + name);
        }
        if (!this.isValidName(name)) {
            throw new ContainerException("Can not add component to container because invalid name " + name);
        }
        if (!this.isValidEntry(entry)) {
            throw new ContainerException("Can not add component to container because invalid entry for " + name);
        }
        if (!this.m_entryClass.isAssignableFrom(entry.getClass())) {
            throw new ContainerException("Only Entries of type " + this.m_entryClass.getName() + " may be placed in container.");
        }
    }

    protected boolean isValidName(String name) throws ContainerException {
        return true;
    }

    protected boolean isValidEntry(Entry entry) throws ContainerException {
        return true;
    }
}

