/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import org.apache.tools.ant.BuildException;

public class ExecuteWatchdog
implements Runnable {
    private Process process;
    private int timeout;
    private boolean watch = true;
    private Exception caught = null;

    public ExecuteWatchdog(int timeout) {
        if (timeout < 1) {
            throw new IllegalArgumentException("timeout lesser than 1.");
        }
        this.timeout = timeout;
    }

    public void checkException() throws BuildException {
        if (this.caught != null) {
            throw new BuildException("Exception in ExecuteWatchdog.run: " + this.caught.getMessage(), this.caught);
        }
    }

    public synchronized void run() {
        try {
            long now;
            long until = System.currentTimeMillis() + (long)this.timeout;
            while (this.watch && until > (now = System.currentTimeMillis())) {
                try {
                    this.wait(until - now);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.watch) {
                this.process.destroy();
            }
            this.stop();
        }
        catch (Exception e) {
            this.caught = e;
        }
    }

    public synchronized void start(Process process) {
        if (process == null) {
            throw new NullPointerException("process is null.");
        }
        if (this.process != null) {
            throw new IllegalStateException("Already running.");
        }
        this.watch = true;
        this.process = process;
        Thread thread = new Thread((Runnable)this, "WATCHDOG");
        thread.setDaemon(true);
        thread.start();
    }

    public synchronized void stop() {
        this.watch = false;
        this.notifyAll();
        this.process = null;
    }
}

