/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.Iterator;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public class NumberFunction
implements Function {
    public Object call(Context context, List args) throws FunctionCallException {
        if (args.size() == 1) {
            return NumberFunction.evaluate(args.get(0), context.getNavigator());
        }
        throw new FunctionCallException("number() requires one argument.");
    }

    public static Number evaluate(Object obj, Navigator nav) {
        if (obj instanceof Number) {
            return (Number)obj;
        }
        if (obj instanceof Boolean) {
            if (obj == Boolean.TRUE) {
                return new Integer(1);
            }
            return new Integer(0);
        }
        if (obj instanceof String) {
            String str = (String)obj;
            if (str.indexOf(".") >= 0) {
                try {
                    Double doubleValue = new Double(str);
                    return doubleValue;
                }
                catch (NumberFormatException numberFormatException) {
                    return new Double(Double.NaN);
                }
            }
            try {
                Integer integerValue = new Integer(str);
                return integerValue;
            }
            catch (NumberFormatException numberFormatException) {
                return new Double(Double.NaN);
            }
        }
        if (obj instanceof List || obj instanceof Iterator) {
            String strValue = StringFunction.evaluate(obj, nav);
            return NumberFunction.evaluate(StringFunction.evaluate(obj, nav), nav);
        }
        if (nav.isElement(obj) || nav.isAttribute(obj)) {
            return NumberFunction.evaluate(StringFunction.evaluate(obj, nav), nav);
        }
        return new Double(Double.NaN);
    }
}

