/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.naming;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import org.apache.avalon.excalibur.naming.AbstractContext;
import org.apache.avalon.excalibur.naming.ArrayNamingEnumeration;
import org.apache.avalon.excalibur.naming.Namespace;
import org.apache.avalon.excalibur.naming.NamingProvider;

public class RemoteContext
extends AbstractContext
implements Serializable {
    public static final String NAMESPACE_NAME = "org.apache.avalon.excalibur.naming.Namespace/NAME";
    public static final String NAMESPACE = "org.apache.avalon.excalibur.naming.Namespace";
    public static final String NAMING_PROVIDER = "org.apache.avalon.excalibur.naming.NamingProvider";
    protected transient NamingProvider m_provider;
    protected transient NameParser m_nameParser;
    protected transient Namespace m_namespace;
    protected Name m_baseName;

    protected void bind(Name name, Object object, boolean rebind) throws NamingException {
        if (this.isSelf(name)) {
            throw new InvalidNameException("Failed to bind self");
        }
        String className = null;
        object = this.getNamespace().getStateToBind(object, name, this, this.m_environment);
        if (object instanceof Reference) {
            className = ((Reference)object).getClassName();
        } else if (object instanceof Referenceable) {
            object = ((Referenceable)object).getReference();
            className = ((Reference)object).getClassName();
        } else {
            className = object.getClass().getName();
            try {
                object = new MarshalledObject<Object>(object);
            }
            catch (IOException ioe) {
                throw new NamingException("Only Reference, Referenceables and Serializable objects can be bound to context");
            }
        }
        try {
            if (rebind) {
                this.getProvider().rebind(this.getAbsoluteName(name), className, object);
            } else {
                this.getProvider().bind(this.getAbsoluteName(name), className, object);
            }
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public void close() {
        this.m_namespace = null;
        this.m_environment = null;
        this.m_provider = null;
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (this.isSelf(name)) {
            throw new InvalidNameException("Failed to create null subcontext");
        }
        Context result = null;
        try {
            result = this.getProvider().createSubcontext(this.getAbsoluteName(name));
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        this.fillInContext(result);
        return result;
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (this.isSelf(name)) {
            throw new InvalidNameException("Failed to destroy self");
        }
        try {
            this.getProvider().destroySubcontext(this.getAbsoluteName(name));
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public String getNameInNamespace() throws NamingException {
        return this.getAbsoluteName(this.getNameParser().parse("")).toString();
    }

    public NamingEnumeration list(Name name) throws NamingException {
        try {
            Object[] result = this.getProvider().list(this.getAbsoluteName(name));
            return new ArrayNamingEnumeration(this, this.m_namespace, result);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        try {
            Object[] result = this.getProvider().listBindings(this.getAbsoluteName(name));
            int i = 0;
            while (i < result.length) {
                Object object = result[i].getObject();
                if (object instanceof Context) {
                    this.fillInContext((Context)object);
                }
                ++i;
            }
            return new ArrayNamingEnumeration(this, this.m_namespace, result);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public Object lookup(Name name) throws NamingException {
        if (this.isSelf(name)) {
            return new RemoteContext(this.m_environment, this.m_baseName);
        }
        Object object = null;
        try {
            object = this.getProvider().lookup(this.getAbsoluteName(name));
            if (object instanceof MarshalledObject) {
                object = ((MarshalledObject)object).get();
            }
            if ((object = this.getNamespace().getObjectInstance(object, name, this, this.m_environment)) instanceof Context) {
                this.fillInContext((Context)object);
            }
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        return object;
    }

    public void unbind(Name name) throws NamingException {
        if (this.isSelf(name)) {
            throw new InvalidNameException("Failed to unbind self");
        }
        try {
            this.getProvider().unbind(this.getAbsoluteName(name));
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    protected void fillInContext(Context object) throws NamingException {
        Iterator keys = this.m_environment.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = this.m_environment.get(key);
            object.addToEnvironment(key, value);
        }
    }

    protected Namespace getNamespace() throws NamingException {
        if (this.m_namespace == null) {
            Object object = this.m_environment.get(NAMESPACE);
            if (!(object instanceof Namespace) || object == null) {
                throw new ConfigurationException("Context does not contain Namespace");
            }
            this.m_namespace = (Namespace)object;
        }
        return this.m_namespace;
    }

    protected NamingProvider getProvider() throws NamingException {
        if (this.m_provider == null) {
            Object object = this.m_environment.get(NAMING_PROVIDER);
            if (!(object instanceof NamingProvider) || object == null) {
                throw new ConfigurationException("Context does not contain provider");
            }
            this.m_provider = (NamingProvider)object;
        }
        return this.m_provider;
    }

    protected NameParser getNameParser() throws NamingException {
        if (this.m_nameParser == null) {
            try {
                this.m_nameParser = this.getProvider().getNameParser();
            }
            catch (Exception e) {
                throw this.handleException(e);
            }
        }
        return this.m_nameParser;
    }

    protected Name getAbsoluteName(Name name) throws NamingException {
        return this.composeName(name, this.m_baseName);
    }

    protected NamingException handleException(Exception e) {
        if (e instanceof NamingException) {
            return (NamingException)e;
        }
        return new CommunicationException(e.toString());
    }

    public RemoteContext() {
    }

    public RemoteContext(Hashtable environment, Name baseName) throws NamingException {
        super(environment);
        this.m_baseName = baseName;
    }
}

