/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.jmx.tags;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.tags.AbstractProgramElementTagsHandler;
import xdoclet.tags.MethodTagsHandler;
import xdoclet.util.DocletUtil;
import xdoclet.util.Translator;

public class JMXTagsHandler
extends AbstractProgramElementTagsHandler {
    protected MethodTagsHandler handler = new MethodTagsHandler();
    protected Map attributes = Collections.synchronizedMap(new HashMap());
    protected int index = 0;

    public String mbeanName() throws XDocletException {
        return this.getMBeanName(XDocletTagSupport.getCurrentClass());
    }

    public void ifIsGetterMethod(String template, Properties attributes) throws XDocletException {
        if (this.isGetterMethod()) {
            this.generate(template);
        }
    }

    public void ifIsSetterMethod(String template, Properties attributes) throws XDocletException {
        if (this.isSetterMethod()) {
            this.generate(template);
        }
    }

    public void ifHasAttributeDescription(String template, Properties attributes) throws XDocletException {
        boolean hasGetterMethod = false;
        String name = this.handler.methodNameWithoutPrefix();
        String description = this.getMethodTagValue("jmx:managed-attribute", "description", -1, null, null, true);
        MethodDoc[] methods = XDocletTagSupport.getCurrentClass().methods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].name().equals("get" + name) || methods[i].name().equals("is" + name)) {
                hasGetterMethod = true;
            }
            ++i;
        }
        if (this.isSetterMethod() && !hasGetterMethod || this.isGetterMethod()) {
            ((Hashtable)attributes).put(name, description);
            this.generate(template);
        }
    }

    public void forAllIndexedMethodParams(String template, Properties attributes) throws XDocletException {
        Tag[] tags = DocletUtil.getTagsByName((MemberDoc)XDocletTagSupport.getCurrentMethod(), "jmx:managed-operation-parameter");
        this.index = 0;
        int i = 1;
        while (i < tags.length) {
            this.generate(template);
            ++this.index;
            ++i;
        }
    }

    public void forAllIndexedConstructorParams(String template, Properties attributes) throws XDocletException {
        Tag[] tags = DocletUtil.getTagsByName((MemberDoc)XDocletTagSupport.getCurrentConstructor(), "jmx:managed-constructor-parameter");
        this.index = 0;
        int i = 1;
        while (i < tags.length) {
            this.generate(template);
            ++this.index;
            ++i;
        }
    }

    public String indexedMethodParamValue(Properties attributes) throws XDocletException {
        String tagName = attributes.getProperty("tagName");
        String paramName = attributes.getProperty("paramName");
        if (tagName == null || paramName == null) {
            throw new XDocletException(Translator.getString("xdoclet.jmx.Messages", "missing_attribute"));
        }
        Tag[] tags = DocletUtil.getTagsByName((MemberDoc)XDocletTagSupport.getCurrentMethod(), tagName);
        String tagContent = tags[this.index].text();
        int begin = tagContent.indexOf(paramName + "=\"") + paramName.length() + 2;
        int end = tagContent.indexOf("\"", begin);
        return tagContent.substring(begin, end);
    }

    public String indexedConstructorParamValue(Properties attributes) throws XDocletException {
        String tagName = attributes.getProperty("tagName");
        String paramName = attributes.getProperty("paramName");
        if (tagName == null || paramName == null) {
            throw new XDocletException(Translator.getString("xdoclet.jmx.Messages", "missing_attribute"));
        }
        Tag[] tags = DocletUtil.getTagsByName((MemberDoc)XDocletTagSupport.getCurrentConstructor(), tagName);
        String tagContent = tags[this.index].text();
        int begin = tagContent.indexOf(paramName + "=\"") + paramName.length() + 2;
        int end = tagContent.indexOf("\"", begin);
        return tagContent.substring(begin, end);
    }

    public String constructorSignature() throws XDocletException {
        ConstructorDoc currentConstructor = XDocletTagSupport.getCurrentConstructor();
        String signature = currentConstructor.signature();
        while (signature.indexOf(" ") != -1) {
            int index = signature.indexOf(" ");
            String before = signature.substring(0, index);
            String after = signature.substring(index + 1, signature.length());
            signature = before + after;
        }
        return "public " + currentConstructor.qualifiedName() + signature;
    }

    protected String getMBeanName(ClassDoc clazz) throws XDocletException {
        String bean_val = DocletUtil.getText((Doc)clazz, "jmx:mbean");
        if (bean_val == null) {
            throw new XDocletException(Translator.getString("class_tag_expected", new String[]{"@jmx:mbean", clazz.qualifiedName()}));
        }
        String param_val = XDocletTagSupport.getParameterValue(XDocletTagSupport.getCurrentClass(), bean_val, "name", -1);
        if (param_val == null) {
            throw new XDocletException(Translator.getString("class_tag_parameter_expected", new String[]{"name", "@jmx:mbean", clazz.qualifiedName()}));
        }
        return param_val;
    }

    protected boolean isGetterMethod() {
        String name = XDocletTagSupport.getCurrentMethod().name();
        Type retType = XDocletTagSupport.getCurrentMethod().returnType();
        Parameter[] params = XDocletTagSupport.getCurrentMethod().parameters();
        return !retType.toString().equals("void") && params.length == 0 && (name.startsWith("get") || name.startsWith("is") && retType.toString().equals("boolean"));
    }

    protected boolean isSetterMethod() {
        String name = XDocletTagSupport.getCurrentMethod().name();
        Type retType = XDocletTagSupport.getCurrentMethod().returnType();
        Parameter[] params = XDocletTagSupport.getCurrentMethod().parameters();
        return retType.toString().equals("void") && params.length == 1 && name.startsWith("set");
    }
}

