/*
 * Decompiled with CFR 0.152.
 */
package junit.swingui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import junit.util.StringUtil;

class TraceFrame
extends JFrame {
    private JButton fButton = null;
    private JTextArea fTextArea = null;

    public TraceFrame() {
        this.getContentPane().setLayout(new GridBagLayout());
        ((Component)this).setBackground(SystemColor.control);
        ((Component)this).setSize(500, 250);
        this.setTitle("Stack Trace");
        this.fTextArea = new JTextArea();
        this.fTextArea.setRows(10);
        this.fTextArea.setColumns(60);
        this.fTextArea.setEditable(false);
        JScrollPane scrolledText = new JScrollPane(this.fTextArea);
        this.fButton = new JButton("Close");
        this.fButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                TraceFrame.this.dispose();
            }
        });
        GridBagConstraints constraintsStackTextArea = new GridBagConstraints();
        constraintsStackTextArea.gridx = 0;
        constraintsStackTextArea.gridy = 0;
        constraintsStackTextArea.gridwidth = 1;
        constraintsStackTextArea.gridheight = 1;
        constraintsStackTextArea.fill = 1;
        constraintsStackTextArea.anchor = 10;
        constraintsStackTextArea.weightx = 1.0;
        constraintsStackTextArea.weighty = 1.0;
        constraintsStackTextArea.insets = new Insets(8, 8, 8, 8);
        this.getContentPane().add((Component)scrolledText, constraintsStackTextArea);
        GridBagConstraints constraintsCloseButton = new GridBagConstraints();
        constraintsCloseButton.gridx = 0;
        constraintsCloseButton.gridy = 1;
        constraintsCloseButton.gridwidth = 1;
        constraintsCloseButton.gridheight = 1;
        constraintsCloseButton.anchor = 13;
        constraintsCloseButton.weightx = 0.0;
        constraintsCloseButton.weighty = 0.0;
        constraintsCloseButton.insets = new Insets(0, 8, 8, 8);
        this.getContentPane().add((Component)this.fButton, constraintsCloseButton);
        this.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                TraceFrame.this.dispose();
            }
        });
    }

    public void showTrace(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        StringBuffer buffer = stringWriter.getBuffer();
        this.fTextArea.setText(StringUtil.truncate(buffer.toString(), 5000));
        this.fTextArea.select(0, 0);
    }
}

