/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.framework;

import java.util.StringTokenizer;
import org.apache.xerces.framework.XMLDocumentHandler;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.DefaultEntityHandler;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.XMLCharacterProperties;
import org.apache.xerces.validators.common.GrammarResolver;
import org.apache.xerces.validators.common.XMLAttributeDecl;
import org.apache.xerces.validators.common.XMLElementDecl;
import org.apache.xerces.validators.dtd.DTDGrammar;

public final class XMLDTDScanner {
    private static final char[] version_string = new char[]{'v', 'e', 'r', 's', 'i', 'o', 'n'};
    private static final char[] element_string = new char[]{'E', 'L', 'E', 'M', 'E', 'N', 'T'};
    private static final char[] empty_string = new char[]{'E', 'M', 'P', 'T', 'Y'};
    private static final char[] any_string = new char[]{'A', 'N', 'Y'};
    private static final char[] pcdata_string = new char[]{'#', 'P', 'C', 'D', 'A', 'T', 'A'};
    private static final char[] attlist_string = new char[]{'A', 'T', 'T', 'L', 'I', 'S', 'T'};
    private static final char[] cdata_string = new char[]{'C', 'D', 'A', 'T', 'A'};
    private static final char[] id_string = new char[]{'I', 'D'};
    private static final char[] ref_string = new char[]{'R', 'E', 'F'};
    private static final char[] entit_string = new char[]{'E', 'N', 'T', 'I', 'T'};
    private static final char[] ies_string = new char[]{'I', 'E', 'S'};
    private static final char[] nmtoken_string = new char[]{'N', 'M', 'T', 'O', 'K', 'E', 'N'};
    private static final char[] notation_string = new char[]{'N', 'O', 'T', 'A', 'T', 'I', 'O', 'N'};
    private static final char[] required_string = new char[]{'#', 'R', 'E', 'Q', 'U', 'I', 'R', 'E', 'D'};
    private static final char[] implied_string = new char[]{'#', 'I', 'M', 'P', 'L', 'I', 'E', 'D'};
    private static final char[] fixed_string = new char[]{'#', 'F', 'I', 'X', 'E', 'D'};
    private static final char[] include_string = new char[]{'I', 'N', 'C', 'L', 'U', 'D', 'E'};
    private static final char[] ignore_string = new char[]{'I', 'G', 'N', 'O', 'R', 'E'};
    private static final char[] entity_string = new char[]{'E', 'N', 'T', 'I', 'T', 'Y'};
    private static final char[] system_string = new char[]{'S', 'Y', 'S', 'T', 'E', 'M'};
    private static final char[] public_string = new char[]{'P', 'U', 'B', 'L', 'I', 'C'};
    private static final char[] ndata_string = new char[]{'N', 'D', 'A', 'T', 'A'};
    private static final char[] encoding_string = new char[]{'e', 'n', 'c', 'o', 'd', 'i', 'n', 'g'};
    private DTDGrammar fDTDGrammar = null;
    private GrammarResolver fGrammarResolver = null;
    private boolean fNamespacesEnabled = false;
    private boolean fValidationEnabled = false;
    private XMLElementDecl fTempElementDecl = new XMLElementDecl();
    private XMLAttributeDecl fTempAttributeDecl = new XMLAttributeDecl();
    private QName fElementQName = new QName();
    private QName fAttributeQName = new QName();
    private QName fElementRefQName = new QName();
    private EventHandler fEventHandler = null;
    private XMLDocumentHandler.DTDHandler fDTDHandler = null;
    private StringPool fStringPool = null;
    private XMLErrorReporter fErrorReporter = null;
    private XMLEntityHandler fEntityHandler = null;
    private XMLEntityHandler.EntityReader fEntityReader = null;
    private XMLEntityHandler.CharBuffer fLiteralData = null;
    private int fReaderId = -1;
    private int fSystemLiteral = -1;
    private int fPubidLiteral = -1;
    private int[] fOpStack = null;
    private int[] fNodeIndexStack = null;
    private int[] fPrevNodeIndexStack = null;
    private int fScannerState = -1;
    private int fIncludeSectDepth = 0;
    private int fDoctypeReader = -1;
    private int fExternalSubsetReader = -1;
    private int fDefaultAttValueReader = -1;
    private int fDefaultAttValueElementType = -1;
    private int fDefaultAttValueAttrName = -1;
    private int fDefaultAttValueOffset = -1;
    private int fDefaultAttValueMark = -1;
    private int fEntityValueReader = -1;
    private int fEntityValueMark = -1;
    private int fXMLSymbol = -1;
    private int fXMLNamespace = -1;
    private int fXMLSpace = -1;
    private int fDefault = -1;
    private int fPreserve = -1;
    private int fScannerMarkupDepth = 0;
    private int fScannerParenDepth = 0;
    private static final int SCANNER_STATE_INVALID = -1;
    private static final int SCANNER_STATE_END_OF_INPUT = 0;
    private static final int SCANNER_STATE_DOCTYPEDECL = 50;
    private static final int SCANNER_STATE_MARKUP_DECL = 51;
    private static final int SCANNER_STATE_TEXTDECL = 53;
    private static final int SCANNER_STATE_COMMENT = 54;
    private static final int SCANNER_STATE_PI = 55;
    private static final int SCANNER_STATE_DEFAULT_ATTRIBUTE_VALUE = 56;
    private static final int SCANNER_STATE_CONTENTSPEC = 57;
    private static final int SCANNER_STATE_ENTITY_VALUE = 58;
    private static final int SCANNER_STATE_SYSTEMLITERAL = 59;
    private static final int SCANNER_STATE_PUBIDLITERAL = 60;
    private QName fElementDeclQName = new QName();

    public XMLDTDScanner(StringPool stringPool, XMLErrorReporter xMLErrorReporter, XMLEntityHandler xMLEntityHandler, XMLEntityHandler.CharBuffer charBuffer) {
        this.fStringPool = stringPool;
        this.fErrorReporter = xMLErrorReporter;
        this.fEntityHandler = xMLEntityHandler;
        this.fLiteralData = charBuffer;
        this.init();
    }

    private void abortMarkup(int n, int n2) throws Exception {
        this.reportFatalXMLError(n, n2);
        this.skipPastEndOfCurrentMarkup();
    }

    private void abortMarkup(int n, int n2, int n3) throws Exception {
        this.reportFatalXMLError(n, n2, n3);
        this.skipPastEndOfCurrentMarkup();
    }

    private void abortMarkup(int n, int n2, int n3, int n4) throws Exception {
        this.reportFatalXMLError(n, n2, n3, n4);
        this.skipPastEndOfCurrentMarkup();
    }

    private void abortMarkup(int n, int n2, String string) throws Exception {
        this.reportFatalXMLError(n, n2, string);
        this.skipPastEndOfCurrentMarkup();
    }

    private int addAttDef(QName qName, QName qName2, int n, boolean bl, int n2, int n3, int n4, boolean bl2) throws Exception {
        int n5;
        if (this.fDTDHandler != null) {
            String string = n2 != -1 ? this.fStringPool.stringListAsString(n2) : null;
            this.fDTDHandler.attlistDecl(qName, qName2, n, bl, string, n3, n4);
        }
        if ((n5 = this.fDTDGrammar.getElementDeclIndex(qName, -1)) != -1) {
            int n6 = this.fDTDGrammar.getFirstAttributeDeclIndex(n5);
            int n7 = -1;
            int n8 = -1;
            while (n6 != -1) {
                this.fDTDGrammar.getAttributeDecl(n6, this.fTempAttributeDecl);
                if (this.fStringPool.equalNames(this.fTempAttributeDecl.name.rawname, qName2.rawname)) {
                    return -1;
                }
                if (this.fValidationEnabled) {
                    if (n == 3 && this.fTempAttributeDecl.type == 3) {
                        n7 = this.fTempAttributeDecl.name.rawname;
                    }
                    if (n == 6 && this.fTempAttributeDecl.type == 6) {
                        n8 = this.fTempAttributeDecl.name.rawname;
                    }
                }
                n6 = this.fDTDGrammar.getNextAttributeDeclIndex(n6);
            }
            if (this.fValidationEnabled) {
                if (n7 != -1) {
                    Object[] objectArray = new Object[]{this.fStringPool.toString(qName.rawname), this.fStringPool.toString(n7), this.fStringPool.toString(qName2.rawname)};
                    this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 86, 81, objectArray, 1);
                    return -1;
                }
                if (n8 != -1) {
                    Object[] objectArray = new Object[]{this.fStringPool.toString(qName.rawname), this.fStringPool.toString(n8), this.fStringPool.toString(qName2.rawname)};
                    this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 121, 143, objectArray, 1);
                    return -1;
                }
            }
        }
        return this.fDTDGrammar.addAttDef(qName, qName2, n, bl, n2, n3, n4, bl2);
    }

    public void checkForAttributeNameWithPEReference(XMLEntityHandler.EntityReader entityReader, char c, QName qName) throws Exception {
        if (!this.fNamespacesEnabled) {
            qName.clear();
            qName.rawname = qName.localpart = entityReader.scanName(c);
            return;
        }
        entityReader.scanQName(c, qName);
        if (entityReader.lookingAtChar(':', false)) {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 126, 139, null, 2);
            entityReader.skipPastNmtoken(' ');
        }
    }

    public void checkForElementTypeWithPEReference(XMLEntityHandler.EntityReader entityReader, char c, QName qName) throws Exception {
        if (!this.fNamespacesEnabled) {
            qName.clear();
            qName.rawname = qName.localpart = entityReader.scanName(c);
            return;
        }
        entityReader.scanQName(c, qName);
        if (entityReader.lookingAtChar(':', false)) {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 126, 139, null, 2);
            entityReader.skipPastNmtoken(' ');
        }
    }

    public int checkForNameWithPEReference(XMLEntityHandler.EntityReader entityReader, char c) throws Exception {
        int n = entityReader.scanName(c);
        return n;
    }

    public int checkForNmtokenWithPEReference(XMLEntityHandler.EntityReader entityReader, char c) throws Exception {
        int n = entityReader.currentOffset();
        entityReader.skipPastNmtoken(c);
        int n2 = entityReader.currentOffset() - n;
        if (n2 == 0) {
            return -1;
        }
        int n3 = entityReader.addSymbol(n, n2);
        return n3;
    }

    private boolean checkForPEReference(boolean bl) throws Exception {
        boolean bl2 = true;
        if (bl) {
            bl2 = this.fEntityReader.lookingAtSpace(true);
        }
        this.fEntityReader.skipPastSpaces();
        if (!this.getReadingExternalEntity()) {
            return bl2;
        }
        if (!this.fEntityReader.lookingAtChar('%', true)) {
            return bl2;
        }
        do {
            int n = this.fEntityReader.currentOffset();
            this.fEntityReader.skipPastName(';');
            int n2 = this.fEntityReader.currentOffset() - n;
            if (n2 == 0) {
                this.reportFatalXMLError(48, 50);
            } else if (!this.fEntityReader.lookingAtChar(';', true)) {
                this.reportFatalXMLError(49, 51, this.fEntityReader.addString(n, n2));
            } else {
                int n3 = this.fEntityReader.addSymbol(n, n2);
                int n4 = this.fScannerState == 57 ? this.parenDepth() : this.markupDepth();
                this.fEntityHandler.startReadingFromEntity(n3, n4, 5);
            }
            this.fEntityReader.skipPastSpaces();
        } while (this.fEntityReader.lookingAtChar('%', true));
        return true;
    }

    private int decreaseMarkupDepth() {
        return this.fScannerMarkupDepth--;
    }

    private void decreaseParenDepth() {
        --this.fScannerParenDepth;
    }

    public void endOfInput(int n, boolean bl) throws Exception {
        if (this.fValidationEnabled) {
            int n2 = this.fEntityHandler.getReaderDepth();
            if (this.getReadingContentSpec()) {
                int n3 = this.parenDepth();
                if (n2 != n3) {
                    this.reportRecoverableXMLError(74, 75, n);
                }
            } else {
                int n4 = this.markupDepth();
                if (n2 != n4) {
                    this.reportRecoverableXMLError(73, 74, n);
                }
            }
        }
        bl = this.fReaderId != this.fExternalSubsetReader;
        switch (this.fScannerState) {
            case -1: {
                throw new RuntimeException("FWK004 XMLDTDScanner.endOfInput: cannot happen: 2\n2");
            }
            case 51: {
                if (bl || this.fIncludeSectDepth <= 0) break;
                this.reportFatalXMLError(23, 22);
                break;
            }
            case 50: {
                throw new RuntimeException("FWK004 XMLDTDScanner.endOfInput: cannot happen: 2.5\n2.5");
            }
            case 59: {
                if (bl) break;
                this.reportFatalXMLError(100, 140);
                break;
            }
            case 60: {
                if (bl) break;
                this.reportFatalXMLError(101, 141);
                break;
            }
            case 54: {
                if (bl || this.getReadingExternalEntity()) break;
                this.reportFatalXMLError(163, 133);
                break;
            }
            case 55: {
                if (!bl) {
                    this.reportFatalXMLError(164, 134);
                    break;
                }
                this.reportFatalXMLError(165, 68);
                break;
            }
            case 56: {
                if (!bl) {
                    this.reportFatalXMLError(151, 136, this.fDefaultAttValueElementType, this.fDefaultAttValueAttrName);
                    break;
                }
                if (this.fReaderId == this.fDefaultAttValueReader) break;
                this.fEntityReader.append(this.fLiteralData, this.fDefaultAttValueMark, this.fDefaultAttValueOffset - this.fDefaultAttValueMark);
                break;
            }
            case 58: {
                if (this.fReaderId == this.fEntityValueReader) break;
                this.fEntityReader.append(this.fLiteralData, this.fEntityValueMark, this.fEntityReader.currentOffset() - this.fEntityValueMark);
                break;
            }
            default: {
                throw new RuntimeException("FWK004 XMLDTDScanner.endOfInput: cannot happen: 3\n3");
            }
            case 0: 
            case 53: 
            case 57: 
        }
        if (!bl) {
            this.setScannerState(0);
        }
    }

    public boolean getReadingContentSpec() {
        return this.getScannerState() == 57;
    }

    public boolean getReadingExternalEntity() {
        return this.fReaderId != this.fDoctypeReader;
    }

    private int getScannerState() {
        return this.fScannerState;
    }

    private int increaseMarkupDepth() {
        return this.fScannerMarkupDepth++;
    }

    private void increaseParenDepth() {
        ++this.fScannerParenDepth;
    }

    private void init() {
        this.fXMLSymbol = this.fStringPool.addSymbol("xml");
        this.fXMLNamespace = this.fStringPool.addSymbol("http://www.w3.org/XML/1998/namespace");
        this.fXMLSpace = this.fStringPool.addSymbol("xml:space");
        this.fDefault = this.fStringPool.addSymbol("default");
        this.fPreserve = this.fStringPool.addSymbol("preserve");
    }

    private void initializeContentModelStack(int n) {
        if (this.fOpStack == null) {
            this.fOpStack = new int[8];
            this.fNodeIndexStack = new int[8];
            this.fPrevNodeIndexStack = new int[8];
        } else if (n == this.fOpStack.length) {
            int[] nArray = new int[n * 2];
            System.arraycopy(this.fOpStack, 0, nArray, 0, n);
            this.fOpStack = nArray;
            nArray = new int[n * 2];
            System.arraycopy(this.fNodeIndexStack, 0, nArray, 0, n);
            this.fNodeIndexStack = nArray;
            nArray = new int[n * 2];
            System.arraycopy(this.fPrevNodeIndexStack, 0, nArray, 0, n);
            this.fPrevNodeIndexStack = nArray;
        }
        this.fOpStack[n] = -1;
        this.fNodeIndexStack[n] = -1;
        this.fPrevNodeIndexStack[n] = -1;
    }

    public int markupDepth() {
        return this.fScannerMarkupDepth;
    }

    public int normalizeDefaultAttValue(QName qName, int n, int n2, int n3, boolean bl) throws Exception {
        String string = this.fStringPool.toString(n);
        if (bl) {
            String string2;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            StringBuffer stringBuffer = new StringBuffer(string.length());
            boolean bl2 = true;
            if (stringTokenizer.hasMoreTokens()) {
                while (true) {
                    string2 = stringTokenizer.nextToken();
                    if (n2 == 5) {
                        if (this.fValidationEnabled && !XMLCharacterProperties.validNmtoken(string2)) {
                            bl2 = false;
                        }
                    } else if (n2 == 4 || n2 == 1) {
                        if (this.fValidationEnabled && !XMLCharacterProperties.validName(string2)) {
                            bl2 = false;
                        }
                        if (this.fValidationEnabled && n2 == 1 && !((DefaultEntityHandler)this.fEntityHandler).isUnparsedEntity(n)) {
                            this.reportRecoverableXMLError(79, 77, this.fStringPool.toString(qName.rawname), string2);
                        }
                    }
                    stringBuffer.append(string2);
                    if (!stringTokenizer.hasMoreTokens()) break;
                    stringBuffer.append(' ');
                }
            }
            string2 = stringBuffer.toString();
            if (this.fValidationEnabled && (!bl2 || string2.length() == 0)) {
                this.reportRecoverableXMLError(168, 145, this.fStringPool.toString(qName.rawname), string2);
            }
            if (!string2.equals(string)) {
                n = this.fStringPool.addString(string2);
            }
            return n;
        }
        String string3 = string.trim();
        if (this.fValidationEnabled) {
            n = string3 != string ? this.fStringPool.addSymbol(string3) : this.fStringPool.addSymbol(n);
            if (n2 == 1 || n2 == 3 || n2 == 4 || n2 == 6) {
                if (n2 == 1 && !((DefaultEntityHandler)this.fEntityHandler).isUnparsedEntity(n)) {
                    this.reportRecoverableXMLError(79, 77, this.fStringPool.toString(qName.rawname), string3);
                }
                if (!XMLCharacterProperties.validName(string3)) {
                    this.reportRecoverableXMLError(168, 145, this.fStringPool.toString(qName.rawname), string3);
                }
            } else if (!(n2 != 5 && n2 != 2 || XMLCharacterProperties.validNmtoken(string3))) {
                this.reportRecoverableXMLError(168, 145, this.fStringPool.toString(qName.rawname), string3);
            }
            if (!(n2 != 6 && n2 != 2 || this.fStringPool.stringInList(n3, n))) {
                this.reportRecoverableXMLError(168, 145, this.fStringPool.toString(qName.rawname), string3);
            }
        } else if (string3 != string) {
            n = this.fStringPool.addSymbol(string3);
        }
        return n;
    }

    public int parenDepth() {
        return this.fScannerParenDepth;
    }

    public void readerChange(XMLEntityHandler.EntityReader entityReader, int n) throws Exception {
        this.fEntityReader = entityReader;
        this.fReaderId = n;
        if (this.fScannerState == 56) {
            this.fDefaultAttValueMark = this.fDefaultAttValueOffset = this.fEntityReader.currentOffset();
        } else if (this.fScannerState == 58) {
            this.fEntityValueMark = this.fEntityReader.currentOffset();
        }
    }

    private void reportFatalXMLError(int n, int n2) throws Exception {
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, null, 2);
    }

    private void reportFatalXMLError(int n, int n2, int n3) throws Exception {
        Object[] objectArray = new Object[]{this.fStringPool.toString(n3)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 2);
    }

    private void reportFatalXMLError(int n, int n2, int n3, int n4) throws Exception {
        Object[] objectArray = new Object[]{this.fStringPool.toString(n3), this.fStringPool.toString(n4)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 2);
    }

    private void reportFatalXMLError(int n, int n2, String string) throws Exception {
        Object[] objectArray = new Object[]{string};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 2);
    }

    private void reportFatalXMLError(int n, int n2, String string, String string2) throws Exception {
        Object[] objectArray = new Object[]{string, string2};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 2);
    }

    private void reportFatalXMLError(int n, int n2, String string, String string2, String string3) throws Exception {
        Object[] objectArray = new Object[]{string, string2, string3};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 2);
    }

    protected void reportRecoverableXMLError(int n, int n2, int n3) throws Exception {
        Object[] objectArray = new Object[]{this.fStringPool.toString(n3)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2, String string) throws Exception {
        Object[] objectArray = new Object[]{string};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2, String string, String string2) throws Exception {
        Object[] objectArray = new Object[]{string, string2};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    public void reset(StringPool stringPool, XMLEntityHandler.CharBuffer charBuffer) throws Exception {
        this.fStringPool = stringPool;
        this.fLiteralData = charBuffer;
        this.fEntityReader = null;
        this.fReaderId = -1;
        this.fSystemLiteral = -1;
        this.fPubidLiteral = -1;
        this.fOpStack = null;
        this.fNodeIndexStack = null;
        this.fPrevNodeIndexStack = null;
        this.fScannerState = -1;
        this.fIncludeSectDepth = 0;
        this.fDoctypeReader = -1;
        this.fExternalSubsetReader = -1;
        this.fDefaultAttValueReader = -1;
        this.fDefaultAttValueElementType = -1;
        this.fDefaultAttValueAttrName = -1;
        this.fDefaultAttValueOffset = -1;
        this.fDefaultAttValueMark = -1;
        this.fEntityValueReader = -1;
        this.fEntityValueMark = -1;
        this.fScannerMarkupDepth = 0;
        this.fScannerParenDepth = 0;
        this.init();
    }

    private void restoreScannerState(int n) {
        if (this.fScannerState != 0) {
            this.fScannerState = n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void scanAttlistDecl() throws Exception {
        if (!this.checkForPEReference(true)) {
            this.abortMarkup(141, 112);
            return;
        }
        this.checkForElementTypeWithPEReference(this.fEntityReader, ' ', this.fElementQName);
        int n = this.fElementQName.rawname;
        if (n == -1) {
            this.abortMarkup(125, 111);
            return;
        }
        int n2 = this.fDTDGrammar.getElementDeclIndex(this.fElementQName, -1);
        if (n2 == -1) {
            n2 = this.fDTDGrammar.addElementDecl(this.fElementQName);
        }
        boolean bl = this.checkForPEReference(true);
        if (this.fEntityReader.lookingAtChar('>', true)) {
            this.decreaseMarkupDepth();
            return;
        }
        if (!bl) {
            if (this.fEntityReader.lookingAtSpace(true)) {
                this.fEntityReader.skipPastSpaces();
            } else {
                this.reportFatalXMLError(138, 113);
            }
        } else if (this.fEntityReader.lookingAtSpace(true)) {
            this.fEntityReader.skipPastSpaces();
        }
        if (this.fEntityReader.lookingAtChar('>', true)) {
            this.decreaseMarkupDepth();
            return;
        }
        while (true) {
            int n3;
            int n4;
            boolean bl2;
            int n5;
            int n6;
            block55: {
                block58: {
                    block57: {
                        this.checkForAttributeNameWithPEReference(this.fEntityReader, ' ', this.fAttributeQName);
                        n6 = this.fAttributeQName.rawname;
                        if (n6 == -1) {
                            this.abortMarkup(58, 70, this.fElementQName.rawname);
                            return;
                        }
                        if (!this.checkForPEReference(true)) {
                            this.abortMarkup(139, 113);
                            return;
                        }
                        n5 = -1;
                        bl2 = false;
                        n4 = -1;
                        if (!this.fEntityReader.skippedString(cdata_string)) break block57;
                        n5 = 0;
                        break block55;
                    }
                    if (!this.fEntityReader.skippedString(id_string)) break block58;
                    if (!this.fEntityReader.skippedString(ref_string)) {
                        n5 = 3;
                        break block55;
                    } else if (!this.fEntityReader.lookingAtChar('S', true)) {
                        n5 = 4;
                        break block55;
                    } else {
                        n5 = 4;
                        bl2 = true;
                    }
                    break block55;
                }
                if (this.fEntityReader.skippedString(entit_string)) {
                    if (this.fEntityReader.lookingAtChar('Y', true)) {
                        n5 = 1;
                    } else {
                        if (!this.fEntityReader.skippedString(ies_string)) {
                            this.abortMarkup(59, 71, n, n6);
                            return;
                        }
                        n5 = 1;
                        bl2 = true;
                    }
                } else if (this.fEntityReader.skippedString(nmtoken_string)) {
                    if (this.fEntityReader.lookingAtChar('S', true)) {
                        n5 = 5;
                        bl2 = true;
                    } else {
                        n5 = 5;
                    }
                } else if (this.fEntityReader.skippedString(notation_string)) {
                    if (!this.checkForPEReference(true)) {
                        this.abortMarkup(136, 115, n, n6);
                        return;
                    }
                    if (!this.fEntityReader.lookingAtChar('(', true)) {
                        this.abortMarkup(130, 114, n, n6);
                        return;
                    }
                    this.increaseParenDepth();
                    n5 = 6;
                    n4 = this.scanEnumeration(n, n6, true);
                    if (n4 == -1) {
                        this.skipPastEndOfCurrentMarkup();
                        return;
                    }
                } else {
                    if (!this.fEntityReader.lookingAtChar('(', true)) {
                        this.abortMarkup(59, 71, n, n6);
                        return;
                    }
                    this.increaseParenDepth();
                    n5 = 2;
                    n4 = this.scanEnumeration(n, n6, false);
                    if (n4 == -1) {
                        this.skipPastEndOfCurrentMarkup();
                        return;
                    }
                }
            }
            if (!this.checkForPEReference(true)) {
                this.abortMarkup(140, 113, n, n6);
                return;
            }
            int n7 = -1;
            int n8 = -1;
            if (this.fEntityReader.skippedString(required_string)) {
                n7 = 2;
            } else if (this.fEntityReader.skippedString(implied_string)) {
                n7 = 0;
            } else {
                if (this.fEntityReader.skippedString(fixed_string)) {
                    if (!this.fEntityReader.lookingAtSpace(true)) {
                        this.abortMarkup(135, 116, n, n6);
                        return;
                    }
                    this.fEntityReader.skipPastSpaces();
                    n7 = 1;
                } else {
                    n7 = 3;
                }
                n8 = this.scanDefaultAttValue(this.fElementQName, this.fAttributeQName, n5, n4);
                if (n8 != -1 && n5 != 0) {
                    n8 = this.normalizeDefaultAttValue(this.fAttributeQName, n8, n5, n4, bl2);
                }
                if (n8 == -1) {
                    this.skipPastEndOfCurrentMarkup();
                    return;
                }
            }
            if (n6 == this.fXMLSpace) {
                int n9;
                n3 = 0;
                if (n5 == 2 && (n9 = n4) != -1) {
                    int n10 = n3 = (this.fStringPool.stringListLength(n9) != 1 || !this.fStringPool.stringInList(n9, this.fDefault) && !this.fStringPool.stringInList(n9, this.fPreserve)) && (this.fStringPool.stringListLength(n9) != 2 || !this.fStringPool.stringInList(n9, this.fDefault) || !this.fStringPool.stringInList(n9, this.fPreserve)) ? 0 : 1;
                }
                if (n3 == 0) {
                    this.reportFatalXMLError(144, 117, n);
                }
            }
            bl = this.checkForPEReference(true);
            if (this.fAttributeQName.prefix == this.fXMLSymbol) {
                this.fAttributeQName.uri = this.fXMLNamespace;
            }
            if (this.fEntityReader.lookingAtChar('>', true)) {
                n3 = this.addAttDef(this.fElementQName, this.fAttributeQName, n5, bl2, n4, n7, n8, this.getReadingExternalEntity());
                this.decreaseMarkupDepth();
                return;
            }
            if (!bl) {
                if (this.fEntityReader.lookingAtSpace(true)) {
                    this.fEntityReader.skipPastSpaces();
                } else {
                    this.reportFatalXMLError(138, 113);
                }
            } else if (this.fEntityReader.lookingAtSpace(true)) {
                this.fEntityReader.skipPastSpaces();
            }
            if (this.fEntityReader.lookingAtChar('>', true)) {
                n3 = this.addAttDef(this.fElementQName, this.fAttributeQName, n5, bl2, n4, n7, n8, this.getReadingExternalEntity());
                this.decreaseMarkupDepth();
                return;
            }
            n3 = this.addAttDef(this.fElementQName, this.fAttributeQName, n5, bl2, n4, n7, n8, this.getReadingExternalEntity());
        }
    }

    private int scanCharRef() throws Exception {
        int n = this.fEntityReader.currentOffset();
        boolean bl = this.fEntityReader.lookingAtChar('x', true);
        int n2 = this.fEntityReader.scanCharRef(bl);
        if (n2 < 0) {
            switch (n2) {
                case -1: {
                    this.reportFatalXMLError(18, 17);
                    return -1;
                }
                case -2: {
                    int n3 = bl ? 17 : 16;
                    int n4 = bl ? 16 : 15;
                    this.reportFatalXMLError(n3, n4);
                    return -1;
                }
                case -3: {
                    n2 = 0x110000;
                    break;
                }
            }
        }
        if (n2 < 32 ? n2 == 9 || n2 == 10 || n2 == 13 : n2 <= 55295 || n2 >= 57344 && (n2 <= 65533 || n2 >= 65536 && n2 <= 0x10FFFF)) {
            return n2;
        }
        int n5 = this.fEntityReader.currentOffset() - n;
        this.reportFatalXMLError(11, 9, this.fEntityReader.addString(n, n5));
        return -1;
    }

    private int scanChildren(QName qName) throws Exception {
        int n = 1;
        this.initializeContentModelStack(n);
        while (true) {
            block17: {
                if (this.fEntityReader.lookingAtChar('(', true)) {
                    this.increaseParenDepth();
                    this.checkForPEReference(false);
                    this.initializeContentModelStack(++n);
                    continue;
                }
                this.checkForElementTypeWithPEReference(this.fEntityReader, ')', this.fElementRefQName);
                int n2 = this.fElementRefQName.rawname;
                if (n2 == -1) {
                    this.reportFatalXMLError(152, 128, qName.rawname);
                    return -1;
                }
                this.fNodeIndexStack[n] = this.fDTDGrammar.addContentSpecNode(0, n2);
                if (this.fEntityReader.lookingAtChar('?', true)) {
                    this.fNodeIndexStack[n] = this.fDTDGrammar.addContentSpecNode(1, this.fNodeIndexStack[n]);
                } else if (this.fEntityReader.lookingAtChar('*', true)) {
                    this.fNodeIndexStack[n] = this.fDTDGrammar.addContentSpecNode(2, this.fNodeIndexStack[n]);
                } else if (this.fEntityReader.lookingAtChar('+', true)) {
                    this.fNodeIndexStack[n] = this.fDTDGrammar.addContentSpecNode(3, this.fNodeIndexStack[n]);
                }
                do {
                    int n3;
                    this.checkForPEReference(false);
                    if (this.fOpStack[n] != 5 && this.fEntityReader.lookingAtChar('|', true)) {
                        if (this.fPrevNodeIndexStack[n] != -1) {
                            this.fNodeIndexStack[n] = this.fDTDGrammar.addContentSpecNode(this.fOpStack[n], this.fPrevNodeIndexStack[n], this.fNodeIndexStack[n]);
                        }
                        this.fPrevNodeIndexStack[n] = this.fNodeIndexStack[n];
                        this.fOpStack[n] = 4;
                        break block17;
                    }
                    if (this.fOpStack[n] != 4 && this.fEntityReader.lookingAtChar(',', true)) {
                        if (this.fPrevNodeIndexStack[n] != -1) {
                            this.fNodeIndexStack[n] = this.fDTDGrammar.addContentSpecNode(this.fOpStack[n], this.fPrevNodeIndexStack[n], this.fNodeIndexStack[n]);
                        }
                        this.fPrevNodeIndexStack[n] = this.fNodeIndexStack[n];
                        this.fOpStack[n] = 5;
                        break block17;
                    }
                    if (!this.fEntityReader.lookingAtChar(')', true)) {
                        this.reportFatalXMLError(98, 127, qName.rawname);
                    }
                    this.decreaseParenDepth();
                    if (this.fPrevNodeIndexStack[n] != -1) {
                        this.fNodeIndexStack[n] = this.fDTDGrammar.addContentSpecNode(this.fOpStack[n], this.fPrevNodeIndexStack[n], this.fNodeIndexStack[n]);
                    }
                    int n4 = n--;
                    this.fNodeIndexStack[n] = n3 = this.fNodeIndexStack[n4];
                    if (this.fEntityReader.lookingAtChar('?', true)) {
                        this.fNodeIndexStack[n] = this.fDTDGrammar.addContentSpecNode(1, this.fNodeIndexStack[n]);
                        continue;
                    }
                    if (this.fEntityReader.lookingAtChar('*', true)) {
                        this.fNodeIndexStack[n] = this.fDTDGrammar.addContentSpecNode(2, this.fNodeIndexStack[n]);
                        continue;
                    }
                    if (!this.fEntityReader.lookingAtChar('+', true)) continue;
                    this.fNodeIndexStack[n] = this.fDTDGrammar.addContentSpecNode(3, this.fNodeIndexStack[n]);
                } while (n != 0);
                return this.fNodeIndexStack[0];
            }
            this.checkForPEReference(false);
        }
    }

    private void scanComment() throws Exception {
        int n = this.fEntityReader.currentOffset();
        boolean bl = false;
        int n2 = this.setScannerState(54);
        while (this.fScannerState == 54) {
            int n3;
            if (this.fEntityReader.lookingAtChar('-', false)) {
                n3 = this.fEntityReader.currentOffset();
                int n4 = 0;
                this.fEntityReader.lookingAtChar('-', true);
                int n5 = this.fEntityReader.currentOffset();
                int n6 = 1;
                while (this.fEntityReader.lookingAtChar('-', true)) {
                    ++n6;
                    n4 = n3;
                    n3 = n5;
                    n5 = this.fEntityReader.currentOffset();
                }
                if (n6 <= 1) continue;
                if (this.fEntityReader.lookingAtChar('>', true)) {
                    if (!bl && n6 > 2) {
                        this.reportFatalXMLError(9, 7);
                        bl = true;
                    }
                    this.decreaseMarkupDepth();
                    int n7 = this.fEntityReader.addString(n, n4 - n);
                    this.fDTDGrammar.callComment(n7);
                    if (this.fDTDHandler != null) {
                        this.fDTDHandler.comment(n7);
                    }
                    this.restoreScannerState(n2);
                    return;
                }
                if (bl) continue;
                this.reportFatalXMLError(9, 7);
                bl = true;
                continue;
            }
            if (this.fEntityReader.lookingAtValidChar(true)) continue;
            n3 = this.fEntityReader.scanInvalidChar();
            if (this.fScannerState == 0 || n3 < 0) continue;
            this.reportFatalXMLError(10, 8, Integer.toHexString(n3));
        }
        this.restoreScannerState(n2);
    }

    private int scanComplexEntityValue(char n, int n2) throws Exception {
        int n3 = this.setScannerState(58);
        this.fEntityValueReader = this.fReaderId;
        int n4 = this.fLiteralData.length();
        while (true) {
            switch (n2) {
                case -1: {
                    int n5 = this.fEntityReader.currentOffset();
                    this.fEntityReader.lookingAtChar((char)n, true);
                    this.restoreScannerState(n3);
                    int n6 = this.fLiteralData.length() - n4;
                    if (n6 == 0) {
                        return this.fEntityReader.addString(this.fEntityValueMark, n5 - this.fEntityValueMark);
                    }
                    if (n5 - this.fEntityValueMark > 0) {
                        this.fEntityReader.append(this.fLiteralData, this.fEntityValueMark, n5 - this.fEntityValueMark);
                        n6 = this.fLiteralData.length() - n4;
                    }
                    return this.fLiteralData.addString(n4, n6);
                }
                case -2: {
                    int n6;
                    int n5 = this.fEntityReader.currentOffset();
                    if (n5 - this.fEntityValueMark > 0) {
                        this.fEntityReader.append(this.fLiteralData, this.fEntityValueMark, n5 - this.fEntityValueMark);
                    }
                    this.fEntityReader.lookingAtChar('&', true);
                    if (this.fEntityReader.lookingAtChar('#', true)) {
                        n6 = this.scanCharRef();
                        if (n6 != -1) {
                            if (n6 < 65536) {
                                this.fLiteralData.append((char)n6);
                            } else {
                                this.fLiteralData.append((char)((n6 - 65536 >> 10) + 55296));
                                this.fLiteralData.append((char)((n6 - 65536 & 0x3FF) + 56320));
                            }
                        }
                        this.fEntityValueMark = this.fEntityReader.currentOffset();
                        break;
                    }
                    n6 = this.fEntityReader.currentOffset();
                    this.fEntityReader.skipPastName(';');
                    int n7 = this.fEntityReader.currentOffset() - n6;
                    if (n7 == 0) {
                        this.reportFatalXMLError(14, 13);
                        this.fEntityValueMark = this.fEntityReader.currentOffset();
                        break;
                    }
                    if (!this.fEntityReader.lookingAtChar(';', true)) {
                        this.reportFatalXMLError(15, 14, this.fEntityReader.addString(n6, n7));
                        this.fEntityValueMark = this.fEntityReader.currentOffset();
                        break;
                    }
                    this.fEntityValueMark = n5;
                    break;
                }
                case -3: {
                    int n5 = this.fEntityReader.currentOffset();
                    if (n5 - this.fEntityValueMark > 0) {
                        this.fEntityReader.append(this.fLiteralData, this.fEntityValueMark, n5 - this.fEntityValueMark);
                    }
                    this.fEntityReader.lookingAtChar('%', true);
                    int n6 = this.fEntityReader.currentOffset();
                    this.fEntityReader.skipPastName(';');
                    int n7 = this.fEntityReader.currentOffset() - n6;
                    if (n7 == 0) {
                        this.reportFatalXMLError(48, 50);
                    } else if (!this.fEntityReader.lookingAtChar(';', true)) {
                        this.reportFatalXMLError(49, 51, this.fEntityReader.addString(n6, n7));
                    } else if (!this.getReadingExternalEntity()) {
                        this.reportFatalXMLError(51, 53, this.fEntityReader.addString(n6, n7));
                    } else {
                        int n8 = this.fEntityReader.addSymbol(n6, n7);
                        this.fEntityHandler.startReadingFromEntity(n8, this.markupDepth(), 4);
                    }
                    this.fEntityValueMark = this.fEntityReader.currentOffset();
                    break;
                }
                case -4: {
                    int n5 = this.fEntityReader.currentOffset();
                    if (n5 - this.fEntityValueMark > 0) {
                        this.fEntityReader.append(this.fLiteralData, this.fEntityValueMark, n5 - this.fEntityValueMark);
                    }
                    int n6 = this.fEntityReader.scanInvalidChar();
                    if (this.fScannerState == 0) {
                        return -1;
                    }
                    if (n6 >= 0) {
                        this.reportFatalXMLError(46, 48, Integer.toHexString(n6));
                    }
                    this.fEntityValueMark = this.fEntityReader.currentOffset();
                    break;
                }
            }
            n2 = this.fEntityReader.scanEntityValue(this.fReaderId == this.fEntityValueReader ? n : -1, false);
        }
    }

    public void scanDecls(boolean bl) throws Exception {
        int n = this.fEntityReader.currentOffset();
        if (bl) {
            this.fExternalSubsetReader = this.fReaderId;
        }
        this.fIncludeSectDepth = 0;
        boolean bl2 = bl;
        int n2 = this.setScannerState(51);
        while (this.fScannerState == 51) {
            int n3;
            int n4;
            boolean bl3 = false;
            if (!bl && this.fEntityReader.lookingAtChar(']', false)) {
                n4 = this.fEntityReader.currentOffset() - n;
                n3 = this.fEntityReader.addString(n, n4);
                this.fDTDGrammar.internalSubset(n3);
                if (this.fDTDHandler != null) {
                    this.fDTDHandler.internalSubset(n3);
                }
                this.fEntityReader.lookingAtChar(']', true);
                this.restoreScannerState(n2);
                return;
            }
            if (this.fEntityReader.lookingAtChar('<', true)) {
                n4 = this.markupDepth();
                this.increaseMarkupDepth();
                if (this.fEntityReader.lookingAtChar('!', true)) {
                    if (this.fEntityReader.lookingAtChar('-', true)) {
                        if (this.fEntityReader.lookingAtChar('-', true)) {
                            this.scanComment();
                        } else {
                            this.abortMarkup(150, 122);
                        }
                    } else if (this.fEntityReader.lookingAtChar('[', true) && this.getReadingExternalEntity()) {
                        this.checkForPEReference(false);
                        if (this.fEntityReader.skippedString(include_string)) {
                            this.checkForPEReference(false);
                            if (!this.fEntityReader.lookingAtChar('[', true)) {
                                this.abortMarkup(150, 122);
                            } else {
                                ++this.fIncludeSectDepth;
                            }
                        } else if (this.fEntityReader.skippedString(ignore_string)) {
                            this.checkForPEReference(false);
                            if (!this.fEntityReader.lookingAtChar('[', true)) {
                                this.abortMarkup(150, 122);
                            } else {
                                this.scanIgnoreSectContents();
                            }
                        } else {
                            this.abortMarkup(150, 122);
                        }
                    } else if (this.fEntityReader.skippedString(element_string)) {
                        this.scanElementDecl();
                    } else if (this.fEntityReader.skippedString(attlist_string)) {
                        this.scanAttlistDecl();
                    } else if (this.fEntityReader.skippedString(entity_string)) {
                        this.scanEntityDecl();
                    } else if (this.fEntityReader.skippedString(notation_string)) {
                        this.scanNotationDecl();
                    } else {
                        this.abortMarkup(150, 122);
                    }
                } else if (this.fEntityReader.lookingAtChar('?', true)) {
                    n3 = this.fEntityReader.scanName(' ');
                    if (n3 == -1) {
                        this.abortMarkup(131, 106);
                    } else if ("xml".equals(this.fStringPool.toString(n3))) {
                        if (this.fEntityReader.lookingAtSpace(true)) {
                            if (bl2) {
                                this.scanTextDecl();
                            } else {
                                this.abortMarkup(105, 138);
                            }
                        } else {
                            this.abortMarkup(6, 4);
                        }
                    } else {
                        this.scanPI(n3);
                    }
                } else {
                    this.abortMarkup(150, 122);
                }
            } else if (this.fEntityReader.lookingAtSpace(true)) {
                this.fEntityReader.skipPastSpaces();
            } else if (this.fEntityReader.lookingAtChar('%', true)) {
                n4 = this.fEntityReader.currentOffset();
                this.fEntityReader.skipPastName(';');
                n3 = this.fEntityReader.currentOffset() - n4;
                if (n3 == 0) {
                    this.reportFatalXMLError(48, 50);
                } else if (!this.fEntityReader.lookingAtChar(';', true)) {
                    this.reportFatalXMLError(49, 51, this.fEntityReader.addString(n4, n3));
                } else {
                    int n5 = this.fEntityReader.addSymbol(n4, n3);
                    bl3 = this.fEntityHandler.startReadingFromEntity(n5, this.markupDepth(), 3);
                }
            } else if (this.fIncludeSectDepth > 0 && this.fEntityReader.lookingAtChar(']', true)) {
                if (!this.fEntityReader.lookingAtChar(']', true) || !this.fEntityReader.lookingAtChar('>', true)) {
                    this.abortMarkup(23, 22);
                } else {
                    this.decreaseMarkupDepth();
                }
                --this.fIncludeSectDepth;
            } else if (!this.fEntityReader.lookingAtValidChar(false)) {
                n4 = this.fEntityReader.scanInvalidChar();
                if (this.fScannerState == 0) break;
                if (n4 >= 0) {
                    if (!bl) {
                        this.reportFatalXMLError(44, 46, Integer.toHexString(n4));
                    } else {
                        this.reportFatalXMLError(45, 47, Integer.toHexString(n4));
                    }
                }
            } else {
                this.reportFatalXMLError(150, 122);
                this.fEntityReader.lookingAtValidChar(true);
            }
            bl2 = bl3;
        }
        if (bl) {
            ((DefaultEntityHandler)this.fEntityHandler).stopReadingFromExternalSubset();
            this.fDTDGrammar.stopReadingFromExternalSubset();
            this.fDTDGrammar.callEndDTD();
            if (this.fDTDHandler != null) {
                this.fDTDHandler.endDTD();
            }
            this.fGrammarResolver.putGrammar("", this.fDTDGrammar);
        }
    }

    public int scanDefaultAttValue(QName qName, QName qName2) throws Exception {
        int n;
        boolean bl = this.fEntityReader.lookingAtChar('\'', true);
        if (!bl && !this.fEntityReader.lookingAtChar('\"', true)) {
            this.reportFatalXMLError(13, 12, qName.rawname, qName2.rawname);
            return -1;
        }
        int n2 = this.setScannerState(56);
        char c = bl ? (char)'\'' : '\"';
        this.fDefaultAttValueReader = this.fReaderId;
        this.fDefaultAttValueElementType = qName.rawname;
        this.fDefaultAttValueAttrName = qName2.rawname;
        boolean bl2 = true;
        int n3 = this.fLiteralData.length();
        while (true) {
            int n4;
            int n5;
            this.fDefaultAttValueOffset = this.fEntityReader.currentOffset();
            if (bl2) {
                this.fDefaultAttValueMark = this.fDefaultAttValueOffset;
                bl2 = false;
            }
            if (this.fEntityReader.lookingAtChar(c, true)) {
                if (this.fReaderId != this.fDefaultAttValueReader) continue;
                break;
            }
            if (this.fEntityReader.lookingAtChar(' ', true)) continue;
            n = this.fEntityReader.lookingAtChar('\r', true);
            if (n != 0 || this.fEntityReader.lookingAtSpace(true)) {
                if (this.fDefaultAttValueOffset - this.fDefaultAttValueMark > 0) {
                    this.fEntityReader.append(this.fLiteralData, this.fDefaultAttValueMark, this.fDefaultAttValueOffset - this.fDefaultAttValueMark);
                }
                bl2 = true;
                this.fLiteralData.append(' ');
                if (n == 0) continue;
                this.fEntityReader.lookingAtChar('\n', true);
                continue;
            }
            if (this.fEntityReader.lookingAtChar('&', true)) {
                if (this.fDefaultAttValueOffset - this.fDefaultAttValueMark > 0) {
                    this.fEntityReader.append(this.fLiteralData, this.fDefaultAttValueMark, this.fDefaultAttValueOffset - this.fDefaultAttValueMark);
                }
                bl2 = true;
                if (this.fEntityReader.lookingAtChar('#', true)) {
                    n5 = this.scanCharRef();
                    if (n5 == -1) continue;
                    if (n5 < 65536) {
                        this.fLiteralData.append((char)n5);
                        continue;
                    }
                    this.fLiteralData.append((char)((n5 - 65536 >> 10) + 55296));
                    this.fLiteralData.append((char)((n5 - 65536 & 0x3FF) + 56320));
                    continue;
                }
                n5 = this.fEntityReader.currentOffset();
                this.fEntityReader.skipPastName(';');
                n4 = this.fEntityReader.currentOffset() - n5;
                if (n4 == 0) {
                    this.reportFatalXMLError(14, 13);
                    continue;
                }
                if (!this.fEntityReader.lookingAtChar(';', true)) {
                    this.reportFatalXMLError(15, 14, this.fEntityReader.addString(n5, n4));
                    continue;
                }
                int n6 = this.fEntityReader.addSymbol(n5, n4);
                this.fEntityHandler.startReadingFromEntity(n6, this.markupDepth(), 1);
                continue;
            }
            if (this.fEntityReader.lookingAtChar('<', true)) {
                if (this.fDefaultAttValueOffset - this.fDefaultAttValueMark > 0) {
                    this.fEntityReader.append(this.fLiteralData, this.fDefaultAttValueMark, this.fDefaultAttValueOffset - this.fDefaultAttValueMark);
                }
                bl2 = true;
                this.reportFatalXMLError(2, 11, qName.rawname, qName2.rawname);
                continue;
            }
            if (!this.getReadingExternalEntity() && this.fEntityReader.lookingAtChar('%', true)) {
                n5 = this.fEntityReader.currentOffset();
                this.fEntityReader.skipPastName(';');
                n4 = this.fEntityReader.currentOffset() - n5;
                if (n4 != 0 && this.fEntityReader.lookingAtChar(';', true)) {
                    this.reportFatalXMLError(51, 53, this.fEntityReader.addString(n5, n4));
                }
            }
            if (this.fEntityReader.lookingAtValidChar(true)) continue;
            if (this.fDefaultAttValueOffset - this.fDefaultAttValueMark > 0) {
                this.fEntityReader.append(this.fLiteralData, this.fDefaultAttValueMark, this.fDefaultAttValueOffset - this.fDefaultAttValueMark);
            }
            bl2 = true;
            n5 = this.fEntityReader.scanInvalidChar();
            if (this.fScannerState == 0) {
                return -1;
            }
            if (n5 < 0) continue;
            this.reportFatalXMLError(12, 10, this.fStringPool.toString(qName.rawname), this.fStringPool.toString(qName2.rawname), Integer.toHexString(n5));
        }
        this.restoreScannerState(n2);
        n = this.fLiteralData.length() - n3;
        if (n == 0) {
            return this.fEntityReader.addString(this.fDefaultAttValueMark, this.fDefaultAttValueOffset - this.fDefaultAttValueMark);
        }
        if (this.fDefaultAttValueOffset - this.fDefaultAttValueMark > 0) {
            this.fEntityReader.append(this.fLiteralData, this.fDefaultAttValueMark, this.fDefaultAttValueOffset - this.fDefaultAttValueMark);
            n = this.fLiteralData.length() - n3;
        }
        return this.fLiteralData.addString(n3, n);
    }

    public int scanDefaultAttValue(QName qName, QName qName2, int n, int n2) throws Exception {
        int n3;
        if (this.fValidationEnabled && n == 3) {
            this.reportRecoverableXMLError(69, 69, this.fStringPool.toString(qName2.rawname));
        }
        if ((n3 = this.scanDefaultAttValue(qName, qName2)) == -1) {
            return -1;
        }
        return n3;
    }

    public boolean scanDoctypeDecl() throws Exception {
        boolean bl;
        this.fDTDGrammar = new DTDGrammar(this.fStringPool);
        this.fDTDGrammar.callStartDTD();
        this.increaseMarkupDepth();
        this.fEntityReader = this.fEntityHandler.getEntityReader();
        this.fDoctypeReader = this.fReaderId = this.fEntityHandler.getReaderId();
        this.setScannerState(50);
        if (!this.fEntityReader.lookingAtSpace(true)) {
            this.abortMarkup(159, 120);
            return false;
        }
        this.fEntityReader.skipPastSpaces();
        this.scanElementType(this.fEntityReader, ' ', this.fElementQName);
        if (this.fElementQName.rawname == -1) {
            this.abortMarkup(153, 119);
            return false;
        }
        boolean bl2 = false;
        int n = -1;
        int n2 = -1;
        if (this.fEntityReader.lookingAtSpace(true)) {
            this.fEntityReader.skipPastSpaces();
            bl = this.fEntityReader.lookingAtChar('[', true);
            if (!bl && !this.fEntityReader.lookingAtChar('>', false)) {
                if (!this.scanExternalID(false)) {
                    this.skipPastEndOfCurrentMarkup();
                    return false;
                }
                bl2 = true;
                n = this.fPubidLiteral;
                n2 = this.fSystemLiteral;
                this.fEntityReader.skipPastSpaces();
                bl = this.fEntityReader.lookingAtChar('[', true);
            }
        } else {
            bl = this.fEntityReader.lookingAtChar('[', true);
        }
        this.fDTDGrammar.doctypeDecl(this.fElementQName, n, n2);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startDTD(this.fElementQName, n, n2);
        }
        if (bl) {
            this.scanDecls(false);
            this.fEntityReader.skipPastSpaces();
        }
        if (!this.fEntityReader.lookingAtChar('>', true)) {
            if (this.fScannerState != 0) {
                this.abortMarkup(147, 121, this.fElementQName.rawname);
            }
            return false;
        }
        this.decreaseMarkupDepth();
        if (bl2) {
            ((DefaultEntityHandler)this.fEntityHandler).startReadingFromExternalSubset(this.fStringPool.toString(n), this.fStringPool.toString(n2), this.markupDepth());
            this.fDTDGrammar.startReadingFromExternalSubset(n, n2);
        } else {
            this.fDTDGrammar.callEndDTD();
            if (this.fDTDHandler != null) {
                this.fDTDHandler.endDTD();
            }
        }
        this.fGrammarResolver.putGrammar("", this.fDTDGrammar);
        return true;
    }

    private void scanElementDecl() throws Exception {
        int n;
        int n2;
        if (!this.checkForPEReference(true)) {
            this.abortMarkup(156, 125);
            return;
        }
        this.checkForElementTypeWithPEReference(this.fEntityReader, ' ', this.fElementQName);
        if (this.fElementQName.rawname == -1) {
            this.abortMarkup(148, 124);
            return;
        }
        if (this.fDTDHandler != null) {
            this.fElementDeclQName.setValues(this.fElementQName);
        }
        if (!this.checkForPEReference(true)) {
            this.abortMarkup(155, 125, this.fElementQName.rawname);
            return;
        }
        int n3 = -1;
        int n4 = -1;
        if (this.fEntityReader.skippedString(empty_string)) {
            n3 = 0;
        } else if (this.fEntityReader.skippedString(any_string)) {
            n3 = 1;
        } else {
            if (!this.fEntityReader.lookingAtChar('(', true)) {
                this.abortMarkup(146, 123, this.fElementQName.rawname);
                return;
            }
            n2 = this.fReaderId;
            n = this.fEntityHandler.getReaderDepth();
            int n5 = this.setScannerState(57);
            int n6 = this.parenDepth();
            this.fEntityHandler.setReaderDepth(n6);
            this.increaseParenDepth();
            this.checkForPEReference(false);
            boolean bl = this.fEntityReader.skippedString(pcdata_string);
            if (bl) {
                n3 = 2;
                n4 = this.scanMixed(this.fElementQName);
            } else {
                n3 = 3;
                n4 = this.scanChildren(this.fElementQName);
            }
            boolean bl2 = n4 != -1;
            this.restoreScannerState(n5);
            this.fEntityHandler.setReaderDepth(n);
            if (!bl2) {
                this.setParenDepth(n6);
                this.skipPastEndOfCurrentMarkup();
                return;
            }
            this.parenDepth();
        }
        this.checkForPEReference(false);
        if (!this.fEntityReader.lookingAtChar('>', true)) {
            this.abortMarkup(106, 126, this.fElementQName.rawname);
            return;
        }
        this.decreaseMarkupDepth();
        n2 = this.fDTDGrammar.getElementDeclIndex(this.fElementQName, -1);
        n = this.getReadingExternalEntity() ? 1 : 0;
        if (n2 == -1) {
            n2 = this.fDTDGrammar.addElementDecl(this.fElementQName, n3, n4, n != 0);
        } else {
            this.fDTDGrammar.getElementDecl(n2, this.fTempElementDecl);
            if (this.fTempElementDecl.type == -1) {
                this.fTempElementDecl.type = n3;
                this.fTempElementDecl.contentSpecIndex = n4;
                this.fDTDGrammar.setElementDeclDTD(n2, this.fTempElementDecl);
                this.fDTDGrammar.setElementDeclIsExternal(n2, n != 0);
            } else if (this.fValidationEnabled) {
                this.reportRecoverableXMLError(89, 82, this.fStringPool.toString(this.fElementQName.rawname));
            }
        }
        if (this.fDTDHandler != null) {
            this.fDTDGrammar.getElementDecl(n2, this.fTempElementDecl);
            this.fDTDHandler.elementDecl(this.fElementDeclQName, n3, n4, this.fDTDGrammar);
        }
    }

    private void scanElementType(XMLEntityHandler.EntityReader entityReader, char c, QName qName) throws Exception {
        if (!this.fNamespacesEnabled) {
            qName.clear();
            qName.rawname = qName.localpart = entityReader.scanName(c);
            return;
        }
        entityReader.scanQName(c, qName);
        if (entityReader.lookingAtChar(':', false)) {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 126, 139, null, 2);
            entityReader.skipPastNmtoken(' ');
        }
    }

    private void scanEntityDecl() throws Exception {
        int n;
        int n2;
        int n3;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.fEntityReader.lookingAtSpace(true)) {
            this.fEntityReader.skipPastSpaces();
            if (!this.fEntityReader.lookingAtChar('%', true)) {
                bl2 = false;
            } else if (this.fEntityReader.lookingAtSpace(true)) {
                this.checkForPEReference(false);
                bl2 = true;
            } else if (!this.getReadingExternalEntity()) {
                this.reportFatalXMLError(107, 98);
                bl2 = true;
            } else if (this.fEntityReader.lookingAtChar('%', false)) {
                this.checkForPEReference(false);
                bl2 = true;
            } else {
                bl3 = true;
            }
        } else if (!this.getReadingExternalEntity() || !this.fEntityReader.lookingAtChar('%', true)) {
            this.reportFatalXMLError(108, 94);
            bl2 = false;
        } else if (this.fEntityReader.lookingAtSpace(false)) {
            this.reportFatalXMLError(109, 98);
            bl2 = false;
        } else {
            bl3 = true;
        }
        if (bl3) {
            while (true) {
                n3 = this.fEntityReader.currentOffset();
                this.fEntityReader.skipPastName(';');
                int bl = this.fEntityReader.currentOffset() - n3;
                if (bl == 0) {
                    this.reportFatalXMLError(48, 50);
                } else if (!this.fEntityReader.lookingAtChar(';', true)) {
                    this.reportFatalXMLError(49, 51, this.fEntityReader.addString(n3, bl));
                } else {
                    n2 = this.fEntityReader.addSymbol(n3, bl);
                    n = this.fScannerState == 57 ? this.parenDepth() : this.markupDepth();
                    this.fEntityHandler.startReadingFromEntity(n2, n, 5);
                }
                this.fEntityReader.skipPastSpaces();
                if (!this.fEntityReader.lookingAtChar('%', true)) break;
                if (bl2) continue;
                if (this.fEntityReader.lookingAtSpace(true)) {
                    this.checkForPEReference(false);
                    bl2 = true;
                    break;
                }
                bl2 = this.fEntityReader.lookingAtChar('%', true);
            }
        }
        if ((n3 = this.checkForNameWithPEReference(this.fEntityReader, ' ')) == -1) {
            this.abortMarkup(110, 95);
            return;
        }
        if (!this.fDTDGrammar.startEntityDecl(bl2, n3)) {
            this.skipPastEndOfCurrentMarkup();
            return;
        }
        if (!this.checkForPEReference(true)) {
            this.abortMarkup(111, 96, n3);
            this.fDTDGrammar.endEntityDecl();
            return;
        }
        if (bl2) {
            boolean bl = this.fEntityReader.lookingAtChar('\'', true);
            if (bl || this.fEntityReader.lookingAtChar('\"', true)) {
                n2 = this.scanEntityValue(bl);
                if (n2 == -1) {
                    this.skipPastEndOfCurrentMarkup();
                    this.fDTDGrammar.endEntityDecl();
                    return;
                }
                this.checkForPEReference(false);
                if (!this.fEntityReader.lookingAtChar('>', true)) {
                    this.abortMarkup(112, 99, n3);
                    this.fDTDGrammar.endEntityDecl();
                    return;
                }
                this.decreaseMarkupDepth();
                this.fDTDGrammar.endEntityDecl();
                this.fDTDGrammar.addInternalPEDecl(n3, n2);
                if (this.fDTDHandler != null) {
                    this.fDTDHandler.internalPEDecl(n3, n2);
                }
                n = ((DefaultEntityHandler)this.fEntityHandler).addInternalPEDecl(n3, n2, this.getReadingExternalEntity());
            } else {
                if (!this.scanExternalID(false)) {
                    this.skipPastEndOfCurrentMarkup();
                    this.fDTDGrammar.endEntityDecl();
                    return;
                }
                this.checkForPEReference(false);
                if (!this.fEntityReader.lookingAtChar('>', true)) {
                    this.abortMarkup(112, 99, n3);
                    this.fDTDGrammar.endEntityDecl();
                    return;
                }
                this.decreaseMarkupDepth();
                this.fDTDGrammar.endEntityDecl();
                this.fDTDGrammar.addExternalPEDecl(n3, this.fPubidLiteral, this.fSystemLiteral);
                if (this.fDTDHandler != null) {
                    this.fDTDHandler.externalPEDecl(n3, this.fPubidLiteral, this.fSystemLiteral);
                }
                n2 = ((DefaultEntityHandler)this.fEntityHandler).addExternalPEDecl(n3, this.fPubidLiteral, this.fSystemLiteral, this.getReadingExternalEntity());
            }
        } else {
            boolean bl = this.fEntityReader.lookingAtChar('\'', true);
            if (bl || this.fEntityReader.lookingAtChar('\"', true)) {
                n2 = this.scanEntityValue(bl);
                if (n2 == -1) {
                    this.skipPastEndOfCurrentMarkup();
                    this.fDTDGrammar.endEntityDecl();
                    return;
                }
                this.checkForPEReference(false);
                if (!this.fEntityReader.lookingAtChar('>', true)) {
                    this.abortMarkup(112, 97, n3);
                    this.fDTDGrammar.endEntityDecl();
                    return;
                }
                this.decreaseMarkupDepth();
                this.fDTDGrammar.endEntityDecl();
                this.fDTDGrammar.addInternalEntityDecl(n3, n2);
                if (this.fDTDHandler != null) {
                    this.fDTDHandler.internalEntityDecl(n3, n2);
                }
                n = ((DefaultEntityHandler)this.fEntityHandler).addInternalEntityDecl(n3, n2, this.getReadingExternalEntity());
            } else {
                if (!this.scanExternalID(false)) {
                    this.skipPastEndOfCurrentMarkup();
                    this.fDTDGrammar.endEntityDecl();
                    return;
                }
                n2 = 0;
                if (this.fEntityReader.lookingAtSpace(true)) {
                    this.fEntityReader.skipPastSpaces();
                    n2 = this.fEntityReader.skippedString(ndata_string) ? 1 : 0;
                }
                if (n2 == 0) {
                    this.checkForPEReference(false);
                    if (!this.fEntityReader.lookingAtChar('>', true)) {
                        this.abortMarkup(112, 99, n3);
                        this.fDTDGrammar.endEntityDecl();
                        return;
                    }
                    this.decreaseMarkupDepth();
                    this.fDTDGrammar.endEntityDecl();
                    this.fDTDGrammar.addExternalEntityDecl(n3, this.fPubidLiteral, this.fSystemLiteral);
                    if (this.fDTDHandler != null) {
                        this.fDTDHandler.externalEntityDecl(n3, this.fPubidLiteral, this.fSystemLiteral);
                    }
                    n = ((DefaultEntityHandler)this.fEntityHandler).addExternalEntityDecl(n3, this.fPubidLiteral, this.fSystemLiteral, this.getReadingExternalEntity());
                } else {
                    if (!this.fEntityReader.lookingAtSpace(true)) {
                        this.abortMarkup(157, 132, n3);
                        this.fDTDGrammar.endEntityDecl();
                        return;
                    }
                    this.fEntityReader.skipPastSpaces();
                    n = this.fEntityReader.currentOffset();
                    this.fEntityReader.skipPastName('>');
                    int n4 = this.fEntityReader.currentOffset() - n;
                    if (n4 == 0) {
                        this.abortMarkup(113, 100, n3);
                        this.fDTDGrammar.endEntityDecl();
                        return;
                    }
                    int n5 = this.fEntityReader.addSymbol(n, n4);
                    this.checkForPEReference(false);
                    if (!this.fEntityReader.lookingAtChar('>', true)) {
                        this.abortMarkup(112, 99, n3);
                        this.fDTDGrammar.endEntityDecl();
                        return;
                    }
                    this.decreaseMarkupDepth();
                    this.fDTDGrammar.endEntityDecl();
                    this.fDTDGrammar.addUnparsedEntityDecl(n3, this.fPubidLiteral, this.fSystemLiteral, n5);
                    if (this.fDTDHandler != null) {
                        this.fDTDHandler.unparsedEntityDecl(n3, this.fPubidLiteral, this.fSystemLiteral, n5);
                    }
                    int n6 = ((DefaultEntityHandler)this.fEntityHandler).addUnparsedEntityDecl(n3, this.fPubidLiteral, this.fSystemLiteral, n5, this.getReadingExternalEntity());
                }
            }
        }
    }

    private int scanEntityValue(boolean bl) throws Exception {
        char c = bl ? (char)'\'' : '\"';
        this.fEntityValueMark = this.fEntityReader.currentOffset();
        int n = this.fEntityReader.scanEntityValue(c, true);
        if (n < 0) {
            n = this.scanComplexEntityValue(c, n);
        }
        return n;
    }

    private int scanEnumeration(int n, int n2, boolean bl) throws Exception {
        int n3 = this.fDTDGrammar.startEnumeration();
        do {
            int n4;
            this.checkForPEReference(false);
            int n5 = n4 = bl ? this.checkForNameWithPEReference(this.fEntityReader, ')') : this.checkForNmtokenWithPEReference(this.fEntityReader, ')');
            if (n4 == -1) {
                if (bl) {
                    this.reportFatalXMLError(115, 90, n, n2);
                } else {
                    this.reportFatalXMLError(116, 92, n, n2);
                }
                this.fDTDGrammar.endEnumeration(n3);
                return -1;
            }
            this.fDTDGrammar.addNameToEnumeration(n3, n, n2, n4, bl);
            if (bl && !((DefaultEntityHandler)this.fEntityHandler).isNotationDeclared(n4)) {
                Object[] objectArray = new Object[]{this.fStringPool.toString(n), this.fStringPool.toString(n2), this.fStringPool.toString(n4)};
                ((DefaultEntityHandler)this.fEntityHandler).addRequiredNotation(n4, this.fErrorReporter.getLocator(), 117, 89, objectArray);
            }
            this.checkForPEReference(false);
        } while (this.fEntityReader.lookingAtChar('|', true));
        this.fDTDGrammar.endEnumeration(n3);
        if (!this.fEntityReader.lookingAtChar(')', true)) {
            if (bl) {
                this.reportFatalXMLError(118, 91, n, n2);
            } else {
                this.reportFatalXMLError(119, 93, n, n2);
            }
            return -1;
        }
        this.decreaseParenDepth();
        return n3;
    }

    private boolean scanExternalID(boolean bl) throws Exception {
        this.fSystemLiteral = -1;
        this.fPubidLiteral = -1;
        int n = this.fEntityReader.currentOffset();
        if (this.fEntityReader.skippedString(system_string)) {
            if (!this.fEntityReader.lookingAtSpace(true)) {
                this.reportFatalXMLError(160, 131);
                return false;
            }
            this.fEntityReader.skipPastSpaces();
            if (this.getReadingExternalEntity()) {
                this.checkForPEReference(false);
            }
            return this.scanSystemLiteral();
        }
        if (this.fEntityReader.skippedString(public_string)) {
            if (!this.fEntityReader.lookingAtSpace(true)) {
                this.reportFatalXMLError(158, 131);
                return false;
            }
            this.fEntityReader.skipPastSpaces();
            if (!this.scanPubidLiteral()) {
                return false;
            }
            if (bl) {
                if (!this.fEntityReader.lookingAtSpace(true)) {
                    return true;
                }
                this.fEntityReader.skipPastSpaces();
                if (this.fEntityReader.lookingAtChar('>', false)) {
                    return true;
                }
            } else {
                if (!this.fEntityReader.lookingAtSpace(true)) {
                    this.reportFatalXMLError(154, 131);
                    return false;
                }
                this.fEntityReader.skipPastSpaces();
            }
            return this.scanSystemLiteral();
        }
        this.reportFatalXMLError(50, 52);
        return false;
    }

    private void scanIgnoreSectContents() throws Exception {
        int n = ++this.fIncludeSectDepth;
        while (true) {
            if (this.fEntityReader.lookingAtChar('<', true)) {
                if (!this.fEntityReader.lookingAtChar('!', true) || !this.fEntityReader.lookingAtChar('[', true)) continue;
                ++this.fIncludeSectDepth;
                continue;
            }
            if (this.fEntityReader.lookingAtChar(']', true)) {
                if (!this.fEntityReader.lookingAtChar(']', true)) continue;
                while (this.fEntityReader.lookingAtChar(']', true)) {
                }
                if (!this.fEntityReader.lookingAtChar('>', true) || this.fIncludeSectDepth-- != n) continue;
                this.decreaseMarkupDepth();
                return;
            }
            if (this.fEntityReader.lookingAtValidChar(true)) continue;
            int n2 = this.fEntityReader.scanInvalidChar();
            if (this.fScannerState == 0) {
                return;
            }
            if (n2 < 0) continue;
            this.reportFatalXMLError(25, 24, Integer.toHexString(n2));
        }
    }

    private int scanMixed(QName qName) throws Exception {
        int n = -1;
        int n2 = -1;
        boolean bl = false;
        int[] nArray = new int[32];
        int n3 = 0;
        boolean bl2 = false;
        int n4 = -1;
        do {
            if (this.fValidationEnabled) {
                int n5 = 0;
                while (n5 < n3) {
                    if (nArray[n5] == n) {
                        bl2 = true;
                        break;
                    }
                    ++n5;
                }
            }
            if (bl2 && this.fValidationEnabled) {
                this.reportRecoverableXMLError(67, 67, n);
                bl2 = false;
            } else {
                try {
                    nArray[n3] = n;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    int[] nArray2 = new int[nArray.length * 2];
                    System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                    nArray = nArray2;
                    nArray[n3] = n;
                }
                ++n3;
                n4 = this.fDTDGrammar.addUniqueLeafNode(n);
            }
            this.checkForPEReference(false);
            if (!this.fEntityReader.lookingAtChar('|', true)) {
                if (!this.fEntityReader.lookingAtChar(')', true)) {
                    this.reportFatalXMLError(145, 129, qName.rawname);
                    return -1;
                }
                this.decreaseParenDepth();
                if (n4 == -1) {
                    n4 = n2;
                } else if (n2 != -1) {
                    n4 = this.fDTDGrammar.addContentSpecNode(4, n2, n4);
                }
                if (this.fEntityReader.lookingAtChar('*', true)) {
                    n4 = this.fDTDGrammar.addContentSpecNode(2, n4);
                } else if (bl) {
                    this.reportFatalXMLError(47, 49, this.fStringPool.toString(qName.rawname), this.fDTDGrammar.getContentSpecNodeAsString(n4));
                    return -1;
                }
                return n4;
            }
            if (n4 != -1) {
                if (n2 != -1) {
                    n4 = this.fDTDGrammar.addContentSpecNode(4, n2, n4);
                }
                n2 = n4;
            }
            bl = true;
            this.checkForPEReference(false);
            this.checkForElementTypeWithPEReference(this.fEntityReader, ')', this.fElementRefQName);
        } while ((n = this.fElementRefQName.rawname) != -1);
        this.reportFatalXMLError(149, 130, qName.rawname);
        return -1;
    }

    private void scanNotationDecl() throws Exception {
        if (!this.checkForPEReference(true)) {
            this.abortMarkup(142, 102);
            return;
        }
        int n = this.checkForNameWithPEReference(this.fEntityReader, ' ');
        if (n == -1) {
            this.abortMarkup(120, 101);
            return;
        }
        if (!this.checkForPEReference(true)) {
            this.abortMarkup(137, 102, n);
            return;
        }
        if (!this.scanExternalID(true)) {
            this.skipPastEndOfCurrentMarkup();
            return;
        }
        this.checkForPEReference(false);
        if (!this.fEntityReader.lookingAtChar('>', true)) {
            this.abortMarkup(122, 103, n);
            return;
        }
        this.decreaseMarkupDepth();
        int n2 = ((DefaultEntityHandler)this.fEntityHandler).addNotationDecl(n, this.fPubidLiteral, this.fSystemLiteral, this.getReadingExternalEntity());
        this.fDTDGrammar.addNotationDecl(n, this.fPubidLiteral, this.fSystemLiteral);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.notationDecl(n, this.fPubidLiteral, this.fSystemLiteral);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void scanPI(int var1_1) throws Exception {
        block9: {
            block8: {
                var2_2 = this.fStringPool.toString(var1_1);
                if (!(var2_2.length() != 3 || var2_2.charAt(0) != 'X' && var2_2.charAt(0) != 'x' || var2_2.charAt(1) != 'M' && var2_2.charAt(1) != 'm' || var2_2.charAt(2) != 'L' && var2_2.charAt(2) != 'l')) {
                    this.abortMarkup(6, 4);
                    return;
                }
                var3_3 = this.setScannerState(55);
                var4_4 = -1;
                var5_5 = 0;
                if (this.fEntityReader.lookingAtSpace(true)) break block8;
                if (!this.fEntityReader.lookingAtChar('?', true) || !this.fEntityReader.lookingAtChar('>', true)) {
                    if (this.fScannerState != 0) {
                        this.abortMarkup(7, 5);
                        this.restoreScannerState(var3_3);
                    }
                    return;
                }
                this.decreaseMarkupDepth();
                this.restoreScannerState(var3_3);
                break block9;
            }
            this.fEntityReader.skipPastSpaces();
            var4_4 = this.fEntityReader.currentOffset();
            ** GOTO lbl43
            {
                block10: {
                    var6_6 = this.fEntityReader.currentOffset();
                    this.fEntityReader.lookingAtChar('?', true);
                    if (!this.fEntityReader.lookingAtChar('>', true)) break block10;
                    var5_5 = var6_6 - var4_4;
                    this.decreaseMarkupDepth();
                    this.restoreScannerState(var3_3);
                    ** GOTO lbl34
                }
                do {
                    if (this.fEntityReader.lookingAtChar('?', false)) continue block0;
lbl34:
                    // 2 sources

                    if (this.fScannerState != 55) break block0;
                    if (this.fEntityReader.lookingAtValidChar(true)) continue;
                    var6_6 = this.fEntityReader.scanInvalidChar();
                    if (this.fScannerState != 0) {
                        if (var6_6 >= 0) {
                            this.reportFatalXMLError(8, 6, Integer.toHexString(var6_6));
                        }
                        this.skipPastEndOfCurrentMarkup();
                        this.restoreScannerState(var3_3);
                    }
                    return;
lbl43:
                    // 2 sources

                } while (this.fScannerState == 55);
            }
        }
        var6_6 = var5_5 == 0 ? 0 : this.fEntityReader.addString(var4_4, var5_5);
        this.fDTDGrammar.callProcessingInstruction(var1_1, var6_6);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.processingInstruction(var1_1, var6_6);
        }
    }

    private boolean scanPubidLiteral() throws Exception {
        int n;
        boolean bl = this.fEntityReader.lookingAtChar('\'', true);
        if (!bl && !this.fEntityReader.lookingAtChar('\"', true)) {
            this.reportFatalXMLError(21, 20);
            return false;
        }
        char c = bl ? (char)'\'' : '\"';
        int n2 = this.setScannerState(60);
        boolean bl2 = true;
        do {
            if (!this.fEntityReader.lookingAtChar('\t', true)) continue;
            bl2 = false;
            this.reportFatalXMLError(60, 21, "9");
        } while (this.fEntityReader.lookingAtSpace(true));
        int n3 = this.fEntityReader.currentOffset();
        int n4 = this.fLiteralData.length();
        int n5 = n3;
        while (true) {
            if (this.fEntityReader.lookingAtChar(c, true)) {
                if (!bl2 || n3 - n5 <= 0) break;
                this.fEntityReader.append(this.fLiteralData, n5, n3 - n5);
                break;
            }
            if (this.fEntityReader.lookingAtChar('\t', true)) {
                bl2 = false;
                this.reportFatalXMLError(60, 21, "9");
                continue;
            }
            if (this.fEntityReader.lookingAtSpace(true)) {
                if (bl2 && n3 - n5 > 0) {
                    this.fEntityReader.append(this.fLiteralData, n5, n3 - n5);
                }
                do {
                    if (!this.fEntityReader.lookingAtChar('\t', true)) continue;
                    bl2 = false;
                    this.reportFatalXMLError(60, 21, "9");
                    break;
                } while (this.fEntityReader.lookingAtSpace(true));
                if (this.fEntityReader.lookingAtChar(c, true)) break;
                if (!bl2) continue;
                this.fLiteralData.append(' ');
                n5 = n3 = this.fEntityReader.currentOffset();
                continue;
            }
            if (!this.fEntityReader.lookingAtValidChar(true)) {
                n = this.fEntityReader.scanInvalidChar();
                if (this.fScannerState == 0) {
                    return false;
                }
                bl2 = false;
                if (n >= 0) {
                    this.reportFatalXMLError(22, 21, Integer.toHexString(n));
                }
            }
            if (!bl2) continue;
            n3 = this.fEntityReader.currentOffset();
        }
        if (bl2) {
            n = this.fLiteralData.length() - n4;
            this.fPubidLiteral = this.fLiteralData.addString(n4, n);
            String string = this.fStringPool.toString(this.fPubidLiteral);
            int n6 = this.validPublicId(string);
            if (n6 >= 0) {
                this.reportFatalXMLError(60, 21, Integer.toHexString(string.charAt(n6)));
                return false;
            }
        }
        this.restoreScannerState(n2);
        return bl2;
    }

    private boolean scanSystemLiteral() throws Exception {
        boolean bl = this.fEntityReader.lookingAtChar('\'', true);
        if (!bl && !this.fEntityReader.lookingAtChar('\"', true)) {
            this.reportFatalXMLError(19, 18);
            return false;
        }
        int n = this.setScannerState(59);
        int n2 = this.fEntityReader.currentOffset();
        char c = bl ? (char)'\'' : '\"';
        boolean bl2 = true;
        boolean bl3 = false;
        while (!this.fEntityReader.lookingAtChar(c, false)) {
            if (this.fEntityReader.lookingAtChar('#', true)) {
                bl3 = true;
                continue;
            }
            if (this.fEntityReader.lookingAtValidChar(true)) continue;
            bl2 = false;
            int n3 = this.fEntityReader.scanInvalidChar();
            if (this.fScannerState == 0) {
                return false;
            }
            if (n3 < 0) continue;
            this.reportFatalXMLError(20, 19, Integer.toHexString(n3));
        }
        if (bl2) {
            this.fSystemLiteral = this.fEntityReader.addString(n2, this.fEntityReader.currentOffset() - n2);
            if (bl3) {
                Object[] objectArray = new Object[]{this.fStringPool.toString(this.fSystemLiteral)};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 133, 142, objectArray, 1);
            }
        }
        this.fEntityReader.lookingAtChar(c, true);
        this.restoreScannerState(n);
        return bl2;
    }

    private void scanTextDecl() throws Exception {
        int n = -1;
        int n2 = -1;
        boolean bl = false;
        boolean bl2 = true;
        int n3 = 2;
        int n4 = 3;
        int n5 = this.setScannerState(53);
        int n6 = 0;
        do {
            int n7;
            this.fEntityReader.skipPastSpaces();
            int n8 = this.fEntityReader.currentOffset();
            if (n6 == 0 && this.fEntityReader.skippedString(version_string)) {
                n6 = 1;
            } else if (this.fEntityReader.skippedString(encoding_string)) {
                n6 = 2;
            } else {
                this.abortMarkup(29, 28);
                this.restoreScannerState(n5);
                return;
            }
            int n9 = this.fEntityReader.currentOffset() - n8;
            this.fEntityReader.skipPastSpaces();
            if (!this.fEntityReader.lookingAtChar('=', true)) {
                n7 = n6 == 1 ? 30 : 32;
                this.abortMarkup(32, n7, this.fEntityReader.addString(n8, n9));
                this.restoreScannerState(n5);
                return;
            }
            this.fEntityReader.skipPastSpaces();
            n7 = this.fEntityReader.scanStringLiteral();
            switch (n7) {
                case -1: {
                    int n10 = n6 == 1 ? 33 : 35;
                    this.abortMarkup(34, n10, this.fEntityReader.addString(n8, n9));
                    this.restoreScannerState(n5);
                    return;
                }
                case -2: {
                    int n11 = this.fEntityReader.scanInvalidChar();
                    if (this.fScannerState != 0) {
                        if (n11 >= 0) {
                            int n12 = n6 == 1 ? 36 : 38;
                            this.reportFatalXMLError(36, n12, Integer.toHexString(n11));
                        }
                        this.skipPastEndOfCurrentMarkup();
                        this.restoreScannerState(n5);
                    }
                    return;
                }
            }
            switch (n6) {
                case 1: {
                    Object[] objectArray;
                    n = n7;
                    String string = this.fStringPool.toString(n);
                    if (!"1.0".equals(string)) {
                        if (!this.validVersionNum(string)) {
                            this.abortMarkup(37, 39, string);
                            this.restoreScannerState(n5);
                            return;
                        }
                        objectArray = new Object[]{string};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 38, 40, objectArray, 1);
                    }
                    if (this.fEntityReader.lookingAtSpace(true)) break;
                    this.abortMarkup(39, 41);
                    this.restoreScannerState(n5);
                    return;
                }
                case 2: {
                    n2 = n7;
                    Object[] objectArray = this.fStringPool.toString(n2);
                    if (!this.validEncName((String)objectArray)) {
                        this.abortMarkup(40, 42, (String)objectArray);
                        this.restoreScannerState(n5);
                        return;
                    }
                    this.fEntityReader.skipPastSpaces();
                    n6 = 3;
                    break;
                }
            }
        } while (n6 != 3);
        if (!this.fEntityReader.lookingAtChar('?', true) || !this.fEntityReader.lookingAtChar('>', true)) {
            this.abortMarkup(43, 45);
            this.restoreScannerState(n5);
            return;
        }
        this.decreaseMarkupDepth();
        this.fDTDGrammar.callTextDecl(n, n2);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.textDecl(n, n2);
        }
        this.restoreScannerState(n5);
    }

    public void setDTDHandler(XMLDocumentHandler.DTDHandler dTDHandler) {
        this.fDTDHandler = dTDHandler;
    }

    public void setEventHandler(EventHandler eventHandler) {
        this.fEventHandler = eventHandler;
    }

    public void setGrammarResolver(GrammarResolver grammarResolver) {
        this.fGrammarResolver = grammarResolver;
    }

    public void setNamespacesEnabled(boolean bl) {
        this.fNamespacesEnabled = bl;
    }

    private void setParenDepth(int n) {
        this.fScannerParenDepth = n;
    }

    private int setScannerState(int n) {
        int n2 = this.fScannerState;
        this.fScannerState = n;
        return n2;
    }

    public void setValidationEnabled(boolean bl) {
        this.fValidationEnabled = bl;
    }

    private void skipPastEndOfCurrentMarkup() throws Exception {
        this.fEntityReader.skipToChar('>');
        if (this.fEntityReader.lookingAtChar('>', true)) {
            this.decreaseMarkupDepth();
        }
    }

    private boolean validEncName(String string) {
        return XMLCharacterProperties.validEncName(string);
    }

    private int validPublicId(String string) {
        return XMLCharacterProperties.validPublicId(string);
    }

    private boolean validVersionNum(String string) {
        return XMLCharacterProperties.validVersionNum(string);
    }

    public static interface EventHandler {
        public int addAttDef(QName var1, QName var2, int var3, boolean var4, int var5, int var6, int var7, boolean var8) throws Exception;

        public int addContentSpecNode(int var1, int var2) throws Exception;

        public int addContentSpecNode(int var1, int var2, int var3) throws Exception;

        public int addElementDecl(QName var1) throws Exception;

        public int addElementDecl(QName var1, int var2, int var3, boolean var4) throws Exception;

        public int addExternalEntityDecl(int var1, int var2, int var3) throws Exception;

        public int addExternalPEDecl(int var1, int var2, int var3) throws Exception;

        public int addInternalEntityDecl(int var1, int var2) throws Exception;

        public int addInternalPEDecl(int var1, int var2) throws Exception;

        public void addNameToEnumeration(int var1, int var2, int var3, int var4, boolean var5) throws Exception;

        public int addNotationDecl(int var1, int var2, int var3) throws Exception;

        public int addUniqueLeafNode(int var1) throws Exception;

        public int addUnparsedEntityDecl(int var1, int var2, int var3, int var4) throws Exception;

        public void callComment(int var1) throws Exception;

        public void callEndDTD() throws Exception;

        public void callProcessingInstruction(int var1, int var2) throws Exception;

        public void callStartDTD() throws Exception;

        public void callTextDecl(int var1, int var2) throws Exception;

        public void doctypeDecl(QName var1, int var2, int var3) throws Exception;

        public void endEntityDecl() throws Exception;

        public void endEnumeration(int var1) throws Exception;

        public String getContentSpecNodeAsString(int var1) throws Exception;

        public void internalSubset(int var1) throws Exception;

        public boolean startEntityDecl(boolean var1, int var2) throws Exception;

        public int startEnumeration() throws Exception;

        public void startReadingFromExternalSubset(int var1, int var2) throws Exception;

        public void stopReadingFromExternalSubset() throws Exception;
    }
}

