/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output;

import java.util.LinkedList;
import org.apache.log.LogEvent;
import org.apache.log.LogTarget;

public class AsyncLogTarget
implements LogTarget,
Runnable {
    protected final LinkedList m_list;
    protected final int m_queueSize;
    protected final LogTarget m_logTarget;

    public void processEvent(LogEvent logEvent) {
        LinkedList linkedList = this.m_list;
        synchronized (linkedList) {
            int n = this.m_list.size();
            while (this.m_queueSize <= n) {
                try {
                    this.m_list.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.m_list.addFirst(logEvent);
            if (n == 0) {
                this.m_list.notify();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        boolean bl = false;
        while (true) {
            LogEvent logEvent = null;
            LinkedList linkedList = this.m_list;
            synchronized (linkedList) {
                while (logEvent == null) {
                    int n = this.m_list.size();
                    if (n > 0) {
                        logEvent = (LogEvent)this.m_list.removeLast();
                        if (n != this.m_queueSize) continue;
                        this.m_list.notify();
                        continue;
                    }
                    if (bl) return;
                    if (Thread.interrupted()) {
                        return;
                    }
                    try {
                        this.m_list.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                    }
                }
            }
            this.m_logTarget.processEvent(logEvent);
        }
    }

    public AsyncLogTarget(LogTarget logTarget) {
        this(logTarget, 15);
    }

    public AsyncLogTarget(LogTarget logTarget, int n) {
        this.m_logTarget = logTarget;
        this.m_list = new LinkedList();
        this.m_queueSize = n;
    }
}

