/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import org.apache.log.ContextStack;
import org.apache.log.Hierarchy;
import org.apache.log.LogEvent;
import org.apache.log.LogTarget;
import org.apache.log.Priority;

public class Logger {
    public static final char CATEGORY_SEPARATOR = '.';
    private static final long START_TIME = System.currentTimeMillis();
    private final Hierarchy m_hierarchy;
    private final Logger m_parent;
    private final String m_category;
    private Logger[] m_children;
    private LogTarget[] m_logTargets;
    private boolean m_logTargetsForceSet;
    private Priority m_priority;
    private boolean m_priorityForceSet;

    public final void debug(String string, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.output(Priority.DEBUG, string, throwable);
        }
    }

    public final void debug(String string) {
        if (this.isDebugEnabled()) {
            this.output(Priority.DEBUG, string, null);
        }
    }

    public final void error(String string, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.output(Priority.ERROR, string, throwable);
        }
    }

    public final void error(String string) {
        if (this.isErrorEnabled()) {
            this.output(Priority.ERROR, string, null);
        }
    }

    public final void fatalError(String string, Throwable throwable) {
        if (this.isFatalErrorEnabled()) {
            this.output(Priority.FATAL_ERROR, string, throwable);
        }
    }

    public final void fatalError(String string) {
        if (this.isFatalErrorEnabled()) {
            this.output(Priority.FATAL_ERROR, string, null);
        }
    }

    public final Priority getPriority() {
        return this.m_priority;
    }

    public final String getCategory() {
        return this.m_category;
    }

    public final void info(String string) {
        if (this.isInfoEnabled()) {
            this.output(Priority.INFO, string, null);
        }
    }

    public final void log(Priority priority, String string, Throwable throwable) {
        if (this.getPriority().isLowerOrEqual(priority)) {
            this.output(priority, string, throwable);
        }
    }

    public final void log(Priority priority, String string) {
        this.log(priority, string, null);
    }

    private final void output(Priority priority, String string, Throwable throwable) {
        LogEvent logEvent = new LogEvent();
        logEvent.setCategory(this.m_category);
        logEvent.setContextStack(ContextStack.getCurrentContext());
        if (string != null) {
            logEvent.setMessage(string);
        } else {
            logEvent.setMessage("");
        }
        logEvent.setThrowable(throwable);
        logEvent.setPriority(priority);
        logEvent.setTime(System.currentTimeMillis() - START_TIME);
        this.output(logEvent);
    }

    private final void output(LogEvent logEvent) {
        LogTarget[] logTargetArray = this.m_logTargets;
        if (logTargetArray == null) {
            this.m_hierarchy.log("LogTarget is null for category '" + this.m_category + "'");
        } else {
            int n = 0;
            while (n < logTargetArray.length) {
                logTargetArray[n].processEvent(logEvent);
                ++n;
            }
        }
    }

    public final void warn(String string, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.output(Priority.WARN, string, throwable);
        }
    }

    public final void warn(String string) {
        if (this.isWarnEnabled()) {
            this.output(Priority.WARN, string, null);
        }
    }

    public final boolean isDebugEnabled() {
        return this.getPriority().isLowerOrEqual(Priority.DEBUG);
    }

    public final boolean isInfoEnabled() {
        return this.getPriority().isLowerOrEqual(Priority.INFO);
    }

    public final boolean isWarnEnabled() {
        return this.getPriority().isLowerOrEqual(Priority.WARN);
    }

    public final boolean isErrorEnabled() {
        return this.getPriority().isLowerOrEqual(Priority.ERROR);
    }

    public final boolean isFatalErrorEnabled() {
        return this.getPriority().isLowerOrEqual(Priority.FATAL_ERROR);
    }

    public synchronized void setPriority(Priority priority) {
        this.m_priority = priority;
        this.m_priorityForceSet = true;
        this.resetChildPrioritys(false);
    }

    public synchronized void unsetPriority() {
        this.unsetPriority(false);
    }

    public synchronized void unsetPriority(boolean bl) {
        this.m_priority = this.m_parent != null ? this.m_parent.getPriority() : Priority.DEBUG;
        this.m_priorityForceSet = false;
        this.resetChildPrioritys(bl);
    }

    public synchronized Logger[] getChildren() {
        if (this.m_children == null) {
            return new Logger[0];
        }
        Logger[] loggerArray = new Logger[this.m_children.length];
        int n = 0;
        while (n < loggerArray.length) {
            loggerArray[n] = this.m_children[n];
            ++n;
        }
        return loggerArray;
    }

    private synchronized void resetChildPrioritys(boolean bl) {
        if (this.m_children == null) {
            return;
        }
        Logger[] loggerArray = this.m_children;
        int n = 0;
        while (n < loggerArray.length) {
            loggerArray[n].resetPriority(bl);
            ++n;
        }
    }

    private synchronized void resetPriority(boolean bl) {
        if (bl) {
            this.m_priorityForceSet = false;
        } else if (this.m_priorityForceSet) {
            return;
        }
        this.m_priority = this.m_parent.getPriority();
        this.resetChildPrioritys(bl);
    }

    public synchronized LogTarget[] getLogTargets() {
        if (this.m_logTargets == null) {
            if (this.m_parent == null) {
                return new LogTarget[0];
            }
            return this.m_parent.getLogTargets();
        }
        LogTarget[] logTargetArray = new LogTarget[this.m_logTargets.length];
        int n = 0;
        while (n < logTargetArray.length) {
            logTargetArray[n] = this.m_logTargets[n];
            ++n;
        }
        return logTargetArray;
    }

    private synchronized void resetChildLogTargets(boolean bl) {
        if (this.m_children == null) {
            return;
        }
        int n = 0;
        while (n < this.m_children.length) {
            this.m_children[n].resetLogTargets(bl);
            ++n;
        }
    }

    private synchronized void resetLogTargets(boolean bl) {
        if (bl) {
            this.m_logTargetsForceSet = false;
        } else if (this.m_logTargetsForceSet) {
            return;
        }
        this.m_logTargets = this.m_parent.getLogTargets();
        this.resetChildLogTargets(bl);
    }

    public synchronized void setLogTargets(LogTarget[] logTargetArray) {
        this.m_logTargets = logTargetArray;
        this.m_logTargetsForceSet = true;
        this.resetChildLogTargets(false);
    }

    public synchronized void unsetLogTargets() {
        this.unsetLogTargets(false);
    }

    public synchronized void unsetLogTargets(boolean bl) {
        this.m_logTargets = this.m_parent != null ? this.m_parent.getLogTargets() : null;
        this.m_logTargetsForceSet = false;
        this.resetChildLogTargets(bl);
    }

    public synchronized Logger getChildLogger(String string) throws IllegalArgumentException {
        int n = string.indexOf(46);
        String string2 = null;
        String string3 = null;
        if (-1 == n) {
            string2 = string;
        } else {
            if (n == 0) {
                throw new IllegalArgumentException("Logger categories MUST not have empty elements");
            }
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        String string4 = null;
        string4 = this.m_category.equals("") ? string2 : this.m_category + "." + string2;
        if (this.m_children != null) {
            int n2 = 0;
            while (n2 < this.m_children.length) {
                if (this.m_children[n2].getCategory().equals(string4)) {
                    if (string3 == null) {
                        return this.m_children[n2];
                    }
                    return this.m_children[n2].getChildLogger(string3);
                }
                ++n2;
            }
        }
        Logger logger = new Logger(this.m_hierarchy, string4, null, this);
        if (this.m_children == null) {
            this.m_children = new Logger[]{logger};
        } else {
            Logger[] loggerArray = new Logger[this.m_children.length + 1];
            System.arraycopy(this.m_children, 0, loggerArray, 0, this.m_children.length);
            loggerArray[this.m_children.length] = logger;
            this.m_children = loggerArray;
        }
        if (string3 == null) {
            return logger;
        }
        return logger.getChildLogger(string3);
    }

    protected Logger(Hierarchy hierarchy, String string, LogTarget[] logTargetArray, Logger logger) {
        this.m_hierarchy = hierarchy;
        this.m_category = string;
        this.m_logTargets = logTargetArray;
        this.m_parent = logger;
        if (this.m_logTargets == null) {
            this.unsetLogTargets();
        }
        this.unsetPriority();
    }
}

