/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.parameters;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class Parameters {
    private HashMap m_parameters = new HashMap();

    public String setParameter(String string, String string2) {
        if (null == string) {
            return null;
        }
        if (null == string2) {
            return (String)this.m_parameters.remove(string);
        }
        return this.m_parameters.put(string, string2);
    }

    public Iterator getParameterNames() {
        return this.m_parameters.keySet().iterator();
    }

    public boolean isParameter(String string) {
        return this.m_parameters.containsKey(string);
    }

    private String getParameter(String string) {
        if (null == string) {
            return null;
        }
        return (String)this.m_parameters.get(string);
    }

    public String getParameter(String string, String string2) {
        String string3 = this.getParameter(string);
        if (null == string3) {
            return string2;
        }
        return string3;
    }

    public int getParameterAsInteger(String string, int n) {
        String string2 = this.getParameter(string);
        if (null == string2) {
            return n;
        }
        try {
            if (string2.startsWith("0x")) {
                return Integer.parseInt(string2.substring(2), 16);
            }
            if (string2.startsWith("0o")) {
                return Integer.parseInt(string2.substring(2), 8);
            }
            if (string2.startsWith("0b")) {
                return Integer.parseInt(string2.substring(2), 2);
            }
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public long getParameterAsLong(String string, long l) {
        String string2 = this.getParameter(string);
        if (null == string2) {
            return l;
        }
        try {
            if (string2.startsWith("0x")) {
                return Long.parseLong(string2.substring(2), 16);
            }
            if (string2.startsWith("0o")) {
                return Long.parseLong(string2.substring(2), 8);
            }
            if (string2.startsWith("0b")) {
                return Long.parseLong(string2.substring(2), 2);
            }
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public float getParameterAsFloat(String string, float f) {
        String string2 = this.getParameter(string);
        if (null == string2) {
            return f;
        }
        try {
            return Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
    }

    public boolean getParameterAsBoolean(String string, boolean bl) {
        String string2 = this.getParameter(string);
        if (null == string2) {
            return bl;
        }
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        return bl;
    }

    public Parameters merge(Parameters parameters) {
        Iterator iterator = parameters.getParameterNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = parameters.getParameter(string);
            this.setParameter(string, string2);
        }
        return this;
    }

    public static Parameters fromConfiguration(Configuration configuration) throws ConfigurationException {
        if (null == configuration) {
            throw new ConfigurationException("You cannot convert to parameters with a null Configuration");
        }
        Configuration[] configurationArray = configuration.getChildren("parameter");
        Parameters parameters = new Parameters();
        int n = 0;
        while (n < configurationArray.length) {
            try {
                String string = configurationArray[n].getAttribute("name");
                String string2 = configurationArray[n].getAttribute("value");
                parameters.setParameter(string, string2);
            }
            catch (Exception exception) {
                throw new ConfigurationException("Cannot process Configurable", exception);
            }
            ++n;
        }
        return parameters;
    }

    public static Parameters fromProperties(Properties properties) {
        Parameters parameters = new Parameters();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            parameters.setParameter(string, string2);
        }
        return parameters;
    }
}

