/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.tagshandler;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.logging.Log;
import xdoclet.TemplateSubTask;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.tagshandler.AbstractProgramElementTagsHandler;
import xdoclet.tagshandler.PackageTagsHandler;
import xdoclet.template.PrettyPrintWriter;
import xdoclet.template.TemplateParser;
import xdoclet.template.TemplateTagHandler;
import xdoclet.util.FileManager;
import xdoclet.util.LogUtil;

public class MergeTagsHandler
extends XDocletTagSupport {
    static /* synthetic */ Class class$xdoclet$tagshandler$MergeTagsHandler;

    public void merge(String template, Properties attributes) throws XDocletException {
        Log log = LogUtil.getLog(class$xdoclet$tagshandler$MergeTagsHandler == null ? (class$xdoclet$tagshandler$MergeTagsHandler = MergeTagsHandler.class$("xdoclet.tagshandler.MergeTagsHandler")) : class$xdoclet$tagshandler$MergeTagsHandler, "merge");
        String merge_file_pattern = attributes.getProperty("file");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Pattern = " + merge_file_pattern));
        }
        if (merge_file_pattern != null) {
            String contents;
            if (merge_file_pattern.endsWith(".j")) {
                log.warn((Object)"Deprecated template file extension used for merge file, .j should now be .xdt");
                merge_file_pattern = merge_file_pattern.substring(0, merge_file_pattern.length() - 2) + ".xdt";
            }
            if ((contents = this.getMergeFileContents(merge_file_pattern)) != null) {
                String generate_merged_file;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Merge File found");
                }
                if ((generate_merged_file = attributes.getProperty("generateMergedFile")) != null && !generate_merged_file.equalsIgnoreCase("true") && !generate_merged_file.equalsIgnoreCase("yes")) {
                    this.getEngine().print(contents);
                } else {
                    this.generateUsingMergedFile(merge_file_pattern, contents);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Merge File NOT found");
                }
                this.generateUsingMergedFile(((TemplateSubTask)XDocletTagSupport.getDocletContext().getActiveSubTask()).getTemplateURL().toString(), template);
            }
        } else {
            log.error((Object)"<XDtMerge:merge/> file parameter missing from template file, ignoring merge command.");
            this.generate(template);
        }
    }

    protected String getMergeFileContents(String mergeFilePattern) {
        Log log = LogUtil.getLog(class$xdoclet$tagshandler$MergeTagsHandler == null ? (class$xdoclet$tagshandler$MergeTagsHandler = MergeTagsHandler.class$("xdoclet.tagshandler.MergeTagsHandler")) : class$xdoclet$tagshandler$MergeTagsHandler, "merge");
        String file = null;
        try {
            if (mergeFilePattern.indexOf("{0}") != -1) {
                if (this.getEngine() instanceof TemplateParser) {
                    ((TemplateParser)this.getEngine()).addMergeFile(mergeFilePattern);
                } else {
                    String ejb_name = MessageFormat.format(mergeFilePattern, AbstractProgramElementTagsHandler.getClassNameFor(XDocletTagSupport.getCurrentClass()));
                    String merge_file_name = PackageTagsHandler.packageNameAsPathWithoutSubstitutionFor(XDocletTagSupport.getCurrentClass().getContainingPackage()) + File.separator + ejb_name;
                    if (XDocletTagSupport.getDocletContext().getActiveSubTask().getMergeDir() != null) {
                        File mergeFile = new File(XDocletTagSupport.getDocletContext().getActiveSubTask().getMergeDir(), merge_file_name);
                        log.debug((Object)("Search for File " + mergeFile));
                        if (mergeFile.exists()) {
                            log.debug((Object)"Search for File OK");
                            file = FileManager.getURLContent(mergeFile.toURL());
                        } else if (merge_file_name.endsWith(".xdt")) {
                            log.debug((Object)".xdt mergefile not found, trying .j");
                            mergeFile = new File(XDocletTagSupport.getDocletContext().getActiveSubTask().getMergeDir(), merge_file_name.substring(0, merge_file_name.length() - 4) + ".j");
                            log.debug((Object)(".xdt mergefile not found, search for File " + mergeFile));
                            if (mergeFile.exists()) {
                                log.debug((Object)"Search for File OK");
                                file = FileManager.getURLContent(mergeFile.toURL());
                            } else {
                                log.debug((Object)"Search for File not OK");
                            }
                        } else {
                            log.debug((Object)"Search for File not OK");
                        }
                    }
                }
            } else if (XDocletTagSupport.getDocletContext().getActiveSubTask().getMergeDir() != null) {
                File mergeFile = new File(XDocletTagSupport.getDocletContext().getActiveSubTask().getMergeDir(), mergeFilePattern);
                if (this.getEngine() instanceof TemplateParser) {
                    TemplateParser parser = (TemplateParser)this.getEngine();
                    if (parser.hasMergeFile(mergeFilePattern)) {
                        return null;
                    }
                    parser.addMergeFile(mergeFilePattern);
                }
                if (mergeFile.exists()) {
                    log.debug((Object)("Merge file found in " + XDocletTagSupport.getDocletContext().getActiveSubTask().getMergeDir()));
                    file = FileManager.getURLContent(mergeFile.toURL());
                } else if (mergeFilePattern.endsWith(".xdt")) {
                    mergeFile = new File(XDocletTagSupport.getDocletContext().getActiveSubTask().getMergeDir(), mergeFilePattern.substring(0, mergeFilePattern.length() - 4) + ".j");
                    log.debug((Object)(".xdt mergefile not found, trying " + mergeFile.getName()));
                    if (mergeFile.exists()) {
                        log.debug((Object)("Merge file found in " + XDocletTagSupport.getDocletContext().getActiveSubTask().getMergeDir()));
                        file = FileManager.getURLContent(mergeFile.toURL());
                    } else {
                        log.debug((Object)("Merge file NOT found in " + XDocletTagSupport.getDocletContext().getActiveSubTask().getMergeDir()));
                    }
                } else {
                    log.debug((Object)("Merge file NOT found in " + XDocletTagSupport.getDocletContext().getActiveSubTask().getMergeDir()));
                }
            }
            if (file != null) {
                return file;
            }
            URL jarResource = this.getClass().getResource('/' + mergeFilePattern);
            if (jarResource != null) {
                log.debug((Object)"Merge file found in jar");
                file = FileManager.getURLContent(jarResource);
            } else {
                file = null;
            }
        }
        catch (MalformedURLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return file;
    }

    protected void generateUsingMergedFile(String mergeFile, String contents) throws XDocletException {
        try {
            int lineNumber = this.getEngine().getCurrentLineNum();
            URL prevTemplateUrl = ((TemplateSubTask)XDocletTagSupport.getDocletContext().getActiveSubTask()).getTemplateURL();
            this.getEngine().setTemplateURL(new File(mergeFile).toURL());
            this.getEngine().setCurrentLineNum(0);
            this.generate(contents);
            this.getEngine().setTemplateURL(prevTemplateUrl);
            this.getEngine().setCurrentLineNum(lineNumber);
        }
        catch (MalformedURLException e) {
            throw new XDocletException(e.getMessage());
        }
    }

    protected void generateFileUsingTemplate(String dest_file, String templateFileName) throws XDocletException {
        Log log = LogUtil.getLog(class$xdoclet$tagshandler$MergeTagsHandler == null ? (class$xdoclet$tagshandler$MergeTagsHandler = MergeTagsHandler.class$("xdoclet.tagshandler.MergeTagsHandler")) : class$xdoclet$tagshandler$MergeTagsHandler, "generateFileUsingTemplate");
        TemplateTagHandler.getXJavaDoc().getSourceClasses();
        File file = new File(XDocletTagSupport.getDocletContext().getDestDir().toString(), dest_file);
        file.getParentFile().mkdirs();
        try {
            this.getEngine().setTemplateURL(new File(templateFileName).toURL());
            String content = FileManager.getURLContent(((TemplateSubTask)XDocletTagSupport.getDocletContext().getActiveSubTask()).getTemplateURL());
            if (content != null) {
                try {
                    PrettyPrintWriter out = new PrettyPrintWriter(new BufferedWriter(new FileWriter(file)));
                    this.getEngine().setWriter(out);
                    this.getEngine().setCurrentLineNum(0);
                    this.generate(content);
                    out.close();
                }
                catch (IOException ex) {
                    log.error((Object)("An error occured while writing output to file " + file), (Throwable)ex);
                }
            }
        }
        catch (MalformedURLException e) {
            throw new XDocletException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

