/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import java.io.Serializable;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xpath.Expression;
import org.apache.xpath.NodeSet;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathException;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XRTreeFrag;
import org.apache.xpath.objects.XString;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.NodeIterator;

public class XObject
extends Expression
implements Serializable {
    protected Object m_obj;
    public static final int CLASS_NULL = -1;
    public static final int CLASS_UNKNOWN = 0;
    public static final int CLASS_BOOLEAN = 1;
    public static final int CLASS_NUMBER = 2;
    public static final int CLASS_STRING = 3;
    public static final int CLASS_NODESET = 4;
    public static final int CLASS_RTREEFRAG = 5;
    public static final int CLASS_UNRESOLVEDVARIABLE = 600;

    public XObject() {
    }

    public XObject(Object object) {
        this.m_obj = object;
    }

    public boolean bool() throws TransformerException {
        this.error(18, new Object[]{this.getTypeString()});
        return false;
    }

    public Object castToType(int n, XPathContext xPathContext) throws TransformerException {
        Object object;
        switch (n) {
            case 3: {
                object = this.str();
                break;
            }
            case 2: {
                object = new Double(this.num());
                break;
            }
            case 4: {
                object = this.nodeset();
                break;
            }
            case 1: {
                object = new Boolean(this.bool());
                break;
            }
            case 0: {
                object = this.m_obj;
                break;
            }
            case 5: {
                object = this.rtree(xPathContext);
                break;
            }
            default: {
                this.error(21, new Object[]{this.getTypeString(), Integer.toString(n)});
                object = null;
            }
        }
        return object;
    }

    public static XObject create(Object object) {
        XObject xObject = object instanceof XObject ? (XObject)object : (object instanceof String ? new XString((String)object) : (object instanceof Boolean ? ((Boolean)object != false ? XBoolean.S_TRUE : XBoolean.S_FALSE) : (object instanceof Double ? new XNumber((Double)object) : (object instanceof DocumentFragment ? new XRTreeFrag((DocumentFragment)object) : (object instanceof Node ? new XNodeSet((Node)object) : (object instanceof NodeIterator ? new XNodeSet((NodeIterator)object) : new XObject(object)))))));
        return xObject;
    }

    public boolean equals(XObject xObject) throws TransformerException {
        if (xObject.getType() == 4) {
            return xObject.equals(this);
        }
        return this.m_obj.equals(xObject.m_obj);
    }

    protected void error(int n) throws TransformerException {
        this.error(n, null);
    }

    protected void error(int n, Object[] objectArray) throws TransformerException {
        String string = XSLMessages.createXPATHMessage(n, objectArray);
        throw new XPathException(string);
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        return this;
    }

    public int getType() {
        return 0;
    }

    public String getTypeString() {
        return "#UNKNOWN (" + this.object().getClass().getName() + ")";
    }

    public boolean greaterThan(XObject xObject) throws TransformerException {
        if (xObject.getType() == 4) {
            return xObject.lessThan(this);
        }
        return this.num() > xObject.num();
    }

    public boolean greaterThanOrEqual(XObject xObject) throws TransformerException {
        if (xObject.getType() == 4) {
            return xObject.lessThanOrEqual(this);
        }
        return this.num() >= xObject.num();
    }

    public boolean lessThan(XObject xObject) throws TransformerException {
        if (xObject.getType() == 4) {
            return xObject.greaterThan(this);
        }
        return this.num() < xObject.num();
    }

    public boolean lessThanOrEqual(XObject xObject) throws TransformerException {
        if (xObject.getType() == 4) {
            return xObject.greaterThanOrEqual(this);
        }
        return this.num() <= xObject.num();
    }

    public NodeSet mutableNodeset() throws TransformerException {
        this.error(20, new Object[]{this.getTypeString()});
        return (NodeSet)this.m_obj;
    }

    public NodeIterator nodeset() throws TransformerException {
        this.error(19, new Object[]{this.getTypeString()});
        return null;
    }

    public boolean notEquals(XObject xObject) throws TransformerException {
        if (xObject.getType() == 4) {
            return xObject.notEquals(this);
        }
        return this.equals(xObject) ^ true;
    }

    public double num() throws TransformerException {
        this.error(18, new Object[]{this.getTypeString()});
        return 0.0;
    }

    public Object object() {
        return this.m_obj;
    }

    public DocumentFragment rtree() {
        return null;
    }

    public DocumentFragment rtree(XPathContext xPathContext) {
        DocumentFragment documentFragment = this.rtree();
        if (documentFragment == null) {
            documentFragment = xPathContext.getDOMHelper().getDOMFactory().createDocumentFragment();
            Text text = xPathContext.getDOMHelper().getDOMFactory().createTextNode(this.str());
            documentFragment.appendChild(text);
        }
        return documentFragment;
    }

    public String str() {
        return this.m_obj.toString();
    }

    public String toString() {
        return this.str();
    }
}

