/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.util;

import java.util.StringTokenizer;

public final class StringUtil {
    private static final String SPACE_16 = "                ";
    private static final String SPACE_8 = "        ";
    private static final String SPACE_4 = "    ";
    private static final String SPACE_2 = "  ";
    private static final String SPACE_1 = " ";

    public static final String concat(String first, String second, String third) {
        return first + second + third;
    }

    public static final String concat(String[] list) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < list.length) {
            buffer.append(list[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static final String replaceSubString(String original, String oldString, String newString) {
        StringBuffer sb = new StringBuffer();
        int end = original.indexOf(oldString);
        int start = 0;
        int stringSize = oldString.length();
        while (end != -1) {
            sb.append(original.substring(start, end));
            sb.append(newString);
            start = end + stringSize;
            end = original.indexOf(oldString, start);
        }
        end = original.length();
        sb.append(original.substring(start, end));
        return sb.toString();
    }

    public static final String hexDisplay(byte[] data, int length) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < length) {
            int lineSize = Math.min(16, length - i);
            int lineEnd = lineSize + i;
            int j = i;
            while (j < lineEnd) {
                int value = data[j] & 0xFF;
                if (value < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(value));
                sb.append(' ');
                ++j;
            }
            int padcount = 16 - lineSize;
            while (padcount > 0) {
                --padcount;
                sb.append("   ");
            }
            sb.append(SPACE_2);
            int j2 = i;
            while (j2 < lineEnd) {
                int value = data[j2] & 0xFF;
                if (value < 32 || value > 255) {
                    sb.append('.');
                } else {
                    sb.append((char)value);
                }
                ++j2;
            }
            sb.append('\n');
            i += 16;
        }
        return sb.toString();
    }

    public static final String truncate(String string, int length) {
        if (length >= string.length()) {
            return string;
        }
        return string.substring(0, length);
    }

    public static final String truncateNicely(String string, int length) {
        if (length >= string.length()) {
            return string;
        }
        if (3 >= length) {
            StringBuffer sb = new StringBuffer(length);
            int i = 0;
            while (i < length) {
                sb.append('.');
                ++i;
            }
            return sb.toString();
        }
        StringBuffer sb = new StringBuffer(length);
        StringUtil.getIndexOfBreak(sb, string, 0, length - 3, true);
        sb.append("...");
        return sb.toString();
    }

    public static final String wordWrap(String string, int column, boolean force) {
        int length = string.length();
        StringBuffer sb = new StringBuffer();
        int start = 0;
        int end = StringUtil.getIndexOfBreak(sb, string, start, column, force);
        while (length != end) {
            sb.append("\n");
            start = end;
            end = StringUtil.getIndexOfBreak(sb, string, start, column, force);
        }
        return sb.toString();
    }

    public static final String[] split(String string, String onToken) {
        StringTokenizer tokenizer = new StringTokenizer(string, onToken);
        String[] result = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < result.length) {
            result[i] = tokenizer.nextToken();
            ++i;
        }
        return result;
    }

    public static final String join(String[] strings, String separator) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < strings.length) {
            sb.append(strings[i]);
            sb.append(separator);
            ++i;
        }
        return sb.toString();
    }

    public static final String format(int minSize, int maxSize, boolean rightJustify, String string) {
        StringBuffer sb = new StringBuffer(maxSize);
        StringUtil.format(sb, minSize, maxSize, rightJustify, string);
        return sb.toString();
    }

    public static final void format(StringBuffer sb, int minSize, int maxSize, boolean rightJustify, String string) {
        int size = string.length();
        if (size < minSize) {
            if (rightJustify) {
                StringUtil.appendWhiteSpace(sb, minSize - size);
                sb.append(string);
            } else {
                sb.append(string);
                StringUtil.appendWhiteSpace(sb, minSize - size);
            }
        } else if (maxSize > 0 && maxSize < size) {
            if (rightJustify) {
                sb.append(string.substring(size - maxSize));
            } else {
                sb.append(string.substring(0, maxSize));
            }
        } else {
            sb.append(string);
        }
    }

    public static final void appendWhiteSpace(StringBuffer sb, int length) {
        while (length >= 16) {
            sb.append(SPACE_16);
            length -= 16;
        }
        if (length >= 8) {
            sb.append(SPACE_8);
            length -= 8;
        }
        if (length >= 4) {
            sb.append(SPACE_4);
            length -= 4;
        }
        if (length >= 2) {
            sb.append(SPACE_2);
            length -= 2;
        }
        if (length >= 1) {
            sb.append(SPACE_1);
            --length;
        }
    }

    private static final int getIndexOfBreak(StringBuffer sb, String string, int start, int maxCount, boolean forceBreak) {
        int end = string.length() - start;
        int max = Math.min(maxCount, end);
        int base = 0;
        int i = 0;
        while (i < max) {
            int index = start + i;
            char ch = string.charAt(index);
            if (!Character.isWhitespace(ch)) break;
            base = i + 1;
            ++i;
        }
        max += base;
        int breakIndex = -1;
        int i2 = base;
        while (i2 < max) {
            int index = start + i2;
            char ch = string.charAt(index);
            if (Character.isWhitespace(ch)) {
                breakIndex = index;
            }
            ++i2;
        }
        if (-1 != breakIndex) {
            String part = string.substring(start + base, breakIndex);
            sb.append(part);
            return breakIndex + 1;
        }
        if (forceBreak) {
            String part = string.substring(start + base, start + max);
            sb.append(part);
            return start + max;
        }
        return StringUtil.getIndexOfBreak(sb, string, start, Integer.MAX_VALUE, true);
    }

    private StringUtil() {
    }
}

