/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.ant.Task;

public class LogOutputStream
extends OutputStream {
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private boolean skip = false;
    private Task task;
    private int level = 2;

    public LogOutputStream(Task task, int n) {
        this.task = task;
        this.level = n;
    }

    public void write(int n) throws IOException {
        byte by = (byte)n;
        if (by == 10 || by == 13) {
            if (!this.skip) {
                this.processBuffer();
            }
        } else {
            this.buffer.write(n);
        }
        this.skip = by == 13;
    }

    protected void processBuffer() {
        this.processLine(this.buffer.toString());
        this.buffer.reset();
    }

    protected void processLine(String string) {
        this.processLine(string, this.level);
    }

    protected void processLine(String string, int n) {
        this.task.log(string, n);
    }

    public void close() throws IOException {
        if (this.buffer.size() > 0) {
            this.processBuffer();
        }
        super.close();
    }

    public int getMessageLevel() {
        return this.level;
    }
}

