/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import java.util.Hashtable;
import org.apache.log.Category;
import org.apache.log.ContextStack;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.output.DefaultOutputLogTarget;

public final class LogKit {
    protected static final Hashtable c_kContexts = new Hashtable();
    protected static final Hashtable c_kLoggers = new Hashtable();
    protected static final Hashtable c_kCategories = new Hashtable();
    protected static final Hashtable c_kLogTargets;
    protected static Priority.Enum c_priority;
    protected static LogTarget c_defaultLogTarget;

    public static void addLogTarget(String name, LogTarget target) {
        if (name.equals("default")) {
            c_defaultLogTarget = target;
        }
        c_kLogTargets.put(name, target);
    }

    public static LogTarget getLogTarget(String name) {
        return (LogTarget)c_kLogTargets.get(name);
    }

    public static Category createCategory(String categoryName, Priority.Enum priority) {
        Category category = (Category)c_kCategories.get(categoryName);
        if (category == null) {
            category = new Category(categoryName);
            c_kCategories.put(categoryName, category);
        }
        category.setPriority(priority);
        return category;
    }

    public static Logger createLogger(Category category) {
        return LogKit.createLogger(category, null);
    }

    public static Logger createLogger(Category category, LogTarget[] logTargets) {
        String categoryName = category.getName();
        Logger logger = (Logger)c_kLoggers.get(categoryName);
        if (logger == null) {
            int index = categoryName.lastIndexOf(46);
            Logger parent = null;
            if (-1 != index) {
                String parentName = categoryName.substring(0, index);
                parent = LogKit.getLoggerFor(parentName);
            }
            logger = new Logger(category, logTargets, parent);
            c_kLoggers.put(categoryName, logger);
        } else if (logTargets != null) {
            logger.setLogTargets(logTargets);
        }
        return logger;
    }

    public static ContextStack getCurrentContext() {
        Thread thread = Thread.currentThread();
        ContextStack context = (ContextStack)c_kContexts.get(thread);
        if (context == null) {
            context = new ContextStack();
            context.push(thread.getName());
            c_kContexts.put(thread, context);
        }
        return context;
    }

    public static LogTarget getDefaultLogTarget() {
        return c_defaultLogTarget;
    }

    public static Priority.Enum getGlobalPriority() {
        return c_priority;
    }

    public static Logger getLoggerFor(String category) {
        Hashtable hashtable = c_kLoggers;
        synchronized (hashtable) {
            Logger logger = (Logger)c_kLoggers.get(category);
            if (logger == null) {
                logger = LogKit.createLogger(LogKit.createCategory(category, Priority.DEBUG));
            }
            Logger logger2 = logger;
            Object var2_4 = null;
            return logger2;
        }
    }

    public static Priority.Enum getPriorityForName(String priority) {
        if (Priority.DEBUG.getName().equals(priority)) {
            return Priority.DEBUG;
        }
        if (Priority.INFO.getName().equals(priority)) {
            return Priority.INFO;
        }
        if (Priority.WARN.getName().equals(priority)) {
            return Priority.WARN;
        }
        if (Priority.ERROR.getName().equals(priority)) {
            return Priority.ERROR;
        }
        if (Priority.FATAL_ERROR.getName().equals(priority)) {
            return Priority.FATAL_ERROR;
        }
        return Priority.DEBUG;
    }

    public static void log(String message, Throwable t) {
        System.err.println("Error: " + message);
        t.printStackTrace();
    }

    public static void log(String message) {
        System.err.println("Error: " + message);
    }

    public static void setDefaultLogTarget(LogTarget defaultLogTarget) {
        LogKit.addLogTarget("default", defaultLogTarget);
        c_defaultLogTarget = defaultLogTarget;
    }

    public static void setGlobalPriority(Priority.Enum priority) {
        c_priority = priority;
    }

    private LogKit() {
    }

    static {
        c_priority = Priority.DEBUG;
        c_kLogTargets = new Hashtable();
        c_defaultLogTarget = new DefaultOutputLogTarget();
        c_kLogTargets.put("default", c_defaultLogTarget);
    }
}

