/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.Touch;

public class Expand
extends MatchingTask {
    private File dest;
    private File source;

    public void execute() throws BuildException {
        if ("expand".equals(this.taskType)) {
            this.log("!! expand is deprecated. Use unzip instead. !!");
        }
        Touch touch = (Touch)this.project.createTask("touch");
        touch.setOwningTarget(this.target);
        touch.setTaskName(this.getTaskName());
        touch.setLocation(this.getLocation());
        if (this.source == null) {
            throw new BuildException("Source attribute must be specified");
        }
        if (this.dest == null) {
            throw new BuildException("Dest attribute must be specified");
        }
        if (this.source.isDirectory()) {
            DirectoryScanner directoryScanner = super.getDirectoryScanner(this.source);
            String[] stringArray = directoryScanner.getIncludedFiles();
            int n = 0;
            while (n < stringArray.length) {
                File file = new File(this.source, stringArray[n]);
                this.expandFile(touch, file, this.dest);
                ++n;
            }
        } else {
            this.expandFile(touch, this.source, this.dest);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void expandFile(Touch touch, File file, File file2) {
        ZipInputStream zipInputStream = null;
        try {
            try {
                this.log("Expanding: " + file + " into " + file2, 2);
                zipInputStream = new ZipInputStream(new FileInputStream(file));
                ZipEntry zipEntry = null;
                while (true) {
                    if ((zipEntry = zipInputStream.getNextEntry()) == null) {
                        this.log("expand complete", 3);
                        break;
                    }
                    File file3 = new File(file2, Project.translatePath(zipEntry.getName()));
                    try {
                        this.log("expand-file " + zipEntry.getName(), 3);
                        File file4 = new File(file3.getParent());
                        file4.mkdirs();
                        if (zipEntry.isDirectory()) {
                            file3.mkdirs();
                        } else {
                            byte[] byArray = new byte[1024];
                            int n = 0;
                            FileOutputStream fileOutputStream = new FileOutputStream(file3);
                            while (true) {
                                if ((n = zipInputStream.read(byArray)) < 0) {
                                    fileOutputStream.close();
                                    break;
                                }
                                fileOutputStream.write(byArray, 0, n);
                            }
                        }
                        if (Project.getJavaVersion() == "1.1") continue;
                        touch.setFile(file3);
                        touch.setMillis(zipEntry.getTime());
                        touch.touch();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.log("Unable to expand to file " + file3.getPath(), 1);
                    }
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Error while expanding " + file.getPath(), iOException);
            }
            Object var12_13 = null;
            if (zipInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (zipInputStream == null) throw throwable;
            try {
                zipInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        zipInputStream.close();
        return;
    }

    public void setDest(File file) {
        this.dest = file;
    }

    public void setSrc(File file) {
        this.source = file;
    }
}

