/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.concurrent;

public class DjikstraSemaphore {
    private int m_count;
    private int m_maxCount;
    private Object m_starvationLock = new Object();

    public void acquire() throws InterruptedException {
        DjikstraSemaphore djikstraSemaphore = this;
        synchronized (djikstraSemaphore) {
            while (this.m_count == 0) {
                this.wait();
            }
            --this.m_count;
            Object object = this.m_starvationLock;
            synchronized (object) {
                if (this.m_count == 0) {
                    this.m_starvationLock.notify();
                }
            }
        }
    }

    public boolean tryAcquire() {
        DjikstraSemaphore djikstraSemaphore = this;
        synchronized (djikstraSemaphore) {
            if (this.m_count != 0) {
                --this.m_count;
                Object object = this.m_starvationLock;
                synchronized (object) {
                    if (this.m_count == 0) {
                        this.m_starvationLock.notify();
                    }
                }
                boolean bl = true;
                Object var2_5 = null;
                return bl;
            }
            boolean bl = false;
            Object var2_6 = null;
            return bl;
        }
    }

    public void release() {
        DjikstraSemaphore djikstraSemaphore = this;
        synchronized (djikstraSemaphore) {
            ++this.m_count;
            if (this.m_count > this.m_maxCount) {
                this.m_count = this.m_maxCount;
            }
            this.notify();
        }
    }

    public void release(int count) {
        DjikstraSemaphore djikstraSemaphore = this;
        synchronized (djikstraSemaphore) {
            this.m_count = this.m_count + count > this.m_maxCount ? this.m_maxCount : (this.m_count += count);
            this.notifyAll();
        }
    }

    public void acquireAll() throws InterruptedException {
        DjikstraSemaphore djikstraSemaphore = this;
        synchronized (djikstraSemaphore) {
            int index = 0;
            while (index < this.m_maxCount) {
                this.acquire();
                ++index;
            }
        }
    }

    public void releaseAll() {
        DjikstraSemaphore djikstraSemaphore = this;
        synchronized (djikstraSemaphore) {
            this.release(this.m_maxCount);
            this.notifyAll();
        }
    }

    public void starvationCheck() throws InterruptedException {
        Object object = this.m_starvationLock;
        synchronized (object) {
            if (this.m_count != 0) {
                this.m_starvationLock.wait();
            }
        }
    }

    public DjikstraSemaphore(int maxCount) {
        this(maxCount, maxCount);
    }

    public DjikstraSemaphore(int maxCount, int initialCount) {
        this.m_count = initialCount;
        this.m_maxCount = maxCount;
    }
}

