/*
 * Decompiled with CFR 0.152.
 */
package junit.ui;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageProducer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.ui.AboutDialog;
import junit.ui.Logo;
import junit.ui.ProgressBar;
import junit.ui.TraceFrame;
import junit.util.StandardTestSuiteLoader;
import junit.util.StringUtil;
import junit.util.TestSuiteLoader;

public class TestRunner
implements TestListener {
    private Frame fFrame;
    private Vector fExceptions;
    private Vector fFailedTests;
    private Thread fRunner;
    private TestResult fTestResult;
    private TestSuiteLoader fTestLoader;
    private TraceFrame fTraceFrame;
    private TextField fSuiteField;
    private Button fRun;
    private ProgressBar fProgressIndicator;
    private List fFailureList;
    private Logo fLogo;
    private Label fNumberOfErrors;
    private Label fNumberOfFailures;
    private Label fNumberOfRuns;
    private Button fQuitButton;
    private Button fShowErrorButton;
    private Button fRerunButton;
    private TextField fStatusLine;
    private Panel fPanel;
    private static Font PLAIN_FONT = new Font("dialog", 0, 12);
    private static final int GAP = 4;
    private static final String SUITE_METHODNAME = "suite";
    static /* synthetic */ Class class$0;

    private void about() {
        AboutDialog about = new AboutDialog(this.fFrame);
        about.setModal(true);
        ((Component)about).setLocation(300, 300);
        ((Component)about).setVisible(true);
    }

    public void addError(Test test, Throwable t) {
        this.fNumberOfErrors.setText(Integer.toString(this.fTestResult.errorCount()));
        this.appendFailure("Error", test, t);
    }

    public void addFailure(Test test, Throwable t) {
        this.fNumberOfFailures.setText(Integer.toString(this.fTestResult.failureCount()));
        this.appendFailure("Failure", test, t);
    }

    private void addGrid(Panel p, Component co, int x, int y, int w, int fill, double wx, int anchor) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = x;
        c.gridy = y;
        c.gridwidth = w;
        c.anchor = anchor;
        c.weightx = wx;
        c.fill = fill;
        if (fill == 1 || fill == 3) {
            c.weighty = 1.0;
        }
        c.insets = new Insets(y == 0 ? 4 : 0, x == 0 ? 4 : 0, 4, 4);
        p.add(co, c);
    }

    private void appendFailure(String kind, Test test, Throwable t) {
        kind = String.valueOf(kind) + ": " + test;
        String msg = t.getMessage();
        if (msg != null) {
            kind = String.valueOf(kind) + ":" + StringUtil.truncate(msg, 100);
        }
        this.fFailureList.add(kind);
        this.fExceptions.addElement(t);
        this.fFailedTests.addElement(test);
    }

    protected Menu createJUnitMenu() {
        Menu menu = new Menu("JUnit");
        MenuItem mi = new MenuItem("About...");
        mi.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent event) {
                TestRunner.this.about();
            }
        });
        menu.add(mi);
        menu.addSeparator();
        mi = new MenuItem("Exit");
        mi.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });
        menu.add(mi);
        return menu;
    }

    protected void createMenus(MenuBar mb) {
        mb.add(this.createJUnitMenu());
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    protected Frame createUI(String suiteName) {
        Panel panel;
        Frame frame = new Frame("Run Test Suite");
        Image icon = this.loadFrameIcon();
        if (icon != null) {
            frame.setIconImage(icon);
        }
        frame.setLayout(new BorderLayout(0, 0));
        ((Component)frame).setBackground(SystemColor.control);
        final Frame finalFrame = frame;
        frame.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                finalFrame.dispose();
                System.exit(0);
            }
        });
        MenuBar mb = new MenuBar();
        this.createMenus(mb);
        frame.setMenuBar(mb);
        Label suiteLabel = new Label("Enter the name of the TestCase class:");
        this.fSuiteField = new TextField(suiteName != null ? suiteName : "");
        this.fSuiteField.selectAll();
        this.fSuiteField.requestFocus();
        this.fSuiteField.setFont(PLAIN_FONT);
        this.fSuiteField.setColumns(40);
        this.fSuiteField.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                TestRunner.this.runSuite();
            }
        });
        this.fSuiteField.addTextListener(new TextListener(){

            public final void textValueChanged(TextEvent e) {
                TestRunner.this.fRun.setEnabled(TestRunner.this.fSuiteField.getText().length() > 0);
                TestRunner.this.fStatusLine.setText("");
            }
        });
        Label suiteLabel2 = new Label(".suite()");
        this.fRun = new Button("Run");
        this.fRun.setEnabled(false);
        this.fRun.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                TestRunner.this.runSuite();
            }
        });
        Label progressLabel = new Label("Progress:");
        this.fProgressIndicator = new ProgressBar();
        this.fNumberOfErrors = new Label("0000", 2);
        this.fNumberOfErrors.setText("0");
        this.fNumberOfErrors.setFont(PLAIN_FONT);
        this.fNumberOfFailures = new Label("0000", 2);
        this.fNumberOfFailures.setText("0");
        this.fNumberOfFailures.setFont(PLAIN_FONT);
        this.fNumberOfRuns = new Label("0000", 2);
        this.fNumberOfRuns.setText("0");
        this.fNumberOfRuns.setFont(PLAIN_FONT);
        Panel numbersPanel = new Panel(new FlowLayout());
        numbersPanel.add(new Label("Runs:"));
        numbersPanel.add(this.fNumberOfRuns);
        numbersPanel.add(new Label("   Errors:"));
        numbersPanel.add(this.fNumberOfErrors);
        numbersPanel.add(new Label("   Failures:"));
        numbersPanel.add(this.fNumberOfFailures);
        Label failureLabel = new Label("Errors and Failures:");
        this.fFailureList = new List(6);
        this.fFailureList.addMouseListener(new MouseAdapter(){

            public final void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    TestRunner.this.showErrorTrace();
                }
            }
        });
        this.fFailureList.addItemListener(new ItemListener(){

            public final void itemStateChanged(ItemEvent e) {
                TestRunner.this.fShowErrorButton.setEnabled(TestRunner.this.isErrorSelected());
                TestRunner.this.fRerunButton.setEnabled(TestRunner.this.isErrorSelected());
            }
        });
        this.fShowErrorButton = new Button("Show...");
        this.fShowErrorButton.setEnabled(false);
        this.fShowErrorButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                TestRunner.this.showErrorTrace();
            }
        });
        this.fRerunButton = new Button("Run");
        this.fRerunButton.setEnabled(false);
        this.fRerunButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                TestRunner.this.rerun();
            }
        });
        Panel failedPanel = new Panel(new GridLayout(0, 1, 0, 2));
        failedPanel.add(this.fShowErrorButton);
        failedPanel.add(this.fRerunButton);
        this.fStatusLine = new TextField();
        this.fStatusLine.setFont(PLAIN_FONT);
        this.fStatusLine.setEditable(false);
        this.fStatusLine.setForeground(Color.red);
        this.fQuitButton = new Button("Exit");
        this.fQuitButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.fLogo = new Logo();
        this.fPanel = panel = new Panel(new GridBagLayout());
        this.addGrid(panel, suiteLabel, 0, 0, 2, 2, 1.0, 17);
        this.addGrid(panel, this.fSuiteField, 0, 1, 1, 2, 1.0, 17);
        this.addGrid(panel, suiteLabel2, 1, 1, 1, 0, 0.0, 17);
        this.addGrid(panel, this.fRun, 2, 1, 1, 2, 0.0, 10);
        this.addGrid(panel, progressLabel, 0, 2, 2, 2, 1.0, 17);
        this.addGrid(panel, this.fProgressIndicator, 0, 3, 2, 2, 1.0, 17);
        this.addGrid(panel, this.fLogo, 2, 3, 1, 0, 0.0, 11);
        this.addGrid(panel, numbersPanel, 0, 4, 2, 0, 0.0, 10);
        this.addGrid(panel, failureLabel, 0, 5, 2, 2, 1.0, 17);
        this.addGrid(panel, this.fFailureList, 0, 6, 2, 1, 1.0, 17);
        this.addGrid(panel, failedPanel, 2, 6, 1, 2, 0.0, 10);
        this.addGrid(panel, this.fStatusLine, 0, 7, 2, 2, 1.0, 10);
        this.addGrid(panel, this.fQuitButton, 2, 7, 1, 2, 0.0, 10);
        frame.add(panel);
        frame.pack();
        return frame;
    }

    public void endTest(Test test) {
        this.setLabelValue(this.fNumberOfRuns, this.fTestResult.runCount());
        this.fProgressIndicator.step(this.fTestResult.wasSuccessful());
    }

    private Test getTest(String suiteClassName) {
        if (suiteClassName.length() <= 0) {
            this.fStatusLine.setText("");
            return null;
        }
        Class testClass = null;
        try {
            testClass = this.loadSuiteClass(suiteClassName);
        }
        catch (Exception e) {
            this.runFailed("Class \"" + suiteClassName + "\" not found");
            return null;
        }
        Method suiteMethod = null;
        try {
            suiteMethod = testClass.getMethod(SUITE_METHODNAME, new Class[0]);
        }
        catch (Exception e) {
            this.fStatusLine.setText("");
            return new TestSuite(testClass);
        }
        Test test = null;
        try {
            test = (Test)suiteMethod.invoke(null, (Object[])new Class[0]);
            if (test == null) {
                return test;
            }
        }
        catch (Exception e) {
            this.runFailed("Could not invoke the suite() method");
            return null;
        }
        this.fStatusLine.setText("");
        return test;
    }

    private boolean isErrorSelected() {
        return this.fFailureList.getSelectedIndex() != -1;
    }

    private Image loadFrameIcon() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            URL url = this.getClass().getResource("smalllogo.gif");
            return toolkit.createImage((ImageProducer)url.getContent());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Class loadSuiteClass(String suiteClassName) throws ClassNotFoundException {
        return this.fTestLoader.load(suiteClassName);
    }

    public static void main(String[] args) {
        new TestRunner().start(args, new StandardTestSuiteLoader());
    }

    private void rerun() {
        int index = this.fFailureList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        Test test = (Test)this.fFailedTests.elementAt(index);
        if (!(test instanceof TestCase)) {
            this.showInfo("Could not reload " + test.toString());
            return;
        }
        Test reloadedTest = null;
        try {
            Class reloadedTestClass = this.fTestLoader.reload(test.getClass());
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class[] classArgs = classArray;
            Constructor constructor = reloadedTestClass.getConstructor(classArgs);
            Object[] args = new Object[]{((TestCase)test).name()};
            reloadedTest = (Test)constructor.newInstance(args);
        }
        catch (Exception e) {
            this.showInfo("Could not reload " + test.toString());
            return;
        }
        TestResult result = new TestResult();
        reloadedTest.run(result);
        String message = reloadedTest.toString();
        if (result.wasSuccessful()) {
            this.showInfo(String.valueOf(message) + " was successful");
        } else if (result.errorCount() == 1) {
            this.showStatus(String.valueOf(message) + " had an error");
        } else {
            this.showStatus(String.valueOf(message) + " had a failure");
        }
    }

    protected void reset() {
        this.setLabelValue(this.fNumberOfErrors, 0);
        this.setLabelValue(this.fNumberOfFailures, 0);
        this.setLabelValue(this.fNumberOfRuns, 0);
        this.fProgressIndicator.reset();
        this.fShowErrorButton.setEnabled(false);
        this.fRerunButton.setEnabled(false);
        this.fFailureList.removeAll();
        this.fExceptions = new Vector(10);
        this.fFailedTests = new Vector(10);
    }

    public void run() {
        this.runSuite();
    }

    private void runFailed(String message) {
        this.showStatus(message);
        this.fRun.setLabel("Run");
        this.fRunner = null;
    }

    public synchronized void runSuite() {
        if (this.fRunner != null) {
            this.fTestResult.stop();
        } else {
            this.fRun.setLabel("Stop");
            this.showInfo("Initializing...");
            this.reset();
            this.showInfo("Load Test Case...");
            final Test testSuite = this.getTest(this.fSuiteField.getText());
            if (testSuite != null) {
                this.fRunner = new Thread(){

                    public final void run() {
                        TestRunner.this.fTestResult = TestRunner.this.createTestResult();
                        TestRunner.this.fTestResult.addListener(TestRunner.this);
                        TestRunner.this.fProgressIndicator.start(testSuite.countTestCases());
                        TestRunner.this.showInfo("Running...");
                        long startTime = System.currentTimeMillis();
                        testSuite.run(TestRunner.this.fTestResult);
                        if (TestRunner.this.fTestResult.shouldStop()) {
                            TestRunner.this.showStatus("Stopped");
                        } else {
                            long endTime = System.currentTimeMillis();
                            long runTime = endTime - startTime;
                            TestRunner.this.showInfo("Finished: " + StringUtil.elapsedTimeAsString(runTime) + " seconds");
                        }
                        TestRunner.this.fTestResult = null;
                        TestRunner.this.fRun.setLabel("Run");
                        TestRunner.this.fRunner = null;
                    }
                };
                this.fRunner.start();
            }
        }
    }

    private void setLabelValue(Label label, int value) {
        label.setText(Integer.toString(value));
    }

    public void setSuiteName(String suite) {
        this.fSuiteField.setText(suite);
    }

    private void showErrorTrace() {
        int index = this.fFailureList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        Throwable t = (Throwable)this.fExceptions.elementAt(index);
        if (this.fTraceFrame == null) {
            this.fTraceFrame = new TraceFrame();
            ((Component)this.fTraceFrame).setLocation(100, 100);
        }
        this.fTraceFrame.showTrace(t);
        ((Component)this.fTraceFrame).setVisible(true);
    }

    private void showInfo(String message) {
        this.fStatusLine.setFont(PLAIN_FONT);
        this.fStatusLine.setForeground(Color.black);
        this.fStatusLine.setText(message);
    }

    private void showStatus(String status) {
        this.fStatusLine.setFont(PLAIN_FONT);
        this.fStatusLine.setForeground(Color.red);
        this.fStatusLine.setText(status);
    }

    public void start(String[] args, TestSuiteLoader loader) {
        this.fTestLoader = loader;
        String suiteName = null;
        if (args.length == 1) {
            suiteName = args[0];
        } else if (args.length == 2 && args[0].equals("-c")) {
            suiteName = StringUtil.extractClassName(args[1]);
        }
        this.fFrame = this.createUI(suiteName);
        ((Component)this.fFrame).setLocation(200, 200);
        ((Component)this.fFrame).setVisible(true);
        if (suiteName != null) {
            this.setSuiteName(suiteName);
            this.runSuite();
        }
    }

    public void startTest(Test test) {
        this.showInfo("Running: " + test);
    }
}

