/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.camelot;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.avalon.camelot.Info;
import org.apache.avalon.camelot.Registry;
import org.apache.avalon.camelot.RegistryException;

public class DefaultRegistry
implements Registry {
    protected final HashMap m_infos = new HashMap();
    protected final Class m_infoClass;

    public void register(String name, Info info) throws RegistryException {
        if (this.m_infos.get(name) != null) {
            throw new RegistryException("Name " + name + " already registered");
        }
        this.checkInfo(name, info);
        this.m_infos.put(name, info);
    }

    public void unregister(String name) throws RegistryException {
        if (this.m_infos.remove(name) == null) {
            throw new RegistryException("Name " + name + " not registered");
        }
    }

    public Info getInfo(String name) throws RegistryException {
        Info info = (Info)this.m_infos.get(name);
        if (info == null) {
            throw new RegistryException("Name " + name + " not registered");
        }
        return info;
    }

    public Iterator getInfoNames() {
        return this.m_infos.keySet().iterator();
    }

    protected void checkInfo(String name, Info info) throws RegistryException {
        if (!this.m_infoClass.isAssignableFrom(info.getClass())) {
            throw new RegistryException("Only Infos of type " + this.m_infoClass.getName() + " may be placed in registry.");
        }
    }

    public DefaultRegistry(Class clazz) {
        this.m_infoClass = clazz;
    }
}

