/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.doc;

import com.sun.javadoc.ClassDoc;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import xdoclet.TemplateSubTask;
import xdoclet.XDocletException;
import xdoclet.util.Translator;

public class DocumentTagsSubTask
extends TemplateSubTask {
    public static final String SUBTASK_NAME = "documentTags";
    private static String NAMESPACES_TEMPLATE_FILE = "/xdoclet/doc/namespaces.j";
    private static String GENERATED_NAMESPACES_FILE_NAME = "namespaces.html";
    private static String TAGS_MAIN_TEMPLATE_FILE = "/xdoclet/doc/tags_main.j";
    private static String GENERATED_TAGS_MAIN_FILE_NAME = "tags.html";
    private static String TAGS_TOC_MAIN_TEMPLATE_FILE = "/xdoclet/doc/tags_toc_main.j";
    private static String GENERATED_TAGS_TOC_MAIN_FILE_NAME = "tags_toc.html";
    private static String TAGS_TOC_TEMPLATE_FILE = "/xdoclet/doc/tags_toc.j";
    private static String GENERATED_TAGS_TOC_FILE_NAME = "{0}_toc.html";
    private static String TAGS_TEMPLATE_FILE = "/xdoclet/doc/tags.j";
    private static String GENERATED_TAGS_FILE_NAME = "{0}.html";
    private Namespace currentNamespace;
    private ArrayList namespaces = new ArrayList();
    private Properties tagMappings = new Properties();

    public String getSubTaskName() {
        return SUBTASK_NAME;
    }

    public Namespace getCurrentNamespace() {
        return this.currentNamespace;
    }

    public ArrayList getNamespaces() {
        return this.namespaces;
    }

    public Properties getTagMappings() {
        return this.tagMappings;
    }

    public void execute() throws XDocletException {
        Properties tag_handler_mappings = this.loadTagMappings();
        Set entry_set = ((Hashtable)tag_handler_mappings).entrySet();
        Iterator iterator = entry_set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.namespaces.add(new Namespace((String)entry.getKey(), (String)entry.getValue()));
        }
        Collections.sort(this.namespaces);
        System.out.println(Translator.getString("xdoclet.doc.Messages", "generating_namespaces"));
        this.setTemplateURL(this.getClass().getResource(NAMESPACES_TEMPLATE_FILE));
        this.setDestinationFile(GENERATED_NAMESPACES_FILE_NAME);
        this.startProcess();
        System.out.println(Translator.getString("xdoclet.doc.Messages", "generating_tags_main"));
        this.setTemplateURL(this.getClass().getResource(TAGS_MAIN_TEMPLATE_FILE));
        this.setDestinationFile(GENERATED_TAGS_MAIN_FILE_NAME);
        this.startProcess();
        System.out.println(Translator.getString("xdoclet.doc.Messages", "generating_tags_toc_main"));
        this.setTemplateURL(this.getClass().getResource(TAGS_TOC_MAIN_TEMPLATE_FILE));
        this.setDestinationFile(GENERATED_TAGS_TOC_MAIN_FILE_NAME);
        this.startProcess();
        System.out.println(Translator.getString("xdoclet.doc.Messages", "generating_tags_main"));
        this.setTemplateURL(this.getClass().getResource(TAGS_TOC_TEMPLATE_FILE));
        this.setDestinationFile(GENERATED_TAGS_TOC_FILE_NAME);
        this.setOfType("xdoclet.XDocletTagSupport");
        this.startProcess();
        System.out.println(Translator.getString("xdoclet.doc.Messages", "generating_tags_main"));
        this.setTemplateURL(this.getClass().getResource(TAGS_TEMPLATE_FILE));
        this.setDestinationFile(GENERATED_TAGS_FILE_NAME);
        this.setOfType("xdoclet.XDocletTagSupport");
        this.startProcess();
    }

    protected String getGeneratedFileName(ClassDoc clazz) throws XDocletException {
        String dest_file = MessageFormat.format(this.getDestinationFile(), this.currentNamespace.getName());
        return new File(dest_file).toString();
    }

    protected void generateForClass(ClassDoc clazz) throws XDocletException {
        this.setCurrentNamespace(clazz);
        super.generateForClass(clazz);
    }

    protected void engineStarted() throws XDocletException {
    }

    private void setCurrentNamespace(ClassDoc clazz) throws XDocletException {
        int i = 0;
        while (i < this.namespaces.size()) {
            Namespace namespace = (Namespace)this.namespaces.get(i);
            if (namespace.getTagsHandlerClassName().equals(clazz.qualifiedName())) {
                this.currentNamespace = namespace;
                break;
            }
            ++i;
        }
    }

    private Properties loadTagMappings() throws XDocletException {
        try {
            this.tagMappings.load(this.getClass().getResourceAsStream("/tagmappings.properties"));
        }
        catch (IOException e) {
            throw new XDocletException(Translator.getString("template_couldnt_load_mappings"));
        }
        return this.tagMappings;
    }

    public static class Namespace
    implements Comparable {
        private String name;
        private String tagsHandlerClassName;

        public Namespace(String name, String tagsHandlerClassName) {
            this.name = name;
            this.tagsHandlerClassName = tagsHandlerClassName;
        }

        public String getName() {
            return this.name;
        }

        public String getTagsHandlerClassName() {
            return this.tagsHandlerClassName;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setTagsHandlerClassName(String tagsHandlerClassName) {
            this.tagsHandlerClassName = tagsHandlerClassName;
        }

        public int compareTo(Object o) {
            return this.getName().compareTo(((Namespace)o).getName());
        }
    }
}

