/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class EnvironmentCheck {
    public static final String ERROR = "ERROR.";
    public static final String VERSION = "version.";
    public static final String FOUNDCLASSES = "foundclasses.";
    public static final String CLASS_PRESENT = "present-unknown-version";
    public static final String CLASS_NOTPRESENT = "not-present";
    public String[] jarNames = new String[]{"xalan.jar", "xalansamples.jar", "xalanj1compat.jar", "xalanservlet.jar", "xerces.jar", "testxsl.jar", "crimson.jar", "jaxp.jar", "parser.jar", "dom.jar", "sax.jar", "xml.jar"};
    protected PrintWriter outWriter = new PrintWriter(System.out, true);
    static /* synthetic */ Class class$java$lang$String;

    protected void checkDOMVersion(Hashtable hashtable) {
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
        }
        String string = "org.w3c.dom.Document";
        String string2 = "createElementNS";
        String string3 = "org.w3c.dom.Node";
        String string4 = "supported";
        String string5 = "org.w3c.dom.Node";
        String string6 = "isSupported";
        Class[] classArray = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = EnvironmentCheck.class$("java.lang.String")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = EnvironmentCheck.class$("java.lang.String"))};
        try {
            Class<?> clazz = Class.forName("org.w3c.dom.Document");
            Method method = clazz.getMethod("createElementNS", classArray);
            hashtable.put("version.DOM", "2.0");
            try {
                clazz = Class.forName("org.w3c.dom.Node");
                method = clazz.getMethod("supported", classArray);
                hashtable.put("ERROR.version.DOM.draftlevel", "2.0wd");
            }
            catch (Exception exception) {
                try {
                    clazz = Class.forName("org.w3c.dom.Node");
                    method = clazz.getMethod("isSupported", classArray);
                    hashtable.put("version.DOM.draftlevel", "2.0fd");
                }
                catch (Exception exception2) {
                    hashtable.put("ERROR.version.DOM.draftlevel", "2.0unknown");
                }
            }
        }
        catch (Exception exception) {
            hashtable.put("ERROR.version.DOM", "ERROR attempting to load DOM level 2 class: " + exception.toString());
        }
    }

    public boolean checkEnvironment(PrintWriter printWriter) {
        if (printWriter != null) {
            this.outWriter = printWriter;
        }
        Hashtable hashtable = new Hashtable();
        this.checkJAXPVersion(hashtable);
        this.checkProcessorVersion(hashtable);
        this.checkParserVersion(hashtable);
        this.checkDOMVersion(hashtable);
        this.checkSystemProperties(hashtable);
        boolean bl = this.writeEnvironmentReport(hashtable);
        if (bl) {
            this.logMsg("# WARNING: Potential problems found in your environment!");
            this.logMsg("#    Check any 'ERROR' items above against the Xalan FAQs");
            this.logMsg("#    to correct potential problems with your classes/jars");
            this.logMsg("#    http://xml.apache.org/xalan-j/faq.html");
            if (this.outWriter != null) {
                this.outWriter.flush();
            }
            return false;
        }
        this.logMsg("# YAHOO! Your environment seems to be OK.");
        if (this.outWriter != null) {
            this.outWriter.flush();
        }
        return true;
    }

    protected void checkJAXPVersion(Hashtable hashtable) {
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
        }
        Class[] classArray = new Class[]{};
        Class<?> clazz = null;
        try {
            String string = "javax.xml.parsers.DocumentBuilder";
            String string2 = "getDOMImplementation";
            clazz = Class.forName("javax.xml.parsers.DocumentBuilder");
            Method method = clazz.getMethod("getDOMImplementation", classArray);
            hashtable.put("version.JAXP", "1.1");
        }
        catch (Exception exception) {
            if (clazz != null) {
                hashtable.put("ERROR.version.JAXP", "1.0.1");
            }
            hashtable.put("ERROR.version.JAXP", "none");
        }
    }

    protected void checkParserVersion(Hashtable hashtable) {
        Class<?> clazz;
        String string;
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
        }
        try {
            string = "org.apache.xerces.framework.Version";
            clazz = Class.forName("org.apache.xerces.framework.Version");
            Field field = clazz.getField("fVersion");
            String string2 = (String)field.get(null);
            hashtable.put("version.xerces", string2);
        }
        catch (Exception exception) {
            hashtable.put("version.xerces", CLASS_NOTPRESENT);
        }
        try {
            string = "org.apache.crimson.Parser2";
            clazz = Class.forName("org.apache.crimson.Parser2");
            hashtable.put("version.crimson", CLASS_PRESENT);
        }
        catch (Exception exception) {
            hashtable.put("version.crimson", CLASS_NOTPRESENT);
        }
    }

    protected Vector checkPathForJars(String string, String[] stringArray) {
        if (string == null || stringArray == null || string.length() == 0 || stringArray.length == 0) {
            return null;
        }
        Vector vector = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().toLowerCase();
            int n = 0;
            while (n < stringArray.length) {
                if (string2.indexOf(stringArray[n]) > -1) {
                    File file = new File(string2);
                    if (file.exists()) {
                        try {
                            Hashtable<String, String> hashtable = new Hashtable<String, String>(5);
                            hashtable.put(String.valueOf(stringArray[n]) + ".path", file.getAbsolutePath());
                            hashtable.put(String.valueOf(stringArray[n]) + ".apparent.version", this.getApparentVersion(stringArray[n], file.length()));
                            vector.addElement(hashtable);
                        }
                        catch (Exception exception) {}
                    } else {
                        this.logMsg("# Warning: Classpath entry: " + string2 + " does not exist.");
                    }
                }
                ++n;
            }
        }
        return vector;
    }

    protected void checkProcessorVersion(Hashtable hashtable) {
        Field field;
        StringBuffer stringBuffer;
        Class<?> clazz;
        String string;
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
        }
        try {
            string = "org.apache.xalan.xslt.XSLProcessorVersion";
            clazz = Class.forName("org.apache.xalan.xslt.XSLProcessorVersion");
            stringBuffer = new StringBuffer();
            field = clazz.getField("PRODUCT");
            stringBuffer.append(field.get(null));
            stringBuffer.append(';');
            field = clazz.getField("LANGUAGE");
            stringBuffer.append(field.get(null));
            stringBuffer.append(';');
            field = clazz.getField("S_VERSION");
            stringBuffer.append(field.get(null));
            stringBuffer.append(';');
            hashtable.put("version.xalan1", stringBuffer.toString());
        }
        catch (Exception exception) {
            hashtable.put("version.xalan1", CLASS_NOTPRESENT);
        }
        try {
            string = "org.apache.xalan.processor.XSLProcessorVersion";
            clazz = Class.forName("org.apache.xalan.processor.XSLProcessorVersion");
            stringBuffer = new StringBuffer();
            field = clazz.getField("PRODUCT");
            stringBuffer.append(field.get(null));
            stringBuffer.append(";");
            field = clazz.getField("LANGUAGE");
            stringBuffer.append(field.get(null));
            stringBuffer.append(";");
            field = clazz.getField("S_VERSION");
            stringBuffer.append(field.get(null));
            stringBuffer.append(";");
            hashtable.put("version.xalan2", stringBuffer.toString());
        }
        catch (Exception exception) {
            hashtable.put("version.xalan2", CLASS_NOTPRESENT);
        }
    }

    protected void checkSystemProperties(Hashtable hashtable) {
        String string;
        if (hashtable == null) {
            hashtable = new Hashtable<String, Object>();
        }
        try {
            string = System.getProperty("java.version");
            hashtable.put("java.version", string);
        }
        catch (SecurityException securityException) {
            hashtable.put("java.version", "WARNING: SecurityException thrown accessing system version properties");
        }
        try {
            String string2;
            string = System.getProperty("java.class.path");
            hashtable.put("java.class.path", string);
            Vector vector = this.checkPathForJars(string, this.jarNames);
            if (vector != null) {
                hashtable.put("foundclasses.java.class.path", vector);
            }
            if ((string2 = System.getProperty("sun.boot.class.path")) != null) {
                hashtable.put("sun.boot.class.path", string2);
                vector = this.checkPathForJars(string2, this.jarNames);
                if (vector != null) {
                    hashtable.put("foundclasses.sun.boot.class.path", vector);
                }
            }
            if ((string2 = System.getProperty("java.ext.dirs")) != null) {
                hashtable.put("java.ext.dirs", string2);
                vector = this.checkPathForJars(string2, this.jarNames);
                if (vector != null) {
                    hashtable.put("foundclasses.java.ext.dirs", vector);
                }
            }
        }
        catch (SecurityException securityException) {
            hashtable.put("java.version", "WARNING: SecurityException thrown accessing system classpath properties");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected String getApparentVersion(String string, long l) {
        Hashtable<Long, String> hashtable = new Hashtable<Long, String>();
        hashtable.put(new Long(440237L), "xalan.jar from xalan-j_1_2");
        hashtable.put(new Long(436094L), "xalan.jar from xalan-j_1_2_1");
        hashtable.put(new Long(426249L), "xalan.jar from xalan-j_1_2_2");
        hashtable.put(new Long(702536L), "xalan.jar from xalan-j_2_0_0");
        hashtable.put(new Long(720930L), "xalan.jar from xalan-j_2_0_1");
        hashtable.put(new Long(857171L), "xalan.jar from lotusxsl-j_1_0_1");
        hashtable.put(new Long(802165L), "xalan.jar from lotusxsl-j_2_0_0");
        hashtable.put(new Long(424490L), "xalan.jar from Xerces Tools releases - ERROR:DO NOT USE!");
        hashtable.put(new Long(1498679L), "xerces.jar from xalan-j_1_2 from xerces-1_2_0.bin");
        hashtable.put(new Long(1484896L), "xerces.jar from xalan-j_1_2_1 from xerces-1_2_1.bin");
        hashtable.put(new Long(804460L), "xerces.jar from xalan-j_1_2_2 from xerces-1_2_2.bin");
        hashtable.put(new Long(1499244L), "xerces.jar from xalan-j_2_0_0 from xerces-1_2_3.bin");
        hashtable.put(new Long(1605266L), "xerces.jar from xalan-j_2_0_1 from xerces-1_3_0.bin");
        hashtable.put(new Long(1190776L), "xerces.jar from lotusxsl_1_0_1 apparently-from xerces-1_0_3.bin");
        hashtable.put(new Long(1489400L), "xerces.jar from lotusxsl-j_2_0_0 from XML4J-3_1_1");
        hashtable.put(new Long(37485L), "xalanj1compat.jar from xalan-j_2_0_0");
        hashtable.put(new Long(38100L), "xalanj1compat.jar from xalan-j_2_0_1");
        hashtable.put(new Long(18779L), "xalanservlet.jar from xalan-j_2_0_0");
        hashtable.put(new Long(21453L), "xalanservlet.jar from xalan-j_2_0_1");
        hashtable.put(new Long(5618L), "jaxp.jar from jaxp1.0.1");
        hashtable.put(new Long(136133L), "parser.jar from jaxp1.0.1");
        hashtable.put(new Long(28404L), "jaxp.jar from jaxp-1.1");
        hashtable.put(new Long(187162L), "crimson.jar from jaxp-1.1");
        hashtable.put(new Long(801714L), "xalan.jar from jaxp-1.1");
        hashtable.put(new Long(5537L), "jaxp.jar from jakarta-ant-1.3 or 1.2");
        hashtable.put(new Long(136198L), "parser.jar from jakarta-ant-1.3 or 1.2");
        String string2 = (String)hashtable.get(new Long(l));
        if (string2 != null && string2.startsWith(string)) {
            return string2;
        }
        if ("xerces.jar".equalsIgnoreCase(string) || "xalan.jar".equalsIgnoreCase(string)) {
            return String.valueOf(string) + " potential-ERROR " + CLASS_PRESENT;
        }
        return String.valueOf(string) + " " + CLASS_PRESENT;
    }

    protected boolean logFoundJars(Vector vector, String string) {
        if (vector == null || vector.size() < 1) {
            return false;
        }
        boolean bl = false;
        this.logMsg("#---- BEGIN Listing XML-related jars in: " + string + " ----");
        int n = 0;
        while (n < vector.size()) {
            Hashtable hashtable = (Hashtable)vector.elementAt(n);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                try {
                    String string2 = (String)k;
                    if (string2.startsWith(ERROR)) {
                        bl = true;
                    }
                    this.logMsg(String.valueOf(string2) + "=" + hashtable.get(string2));
                }
                catch (Exception exception) {
                    bl = true;
                    this.logMsg("Reading-" + k + "= threw: " + exception.toString());
                }
            }
            ++n;
        }
        this.logMsg("#----- END Listing XML-related jars in: " + string + " -----");
        return bl;
    }

    protected void logMsg(String string) {
        this.outWriter.println(string);
    }

    public static void main(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        int n = 0;
        while (n < stringArray.length) {
            if ("-out".equalsIgnoreCase(stringArray[n])) {
                if (++n < stringArray.length) {
                    try {
                        printWriter = new PrintWriter(new FileWriter(stringArray[n], true));
                    }
                    catch (Exception exception) {
                        System.err.println("# WARNING: -out " + stringArray[n] + " threw " + exception.toString());
                    }
                } else {
                    System.err.println("# WARNING: -out argument should have a filename, output sent to console");
                }
            }
            ++n;
        }
        EnvironmentCheck environmentCheck = new EnvironmentCheck();
        environmentCheck.checkEnvironment(printWriter);
    }

    protected boolean writeEnvironmentReport(Hashtable hashtable) {
        if (hashtable == null) {
            this.logMsg("# ERROR: writeEnvironmentReport called with null Hashtable");
            return false;
        }
        boolean bl = false;
        this.logMsg("#---- BEGIN writeEnvironmentReport($Revision: 1.2 $): Useful properties found: ----");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            try {
                String string = (String)k;
                if (string.startsWith(FOUNDCLASSES)) {
                    Vector vector = (Vector)hashtable.get(string);
                    bl |= this.logFoundJars(vector, string);
                    continue;
                }
                if (string.startsWith(ERROR)) {
                    bl = true;
                    this.logMsg(String.valueOf(string) + "=" + hashtable.get(string));
                    continue;
                }
                this.logMsg(String.valueOf(string) + "=" + hashtable.get(string));
            }
            catch (Exception exception) {
                this.logMsg("Reading-" + k + "= threw: " + exception.toString());
            }
        }
        this.logMsg("#----- END writeEnvironmentReport: Useful properties found: -----");
        return bl;
    }
}

