/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.event;

import org.apache.avalon.excalibur.concurrent.Mutex;
import org.apache.avalon.excalibur.event.AbstractQueue;
import org.apache.avalon.excalibur.event.PreparedEnqueue;
import org.apache.avalon.excalibur.event.QueueElement;
import org.apache.avalon.excalibur.event.SourceException;
import org.apache.avalon.excalibur.event.SourceFullException;

public final class FixedSizeQueue
extends AbstractQueue {
    private final QueueElement[] m_elements;
    private final Mutex m_mutex;
    private int m_start = 0;
    private int m_end = 0;
    private int m_reserve = 0;

    public FixedSizeQueue(int size) {
        this.m_elements = new QueueElement[size + 1];
        this.m_mutex = new Mutex();
    }

    public int size() {
        int size = 0;
        size = this.m_end < this.m_start ? this.maxSize() - this.m_start + this.m_end : this.m_end - this.m_start;
        return size;
    }

    public int maxSize() {
        return this.m_elements.length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PreparedEnqueue prepareEnqueue(QueueElement[] elements) throws SourceException {
        FixedSizePreparedEnqueue enqueue = null;
        try {
            try {
                this.m_mutex.acquire();
                if (elements.length + this.m_reserve + this.size() > this.maxSize()) {
                    throw new SourceFullException("Not enough room to enqueue these elements.");
                }
                enqueue = new FixedSizePreparedEnqueue(this, elements);
            }
            catch (InterruptedException ie) {
                Object var5_4 = null;
                this.m_mutex.release();
                return enqueue;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.m_mutex.release();
            throw throwable;
        }
        this.m_mutex.release();
        return enqueue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tryEnqueue(QueueElement element) {
        boolean success;
        block7: {
            boolean bl;
            block6: {
                success = false;
                try {
                    try {
                        this.m_mutex.acquire();
                        if (1 + this.m_reserve + this.size() > this.maxSize()) {
                            bl = false;
                            Object var5_5 = null;
                            break block6;
                        }
                        this.addElement(element);
                        success = true;
                        break block7;
                    }
                    catch (InterruptedException ie) {
                        Object var5_7 = null;
                        this.m_mutex.release();
                        return success;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    this.m_mutex.release();
                    throw throwable;
                }
            }
            this.m_mutex.release();
            return bl;
        }
        Object var5_6 = null;
        this.m_mutex.release();
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enqueue(QueueElement[] elements) throws SourceException {
        int len = elements.length;
        try {
            try {
                this.m_mutex.acquire();
                if (elements.length + this.m_reserve + this.size() > this.maxSize()) {
                    throw new SourceFullException("Not enough room to enqueue these elements.");
                }
                int i = 0;
                while (i < len) {
                    this.addElement(elements[i]);
                    ++i;
                }
            }
            catch (InterruptedException ie) {
                Object var5_6 = null;
                this.m_mutex.release();
                return;
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.m_mutex.release();
            throw throwable;
        }
        this.m_mutex.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enqueue(QueueElement element) throws SourceException {
        try {
            try {
                this.m_mutex.acquire();
                if (1 + this.m_reserve + this.size() > this.maxSize()) {
                    throw new SourceFullException("Not enough room to enqueue these elements.");
                }
                this.addElement(element);
            }
            catch (InterruptedException ie) {
                Object var4_3 = null;
                this.m_mutex.release();
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_mutex.release();
            throw throwable;
        }
        this.m_mutex.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QueueElement[] dequeue(int numElements) {
        int arraySize = numElements;
        if (this.size() < numElements) {
            arraySize = this.size();
        }
        QueueElement[] elements = null;
        try {
            try {
                this.m_mutex.attempt(this.m_timeout);
                if (this.size() < numElements) {
                    arraySize = this.size();
                }
                elements = new QueueElement[arraySize];
                int i = 0;
                while (i < arraySize) {
                    elements[i] = this.removeElement();
                    ++i;
                }
            }
            catch (InterruptedException ie) {
                Object var6_7 = null;
                this.m_mutex.release();
                return elements;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.m_mutex.release();
            throw throwable;
        }
        this.m_mutex.release();
        return elements;
    }

    private final void addElement(QueueElement element) {
        this.m_elements[this.m_end] = element;
        ++this.m_end;
        if (this.m_end >= this.maxSize()) {
            this.m_end = 0;
        }
    }

    private final QueueElement removeElement() {
        QueueElement element = this.m_elements[this.m_start];
        if (null != element) {
            this.m_elements[this.m_start] = null;
            ++this.m_start;
            if (this.m_start >= this.maxSize()) {
                this.m_start = 0;
            }
        }
        return element;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QueueElement[] dequeueAll() {
        QueueElement[] elements = null;
        try {
            try {
                this.m_mutex.attempt(this.m_timeout);
                elements = new QueueElement[this.size()];
                int i = 0;
                while (i < elements.length) {
                    elements[i] = this.removeElement();
                    ++i;
                }
            }
            catch (InterruptedException ie) {
                Object var4_5 = null;
                this.m_mutex.release();
                return elements;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.m_mutex.release();
            throw throwable;
        }
        this.m_mutex.release();
        return elements;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QueueElement dequeue() {
        QueueElement element = null;
        try {
            block4: {
                try {
                    this.m_mutex.attempt(this.m_timeout);
                    if (this.size() <= 0) break block4;
                    element = this.removeElement();
                }
                catch (InterruptedException ie) {
                    Object var4_3 = null;
                    this.m_mutex.release();
                    return element;
                }
            }
            Object var4_2 = null;
            this.m_mutex.release();
            return element;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_mutex.release();
            throw throwable;
        }
    }

    private static final class FixedSizePreparedEnqueue
    implements PreparedEnqueue {
        private final FixedSizeQueue m_parent;
        private QueueElement[] m_elements;

        private FixedSizePreparedEnqueue(FixedSizeQueue parent, QueueElement[] elements) {
            this.m_parent = parent;
            this.m_elements = elements;
        }

        public void commit() {
            if (null == this.m_elements) {
                throw new IllegalStateException("This PreparedEnqueue has already been processed!");
            }
            try {
                this.m_parent.enqueue(this.m_elements);
                this.m_parent.m_reserve -= this.m_elements.length;
                this.m_elements = null;
            }
            catch (Exception e) {
                throw new IllegalStateException("Default enqueue did not happen--should be impossible");
            }
        }

        public void abort() {
            if (null == this.m_elements) {
                throw new IllegalStateException("This PreparedEnqueue has already been processed!");
            }
            this.m_parent.m_reserve -= this.m_elements.length;
            this.m_elements = null;
        }
    }
}

