/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.regexp;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.regexp.RegexpMatcher;

public class RegexpMatcherFactory {
    public RegexpMatcher newRegexpMatcher() throws BuildException {
        String string = System.getProperty("ant.regexp.matcherimpl");
        if (string != null) {
            return this.createInstance(string);
        }
        try {
            return this.createInstance("org.apache.tools.ant.util.regexp.Jdk14RegexpMatcher");
        }
        catch (BuildException buildException) {
            try {
                return this.createInstance("org.apache.tools.ant.util.regexp.JakartaOroMatcher");
            }
            catch (BuildException buildException2) {
                try {
                    return this.createInstance("org.apache.tools.ant.util.regexp.JakartaRegexpMatcher");
                }
                catch (BuildException buildException3) {
                    throw new BuildException("No supported regular expression matcher found");
                }
            }
        }
    }

    protected RegexpMatcher createInstance(String string) throws BuildException {
        try {
            Class<?> clazz = Class.forName(string);
            return (RegexpMatcher)clazz.newInstance();
        }
        catch (Throwable throwable) {
            throw new BuildException(throwable);
        }
    }
}

