/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.IteratorPool;
import org.apache.xpath.axes.PredicatedNodeTest;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;

public abstract class LocPathIterator
extends PredicatedNodeTest
implements Cloneable,
DTMIterator,
Serializable {
    private boolean m_allowDetach = true;
    protected transient IteratorPool m_clones = new IteratorPool(this);
    protected transient DTM m_cdtm;
    transient int m_stackFrame = -1;
    private boolean m_isTopLevel = false;
    protected transient int m_last = 0;
    public transient int m_lastFetched = -1;
    transient NodeSetDTM m_cachedNodes;
    protected transient int m_context = -1;
    protected transient int m_currentContextNode = -1;
    protected PrefixResolver m_prefixResolver;
    protected transient XPathContext m_execContext;
    protected transient int m_next;

    protected LocPathIterator(PrefixResolver nscontext) {
        this.setLocPathIterator(this);
        this.m_prefixResolver = nscontext;
    }

    protected LocPathIterator(Compiler compiler, int opPos, int analysis) throws TransformerException {
        this(compiler, opPos, analysis, true);
    }

    protected LocPathIterator(Compiler compiler, int opPos, int analysis, boolean shouldLoadWalkers) throws TransformerException {
        this.setLocPathIterator(this);
    }

    private void readObject(ObjectInputStream stream) throws IOException, TransformerException {
        try {
            stream.defaultReadObject();
            this.m_clones = new IteratorPool(this);
        }
        catch (ClassNotFoundException cnfe) {
            throw new TransformerException(cnfe);
        }
    }

    public void setEnvironment(Object environment) {
    }

    public DTM getDTM(int nodeHandle) {
        return this.m_execContext.getDTM(nodeHandle);
    }

    public DTMManager getDTMManager() {
        return this.m_execContext.getDTMManager();
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        LocPathIterator clone = (LocPathIterator)this.m_clones.getInstance();
        int current = xctxt.getCurrentNode();
        clone.setRoot(current, xctxt);
        return new XNodeSet(clone);
    }

    public DTMIterator asIterator(XPathContext xctxt, int contextNode) throws TransformerException {
        LocPathIterator clone = (LocPathIterator)this.m_clones.getInstance();
        clone.setRoot(contextNode, xctxt);
        return clone;
    }

    public boolean isNodesetExpr() {
        return true;
    }

    public int asNode(XPathContext xctxt) throws TransformerException {
        DTMIterator iter = this.m_clones.getInstance();
        int current = xctxt.getCurrentNode();
        iter.setRoot(current, xctxt);
        int next = iter.nextNode();
        iter.detach();
        return next;
    }

    public boolean bool(XPathContext xctxt) throws TransformerException {
        return this.asNode(xctxt) != -1;
    }

    public void setIsTopLevel(boolean b) {
        this.m_isTopLevel = b;
    }

    public boolean getIsTopLevel() {
        return this.m_isTopLevel;
    }

    public void setRoot(int context, Object environment) {
        XPathContext xctxt;
        this.m_context = context;
        this.m_execContext = xctxt = (XPathContext)environment;
        this.m_cdtm = xctxt.getDTM(context);
        this.m_currentContextNode = context;
        this.m_prefixResolver = xctxt.getNamespaceContext();
        if (this.m_isTopLevel) {
            this.m_stackFrame = xctxt.getVarStack().getStackFrame();
        }
        this.reset();
    }

    protected void setNextPosition(int next) {
        this.m_next = next;
    }

    public final int getCurrentPos() {
        return this.m_next;
    }

    void incrementNextPosition() {
        ++this.m_next;
    }

    public void setShouldCacheNodes(boolean b) {
        if (b) {
            if (null == this.m_cachedNodes) {
                this.m_cachedNodes = new NodeSetDTM(this.getDTMManager());
            }
        } else {
            this.m_cachedNodes = null;
        }
    }

    public boolean isMutable() {
        return this.m_cachedNodes != null;
    }

    public NodeSetDTM getCachedNodes() {
        return this.m_cachedNodes;
    }

    public void setCurrentPos(int i) {
        if (null == this.m_cachedNodes) {
            throw new RuntimeException("This NodeSetDTM can not do indexing or counting functions!");
        }
        this.setNextPosition(i);
        this.m_cachedNodes.setCurrentPos(i);
    }

    public int size() {
        if (null == this.m_cachedNodes) {
            return 0;
        }
        return this.m_cachedNodes.size();
    }

    public int item(int index) {
        return this.m_cachedNodes.item(index);
    }

    public void setItem(int node, int index) {
        this.m_cachedNodes.setElementAt(node, index);
    }

    public int getLength() {
        if (this.m_last > 0) {
            return this.m_last;
        }
        this.m_last = null == this.m_cachedNodes || !this.m_foundLast ? this.findLastPos(this.m_execContext) : this.m_cachedNodes.getLength();
        return this.m_last;
    }

    private void resetToCachedList() {
        int pos = this.getCurrentPos();
        if (null == this.m_cachedNodes || pos != 0) {
            this.setShouldCacheNodes(true);
        }
        this.runTo(-1);
        this.setCurrentPos(pos);
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    public int previousNode() {
        if (null == this.m_cachedNodes) {
            throw new RuntimeException("This NodeSetDTM can not iterate to a previous node!");
        }
        return this.m_cachedNodes.previousNode();
    }

    public int getWhatToShow() {
        return -17;
    }

    public DTMFilter getFilter() {
        return null;
    }

    public int getRoot() {
        return this.m_context;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public void allowDetachToRelease(boolean allowRelease) {
        this.m_allowDetach = allowRelease;
    }

    public void detach() {
        if (this.m_allowDetach) {
            this.m_cachedNodes = null;
            this.m_execContext = null;
            this.m_prefixResolver = null;
            this.m_cdtm = null;
            this.m_clones.freeInstance(this);
        }
    }

    public void reset() {
        this.m_foundLast = false;
        this.m_lastFetched = -1;
        this.m_next = 0;
        this.m_last = 0;
    }

    public DTMIterator cloneWithReset() throws CloneNotSupportedException {
        LocPathIterator clone = (LocPathIterator)this.clone();
        clone.reset();
        return clone;
    }

    public abstract int nextNode();

    protected int returnNextNode(int nextNode) {
        if (-1 != nextNode) {
            if (null != this.m_cachedNodes) {
                this.m_cachedNodes.addElement(nextNode);
            }
            this.incrementNextPosition();
        }
        this.m_lastFetched = nextNode;
        if (-1 == nextNode) {
            this.m_foundLast = true;
        }
        return nextNode;
    }

    public int getCurrentNode() {
        return this.m_lastFetched;
    }

    /*
     * Unable to fully structure code
     */
    public void runTo(int index) {
        block3: {
            if (this.m_foundLast || index >= 0 && index <= this.getCurrentPos()) {
                return;
            }
            if (-1 != index) ** GOTO lbl-1000
            while (-1 != (n = this.nextNode())) {
            }
            break block3;
            while (this.getCurrentPos() < index) lbl-1000:
            // 2 sources

            {
                if (-1 != (n = this.nextNode())) continue;
            }
        }
    }

    public final boolean getFoundLast() {
        return this.m_foundLast;
    }

    public final XPathContext getXPathContext() {
        return this.m_execContext;
    }

    public final int getContext() {
        return this.m_context;
    }

    public final int getCurrentContextNode() {
        return this.m_currentContextNode;
    }

    public final void setCurrentContextNode(int n) {
        this.m_currentContextNode = n;
    }

    public final PrefixResolver getPrefixResolver() {
        return this.m_prefixResolver;
    }

    public int getLast() {
        return this.getLength();
    }

    public void setLast(int last) {
        this.m_last = last;
    }

    public int getLastPos(XPathContext xctxt) {
        return this.getLength();
    }

    public int findLastPos(XPathContext xctxt) {
        int next;
        LocPathIterator clone;
        int savedPos = null != this.m_cachedNodes ? this.m_cachedNodes.getCurrentPos() : -1;
        int pos = this.m_predicateIndex >= 0 ? this.getProximityPosition() : (null != this.m_cachedNodes ? this.m_cachedNodes.getCurrentPos() : this.m_next);
        try {
            clone = 0 == pos && this.m_currentContextNode != -1 ? (LocPathIterator)this.cloneWithReset() : (LocPathIterator)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return -1;
        }
        int predCount = clone.getPredicateCount();
        if (predCount > 0 && this == this.m_execContext.getSubContextList()) {
            clone.m_predCount = predCount - 1;
        }
        while (-1 != (next = clone.nextNode())) {
            ++pos;
        }
        if (-1 != savedPos) {
            this.m_cachedNodes.setCurrentPos(savedPos);
        }
        return pos;
    }

    public boolean isDocOrdered() {
        return true;
    }

    public int getAxis() {
        return -1;
    }
}

