/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.avalon.excalibur.io.IOUtil;

public final class FileUtil {
    private FileUtil() {
    }

    public static boolean contentEquals(File file1, File file2) throws IOException {
        boolean bl;
        boolean file1Exists = file1.exists();
        if (file1Exists != file2.exists()) {
            return false;
        }
        if (!file1Exists) {
            return true;
        }
        if (file1.isDirectory() || file2.isDirectory()) {
            return false;
        }
        FileInputStream input1 = null;
        FileInputStream input2 = null;
        try {
            input1 = new FileInputStream(file1);
            input2 = new FileInputStream(file2);
            bl = IOUtil.contentEquals(input1, input2);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            IOUtil.shutdownStream(input1);
            IOUtil.shutdownStream(input2);
            throw throwable;
        }
        IOUtil.shutdownStream(input1);
        IOUtil.shutdownStream(input2);
        return bl;
    }

    public static File toFile(URL url) {
        if (!url.getProtocol().equals("file")) {
            return null;
        }
        String filename = url.getFile().replace('/', File.separatorChar);
        return new File(filename);
    }

    public static URL[] toURLs(File[] files) throws IOException {
        URL[] urls = new URL[files.length];
        int i = 0;
        while (i < urls.length) {
            urls[i] = files[i].toURL();
            ++i;
        }
        return urls;
    }

    public static String removeExtention(String filename) {
        return FileUtil.removeExtension(filename);
    }

    public static String removeExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (-1 == index) {
            return filename;
        }
        return filename.substring(0, index);
    }

    public static String getExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (-1 == index) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static String removePath(String filepath) {
        return FileUtil.removePath(filepath, File.separatorChar);
    }

    public static String removePath(String filepath, char fileSeparatorChar) {
        int index = filepath.lastIndexOf(fileSeparatorChar);
        if (-1 == index) {
            return filepath;
        }
        return filepath.substring(index + 1);
    }

    public static String getPath(String filepath) {
        return FileUtil.getPath(filepath, File.separatorChar);
    }

    public static String getPath(String filepath, char fileSeparatorChar) {
        int index = filepath.lastIndexOf(fileSeparatorChar);
        if (-1 == index) {
            return "";
        }
        return filepath.substring(0, index);
    }

    public static void copyFileToDirectory(String source, String destinationDirectory) throws IOException {
        FileUtil.copyFileToDirectory(new File(source), new File(destinationDirectory));
    }

    public static void copyFileToDirectory(File source, File destinationDirectory) throws IOException {
        if (destinationDirectory.exists() && !destinationDirectory.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory");
        }
        FileUtil.copyFile(source, new File(destinationDirectory, source.getName()));
    }

    public static void copyFile(File source, File destination) throws IOException {
        if (!source.exists()) {
            String message = "File " + source + " does not exist";
            throw new IOException(message);
        }
        if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        if (destination.exists() && !destination.canWrite()) {
            String message = "Unable to open file " + destination + " for writing.";
            throw new IOException(message);
        }
        FileInputStream input = new FileInputStream(source);
        FileOutputStream output = new FileOutputStream(destination);
        IOUtil.copy((InputStream)input, (OutputStream)output);
        IOUtil.shutdownStream(input);
        IOUtil.shutdownStream(output);
        if (source.length() != destination.length()) {
            String message = "Failed to copy full contents from " + source + " to " + destination;
            throw new IOException(message);
        }
    }

    public static void copyURLToFile(URL source, File destination) throws IOException {
        if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        if (destination.exists() && !destination.canWrite()) {
            String message = "Unable to open file " + destination + " for writing.";
            throw new IOException(message);
        }
        InputStream input = source.openStream();
        FileOutputStream output = new FileOutputStream(destination);
        IOUtil.copy(input, (OutputStream)output);
        IOUtil.shutdownStream(input);
        IOUtil.shutdownStream(output);
    }

    public static String normalize(String path) {
        int index;
        String normalized = path;
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    public static String catPath(String lookupPath, String path) {
        int index = lookupPath.lastIndexOf("/");
        String lookup = lookupPath.substring(0, index);
        String pth = path;
        while (pth.startsWith("../")) {
            if (lookup.length() <= 0) {
                return null;
            }
            index = lookup.lastIndexOf("/");
            lookup = lookup.substring(0, index);
            index = pth.indexOf("../") + 3;
            pth = pth.substring(index);
        }
        return lookup + "/" + pth;
    }

    public static File resolveFile(File baseFile, String filename) {
        String filenm = null;
        if ('/' != File.separatorChar) {
            filenm = filename.replace('/', File.separatorChar);
        }
        if ('\\' != File.separatorChar) {
            filenm = filename.replace('\\', File.separatorChar);
        }
        if (filenm.startsWith(File.separator)) {
            File file = new File(filenm);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return file;
        }
        char[] chars = filename.toCharArray();
        StringBuffer sb = new StringBuffer();
        int start = 0;
        if ('\\' == File.separatorChar) {
            sb.append(filenm.charAt(0));
            ++start;
        }
        int i = start;
        while (i < chars.length) {
            boolean doubleSeparator;
            boolean bl = doubleSeparator = File.separatorChar == chars[i] && File.separatorChar == chars[i - 1];
            if (!doubleSeparator) {
                sb.append(chars[i]);
            }
            ++i;
        }
        filenm = sb.toString();
        File file = new File(baseFile, filenm).getAbsoluteFile();
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return file;
    }

    public static void forceDelete(String file) throws IOException {
        FileUtil.forceDelete(new File(file));
    }

    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtil.deleteDirectory(file);
        } else if (!file.delete()) {
            String message = "File " + file + " unable to be deleted.";
            throw new IOException(message);
        }
    }

    public static void forceMkdir(File file) throws IOException {
        if (file.exists()) {
            if (file.isFile()) {
                String message = "File " + file + " exists and is " + "not a directory. Unable to create directory.";
                throw new IOException(message);
            }
        } else if (!file.mkdirs()) {
            String message = "Unable to create directory " + file;
            throw new IOException(message);
        }
    }

    public static void deleteDirectory(String directory) throws IOException {
        FileUtil.deleteDirectory(new File(directory));
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileUtil.cleanDirectory(directory);
        if (!directory.delete()) {
            throw new IOException("Directory " + directory + " unable to be deleted.");
        }
    }

    public static void cleanDirectory(String directory) throws IOException {
        FileUtil.cleanDirectory(new File(directory));
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            FileUtil.forceDelete(file);
            ++i;
        }
    }

    private static String replaceSubString(String original, String oldString, String newString) {
        StringBuffer sb = new StringBuffer();
        int end = original.indexOf(oldString);
        int start = 0;
        int stringSize = oldString.length();
        while (end != -1) {
            sb.append(original.substring(start, end));
            sb.append(newString);
            start = end + stringSize;
            end = original.indexOf(oldString, start);
        }
        end = original.length();
        sb.append(original.substring(start, end));
        return sb.toString();
    }

    public static long sizeOfDirectory(String directory) {
        return FileUtil.sizeOfDirectory(new File(directory));
    }

    public static long sizeOfDirectory(File directory) {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        long size = 0L;
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            size = file.isDirectory() ? (size += FileUtil.sizeOfDirectory(file)) : (size += file.length());
            ++i;
        }
        return size;
    }
}

