/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ResettableFileInputStream
extends InputStream {
    protected static final int DEFAULT_BUFFER_SIZE = 1024;
    protected final String m_filename;
    protected int m_bufferSize;
    protected InputStream m_inputStream;
    protected long m_position;
    protected long m_mark;
    protected boolean m_isMarkSet;

    public void mark(int readLimit) {
        this.m_isMarkSet = true;
        this.m_mark = this.m_position;
        this.m_inputStream.mark(readLimit);
    }

    public boolean markSupported() {
        return true;
    }

    public void reset() throws IOException {
        if (!this.m_isMarkSet) {
            throw new IOException("Unmarked Stream");
        }
        try {
            this.m_inputStream.reset();
        }
        catch (IOException ioe) {
            try {
                this.m_inputStream.close();
                this.m_inputStream = this.newStream();
                this.m_inputStream.skip(this.m_mark);
                this.m_position = this.m_mark;
            }
            catch (Exception e) {
                throw new IOException("Cannot reset current Stream: " + e.getMessage());
            }
        }
    }

    protected InputStream newStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.m_filename), this.m_bufferSize);
    }

    public int available() throws IOException {
        return this.m_inputStream.available();
    }

    public void close() throws IOException {
        this.m_inputStream.close();
    }

    public int read() throws IOException {
        ++this.m_position;
        return this.m_inputStream.read();
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        int count = this.m_inputStream.read(bytes, offset, length);
        this.m_position += (long)count;
        return count;
    }

    public long skip(long count) throws IOException {
        this.m_position += count;
        return this.m_inputStream.skip(count);
    }

    public ResettableFileInputStream(File file) throws IOException {
        this(file.getCanonicalPath());
    }

    public ResettableFileInputStream(String filename) throws IOException {
        this(filename, 1024);
    }

    public ResettableFileInputStream(String filename, int bufferSize) throws IOException {
        this.m_bufferSize = bufferSize;
        this.m_filename = filename;
        this.m_position = 0L;
        this.m_inputStream = this.newStream();
    }
}

