/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.io;

import java.io.IOException;
import java.io.InputStream;

public class ByteTerminatedInputStream
extends InputStream {
    protected final boolean m_includeTerminator;
    protected final InputStream m_inputStream;
    protected final byte[] m_terminator;
    protected final int m_matchLength;
    protected int m_match;

    public int read() throws IOException {
        if (this.m_match == this.m_matchLength) {
            return -1;
        }
        int next = this.getNext();
        if (!this.m_includeTerminator && this.m_match != 0) {
            this.m_inputStream.mark(this.m_matchLength);
            int matchTest = next;
            while (-1 != matchTest) {
                matchTest = this.getNext();
                if (this.m_match == this.m_matchLength) {
                    return -1;
                }
                if (this.m_match == 0) break;
            }
            this.m_match = 0;
            this.m_inputStream.reset();
        }
        return next;
    }

    protected final int getNext() throws IOException {
        int next = this.m_inputStream.read();
        this.m_match = next == this.m_terminator[this.m_match] ? ++this.m_match : (next == this.m_terminator[0] ? 1 : 0);
        return next;
    }

    public ByteTerminatedInputStream(InputStream inputStream, byte[] terminator, boolean includeTerminator) {
        this.m_includeTerminator = includeTerminator;
        this.m_matchLength = terminator.length;
        this.m_terminator = terminator;
        this.m_inputStream = inputStream;
        this.m_match = 0;
    }
}

