/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.cli;

import java.text.ParseException;
import java.util.Vector;
import org.apache.avalon.util.cli.CLOption;
import org.apache.avalon.util.cli.CLOptionDescriptor;
import org.apache.avalon.util.cli.ParserControl;

public final class CLArgsParser {
    private static final int STATE_NORMAL = 0;
    private static final int STATE_REQUIRE_2ARGS = 1;
    private static final int STATE_REQUIRE_ARG = 2;
    private static final int STATE_OPTIONAL_ARG = 3;
    private static final int STATE_NO_OPTIONS = 4;
    private static final int STATE_OPTION_MODE = 5;
    protected static final int TOKEN_SEPERATOR = 0;
    protected static final int TOKEN_STRING = 1;
    protected static final char[] ARG2_SEPERATORS = new char[]{'\u0000', '=', '-'};
    protected static final char[] ARG_SEPERATORS = new char[]{'\u0000', '='};
    protected static final char[] NULL_SEPERATORS = new char[]{'\u0000'};
    protected static final int INVALID = Integer.MAX_VALUE;
    protected final CLOptionDescriptor[] m_optionDescriptors;
    protected final Vector m_options;
    protected final ParserControl m_control;
    protected String m_errorMessage;
    protected String[] m_unparsedArgs = new String[0];
    protected char ch;
    protected String[] args;
    protected boolean isLong;
    protected int argIndex;
    protected int stringIndex;
    protected int stringLength;
    protected int m_lastChar = Integer.MAX_VALUE;
    protected int m_lastOptionId;
    protected CLOption m_option;
    protected int m_state = 0;

    public String[] getUnparsedArgs() {
        return this.m_unparsedArgs;
    }

    public Vector getArguments() {
        return this.m_options;
    }

    private CLOptionDescriptor getDescriptorFor(int id) {
        int i = 0;
        while (i < this.m_optionDescriptors.length) {
            if (this.m_optionDescriptors[i].getId() == id) {
                return this.m_optionDescriptors[i];
            }
            ++i;
        }
        return null;
    }

    private CLOptionDescriptor getDescriptorFor(String name) {
        int i = 0;
        while (i < this.m_optionDescriptors.length) {
            if (this.m_optionDescriptors[i].getName().equals(name)) {
                return this.m_optionDescriptors[i];
            }
            ++i;
        }
        return null;
    }

    public String getErrorString() {
        return this.m_errorMessage;
    }

    private int getStateFor(CLOptionDescriptor descriptor) {
        int flags = descriptor.getFlags();
        if ((flags & 0x10) == 16) {
            return 1;
        }
        if ((flags & 2) == 2) {
            return 2;
        }
        if ((flags & 4) == 4) {
            return 3;
        }
        return 0;
    }

    protected void checkIncompatabilities(Vector arguments) throws ParseException {
        int size = arguments.size();
        int i = 0;
        while (i < size) {
            CLOption option = (CLOption)arguments.elementAt(i);
            int id = option.getId();
            CLOptionDescriptor descriptor = this.getDescriptorFor(id);
            if (descriptor != null) {
                int[] incompatable = descriptor.getIncompatble();
                this.checkIncompatable(arguments, incompatable, i);
            }
            ++i;
        }
    }

    protected void checkIncompatable(Vector arguments, int[] incompatable, int original) throws ParseException {
        int size = arguments.size();
        int i = 0;
        while (i < size) {
            if (original != i) {
                CLOption option = (CLOption)arguments.elementAt(i);
                int id = option.getId();
                CLOptionDescriptor descriptor = this.getDescriptorFor(id);
                int j = 0;
                while (j < incompatable.length) {
                    if (id == incompatable[j]) {
                        CLOption originalOption = (CLOption)arguments.elementAt(original);
                        int originalId = originalOption.getId();
                        String message = null;
                        message = id == originalId ? "Duplicate options for " + this.describeDualOption(originalId) + " found." : "Incompatable options -" + this.describeDualOption(id) + " and " + this.describeDualOption(originalId) + " found.";
                        throw new ParseException(message, 0);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected String describeDualOption(int id) {
        String longOption;
        CLOptionDescriptor descriptor = this.getDescriptorFor(id);
        if (descriptor == null) {
            return "<parameter>";
        }
        StringBuffer sb = new StringBuffer();
        boolean hasCharOption = false;
        if (Character.isLetter((char)id)) {
            sb.append('-');
            sb.append((char)id);
            hasCharOption = true;
        }
        if ((longOption = descriptor.getName()) != null) {
            if (hasCharOption) {
                sb.append('/');
            }
            sb.append("--");
            sb.append(longOption);
        }
        return sb.toString();
    }

    protected String[] subArray(String[] array, int index, int charIndex) {
        int remaining = array.length - index;
        String[] result = new String[remaining];
        if (remaining > 1) {
            System.arraycopy(array, index + 1, result, 1, remaining - 1);
        }
        result[0] = array[index].substring(charIndex - 1);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parse() throws ParseException {
        if (this.args.length == 0) {
            return;
        }
        this.stringLength = this.args[this.argIndex].length();
        while (true) {
            this.ch = this.peekAtChar();
            if (this.argIndex >= this.args.length) break;
            if (this.m_control != null && this.m_control.isFinished(this.m_lastOptionId)) {
                this.m_unparsedArgs = this.subArray(this.args, this.argIndex, this.stringIndex);
                return;
            }
            if (5 == this.m_state) {
                if (this.ch == '\u0000') {
                    this.getChar();
                    this.m_state = 0;
                    continue;
                }
                this.parseShortOption();
                continue;
            }
            if (this.m_state == 0) {
                this.parseNormal();
                continue;
            }
            if (4 == this.m_state) {
                this.addOption(new CLOption(this.args[this.argIndex++]));
                continue;
            }
            if (3 == this.m_state && '-' == this.ch) {
                this.m_state = 0;
                this.addOption(this.m_option);
                continue;
            }
            this.parseArguments();
        }
        if (this.m_option == null) return;
        if (3 == this.m_state) {
            this.m_options.addElement(this.m_option);
            return;
        } else {
            if (2 == this.m_state) {
                CLOptionDescriptor descriptor = this.getDescriptorFor(this.m_option.getId());
                String message = "Missing argument to option " + this.getOptionDescription(descriptor);
                throw new ParseException(message, 0);
            }
            if (1 != this.m_state) throw new ParseException("IllegalState " + this.m_state + ": " + this.m_option, 0);
            if (1 == this.m_option.getArgumentCount()) {
                this.m_option.addArgument("");
                this.m_options.addElement(this.m_option);
                return;
            } else {
                CLOptionDescriptor descriptor = this.getDescriptorFor(this.m_option.getId());
                String message = "Missing argument to option " + this.getOptionDescription(descriptor);
                throw new ParseException(message, 0);
            }
        }
    }

    protected final String getOptionDescription(CLOptionDescriptor descriptor) {
        if (this.isLong) {
            return "--" + descriptor.getName();
        }
        return "-" + (char)descriptor.getId();
    }

    protected final char peekAtChar() {
        if (Integer.MAX_VALUE == this.m_lastChar) {
            this.m_lastChar = this.readChar();
        }
        return (char)this.m_lastChar;
    }

    protected final char getChar() {
        if (Integer.MAX_VALUE != this.m_lastChar) {
            char result = (char)this.m_lastChar;
            this.m_lastChar = Integer.MAX_VALUE;
            return result;
        }
        return this.readChar();
    }

    private final char readChar() {
        if (this.stringIndex >= this.stringLength) {
            ++this.argIndex;
            this.stringIndex = 0;
            this.stringLength = this.argIndex < this.args.length ? this.args[this.argIndex].length() : 0;
            return '\u0000';
        }
        if (this.argIndex >= this.args.length) {
            return '\u0000';
        }
        return this.args[this.argIndex].charAt(this.stringIndex++);
    }

    protected final Token nextToken(char[] seperators) {
        this.ch = this.getChar();
        if (this.isSeperator(this.ch, seperators)) {
            this.ch = this.getChar();
            CLArgsParser cLArgsParser = this;
            if (cLArgsParser == null) {
                throw null;
            }
            return cLArgsParser.new Token(0, null);
        }
        StringBuffer sb = new StringBuffer();
        do {
            sb.append(this.ch);
            this.ch = this.getChar();
        } while (!this.isSeperator(this.ch, seperators));
        CLArgsParser cLArgsParser = this;
        if (cLArgsParser == null) {
            throw null;
        }
        return cLArgsParser.new Token(1, sb.toString());
    }

    private final boolean isSeperator(char ch, char[] seperators) {
        int i = 0;
        while (i < seperators.length) {
            if (ch == seperators[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void addOption(CLOption option) {
        this.m_options.addElement(option);
        this.m_lastOptionId = option.getId();
        this.m_option = null;
    }

    protected void parseOption(CLOptionDescriptor descriptor, String optionString) throws ParseException {
        if (descriptor == null) {
            throw new ParseException("Unknown option " + optionString, 0);
        }
        this.m_state = this.getStateFor(descriptor);
        this.m_option = new CLOption(descriptor.getId());
        if (this.m_state == 0) {
            this.addOption(this.m_option);
        }
    }

    protected void parseShortOption() throws ParseException {
        this.ch = this.getChar();
        CLOptionDescriptor descriptor = this.getDescriptorFor(this.ch);
        this.isLong = false;
        this.parseOption(descriptor, "-" + this.ch);
        if (this.m_state == 0) {
            this.m_state = 5;
        }
    }

    protected boolean parseArguments() throws ParseException {
        if (2 == this.m_state) {
            if ('=' == this.ch || this.ch == '\u0000') {
                this.getChar();
            }
            Token token = this.nextToken(NULL_SEPERATORS);
            this.m_option.addArgument(token.getValue());
            this.addOption(this.m_option);
            this.m_state = 0;
        } else if (1 == this.m_state) {
            if (this.m_option.getArgumentCount() == 0) {
                Token token = this.nextToken(ARG_SEPERATORS);
                if (token.getType() == 0) {
                    CLOptionDescriptor descriptor = this.getDescriptorFor(this.m_option.getId());
                    String message = "Unable to parse first argument for option " + this.getOptionDescription(descriptor);
                    throw new ParseException(message, 0);
                }
                this.m_option.addArgument(token.getValue());
            } else {
                StringBuffer sb = new StringBuffer();
                this.ch = this.getChar();
                if ('-' == this.ch) {
                    this.m_lastChar = this.ch;
                }
                while (!this.isSeperator(this.ch, ARG2_SEPERATORS)) {
                    sb.append(this.ch);
                    this.ch = this.getChar();
                }
                String argument = sb.toString();
                this.m_option.addArgument(argument);
                this.addOption(this.m_option);
                this.m_option = null;
                this.m_state = 0;
            }
        }
        return true;
    }

    protected void parseNormal() throws ParseException {
        if ('-' != this.ch) {
            String argument = this.nextToken(NULL_SEPERATORS).getValue();
            this.addOption(new CLOption(argument));
            this.m_state = 0;
        } else {
            this.getChar();
            if (this.peekAtChar() == '\u0000') {
                throw new ParseException("Malformed option -", 0);
            }
            this.ch = this.peekAtChar();
            if ('-' != this.ch) {
                this.parseShortOption();
            } else {
                this.getChar();
                if (this.peekAtChar() == '\u0000') {
                    this.getChar();
                    this.m_state = 4;
                } else {
                    String optionName = this.nextToken(ARG_SEPERATORS).getValue();
                    CLOptionDescriptor descriptor = this.getDescriptorFor(optionName);
                    this.isLong = true;
                    this.parseOption(descriptor, "--" + optionName);
                }
            }
        }
    }

    public CLArgsParser(String[] args, CLOptionDescriptor[] optionDescriptors, ParserControl control) {
        this.m_optionDescriptors = optionDescriptors;
        this.m_control = control;
        this.m_options = new Vector();
        this.args = args;
        try {
            this.parse();
            this.checkIncompatabilities(this.m_options);
        }
        catch (ParseException pe) {
            this.m_errorMessage = pe.getMessage();
        }
    }

    public CLArgsParser(String[] args, CLOptionDescriptor[] optionDescriptors) {
        this(args, optionDescriptors, null);
    }

    protected class Token {
        protected final int m_type;
        protected final String m_value;

        public String getValue() {
            return this.m_value;
        }

        public int getType() {
            return this.m_type;
        }

        public String toString() {
            return "" + this.m_type + ":" + this.m_value;
        }

        public Token(int type, String value) {
            this.m_type = type;
            this.m_value = value;
        }
    }
}

