/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.avalon.Configuration;
import org.apache.avalon.ConfigurationException;

public final class Parameters {
    protected HashMap m_parameters = new HashMap();

    public String setParameter(String name, String value) {
        if (name == null) {
            return null;
        }
        if (value == null) {
            return (String)this.m_parameters.remove(name);
        }
        return this.m_parameters.put(name, value);
    }

    public Iterator getParameterNames() {
        return this.m_parameters.keySet().iterator();
    }

    public boolean isParameter(String name) {
        return this.m_parameters.containsKey(name);
    }

    protected String getParameter(String name) {
        if (name == null) {
            return null;
        }
        return (String)this.m_parameters.get(name);
    }

    public String getParameter(String name, String defaultValue) {
        String value = this.getParameter(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public int getParameterAsInteger(String name, int defaultValue) {
        String value = this.getParameter(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            if (value.startsWith("0x")) {
                return Integer.parseInt(value.substring(2), 16);
            }
            if (value.startsWith("0o")) {
                return Integer.parseInt(value.substring(2), 8);
            }
            if (value.startsWith("0b")) {
                return Integer.parseInt(value.substring(2), 2);
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public long getParameterAsLong(String name, long defaultValue) {
        String value = this.getParameter(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            if (value.startsWith("0x")) {
                return Long.parseLong(value.substring(2), 16);
            }
            if (value.startsWith("0o")) {
                return Long.parseLong(value.substring(2), 8);
            }
            if (value.startsWith("0b")) {
                return Long.parseLong(value.substring(2), 2);
            }
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public float getParameterAsFloat(String name, float defaultValue) {
        String value = this.getParameter(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public boolean getParameterAsBoolean(String name, boolean defaultValue) {
        String value = this.getParameter(name);
        if (value == null) {
            return defaultValue;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        return defaultValue;
    }

    public Parameters merge(Parameters other) {
        Iterator names = other.getParameterNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            String value = other.getParameter(name);
            this.setParameter(name, value);
        }
        return this;
    }

    public static Parameters fromConfiguration(Configuration configuration) throws ConfigurationException {
        if (configuration == null) {
            throw new ConfigurationException("You cannot convert to parameters with a null Configuration");
        }
        Iterator parameters = configuration.getChildren("parameter");
        Parameters param = new Parameters();
        while (parameters.hasNext()) {
            Configuration child = (Configuration)parameters.next();
            String name = child.getAttribute("name");
            String value = child.getAttribute("value");
            param.setParameter(name, value);
        }
        return param;
    }
}

