/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.doc.info;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Tag;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.doc.info.InfoSubTask;
import xdoclet.tags.AbstractProgramElementTagsHandler;
import xdoclet.tags.ClassTagsHandler;
import xdoclet.tags.ConstructorTagsHandler;
import xdoclet.tags.MethodTagsHandler;
import xdoclet.tags.PackageTagsHandler;
import xdoclet.template.TemplateException;
import xdoclet.util.DocletUtil;
import xdoclet.util.Translator;

public class InfoTagsHandler
extends XDocletTagSupport {
    public void ifTagCountNotZero(String template, Properties properties) throws XDocletException {
        String level = properties.getProperty("level");
        int tagCount = 0;
        if ("global".equals(level)) {
            tagCount = this.tagCountInAllClassesAndMethods_Impl(this.getProperties());
        } else if ("package".equals(level)) {
            tagCount = this.tagCountInClassesAndMethodsInAPackage_Impl(this.getProperties(), XDocletTagSupport.getCurrentPackage());
        } else if ("classNoMethods".equals(level)) {
            tagCount = this.tagCountInClass_Impl(this.getProperties(), XDocletTagSupport.getCurrentClass(), false);
        } else if ("class".equals(level)) {
            tagCount = this.tagCountInClass_Impl(this.getProperties(), XDocletTagSupport.getCurrentClass(), true);
        } else if ("method".equals(level)) {
            int a = this.tagCountInClass_Impl(this.getProperties(), XDocletTagSupport.getCurrentClass(), true);
            int b = this.tagCountInClass_Impl(this.getProperties(), XDocletTagSupport.getCurrentClass(), false);
            tagCount = a - b;
        } else if ("constructor".equals(level)) {
            int a = this.tagCountInClass_Impl(this.getProperties(), XDocletTagSupport.getCurrentClass(), true);
            int b = this.tagCountInClass_Impl(this.getProperties(), XDocletTagSupport.getCurrentClass(), false);
            tagCount = a - b;
        } else {
            throw new XDocletException(Translator.getString("xdoclet.doc.Messages", "bad_level", new String[]{level}));
        }
        if (tagCount != 0) {
            this.generate(template);
        }
    }

    public String tagCountInAllClassesAndMethods() throws XDocletException {
        return String.valueOf(this.tagCountInAllClassesAndMethods_Impl(this.getProperties()));
    }

    public String tagCountInClassesAndMethodsInAPackage() throws XDocletException {
        return String.valueOf(this.tagCountInClassesAndMethodsInAPackage_Impl(this.getProperties(), XDocletTagSupport.getCurrentPackage()));
    }

    public String tagCountInClass() throws XDocletException {
        return String.valueOf(this.tagCountInClass_Impl(this.getProperties(), XDocletTagSupport.getCurrentClass(), true));
    }

    public String methodTagValue() throws XDocletException {
        return this.getMethodTagsHandler().methodTagValue(this.getProperties());
    }

    public String constructorTagValue() throws XDocletException {
        return this.getConstructorTagsHandler().constructorTagValue(this.getProperties());
    }

    public String classTagValue() throws XDocletException {
        return this.getClassTagsHandler().classTagValue(this.getProperties());
    }

    public void forAllMethodTags(String template) throws XDocletException {
        this.getMethodTagsHandler().forAllMethodTags(template, this.getProperties());
    }

    public void forAllClassTags(String template) throws XDocletException {
        this.getClassTagsHandler().forAllClassTags(template, this.getProperties());
    }

    public void forAllMethods(String template) throws XDocletException {
        this.getMethodTagsHandler().forAllMethods(template, this.getProperties());
    }

    public void forAllClasses(String template) throws XDocletException {
        this.getClassTagsHandler().forAllClasses(template, this.getProperties());
    }

    public void forAllPackages(String template) throws XDocletException {
        this.getPackageTagsHandler().forAllPackages(template, this.getProperties());
    }

    public void ifHasMethodTag(String template) throws XDocletException {
        this.getMethodTagsHandler().ifHasMethodTag(template, this.getProperties());
    }

    public String projectname() throws XDocletException {
        InfoSubTask infoSubTask = (InfoSubTask)XDocletTagSupport.getDocletContext().getActiveSubTask();
        return infoSubTask.getProjectname();
    }

    public String stylesheetlink() throws XDocletException {
        String packageName = "";
        if (this.getPackageTagsHandler().packageName() != null) {
            packageName = this.getPackageTagsHandler().packageName();
        }
        StringTokenizer st = new StringTokenizer(packageName, ".");
        int n = st.countTokens();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < n) {
            sb.append("../");
            ++i;
        }
        sb.append("info.css");
        return sb.toString();
    }

    private Properties getProperties() {
        Properties properties = ((InfoSubTask)XDocletTagSupport.getDocletContext().getActiveSubTask()).getProperties();
        return properties;
    }

    private MethodTagsHandler getMethodTagsHandler() throws XDocletException {
        try {
            return (MethodTagsHandler)this.getEngine().getTagHandlerFor("Method");
        }
        catch (TemplateException ex) {
            throw new XDocletException(ex, Translator.getString("xdoclet.doc.Messages", "tagshandler_not_found", new String[]{"MethodTagsHandler", "Method"}));
        }
    }

    private ConstructorTagsHandler getConstructorTagsHandler() throws XDocletException {
        try {
            return (ConstructorTagsHandler)this.getEngine().getTagHandlerFor("Constructor");
        }
        catch (TemplateException ex) {
            throw new XDocletException(ex, Translator.getString("xdoclet.doc.Messages", "tagshandler_not_found", new String[]{"ConstructorTagsHandler", "Constructor"}));
        }
    }

    private ClassTagsHandler getClassTagsHandler() throws XDocletException {
        try {
            return (ClassTagsHandler)this.getEngine().getTagHandlerFor("Class");
        }
        catch (TemplateException ex) {
            throw new XDocletException(ex, Translator.getString("xdoclet.doc.Messages", "tagshandler_not_found", new String[]{"ClassTagsHandler", "Class"}));
        }
    }

    private PackageTagsHandler getPackageTagsHandler() throws XDocletException {
        try {
            return (PackageTagsHandler)this.getEngine().getTagHandlerFor("Package");
        }
        catch (TemplateException ex) {
            throw new XDocletException(ex, Translator.getString("xdoclet.doc.Messages", "tagshandler_not_found", new String[]{"PackageTagsHandler", "Package"}));
        }
    }

    private int tagCountInAllClassesAndMethods_Impl(Properties attributes) throws XDocletException {
        int tagCount = 0;
        String tag_name = attributes.getProperty("tagName");
        ClassDoc[] classes = AbstractProgramElementTagsHandler.getAllClasses();
        TreeSet<PackageDoc> packages = new TreeSet<PackageDoc>();
        int i = 0;
        while (i < classes.length) {
            packages.add(classes[i].containingPackage());
            ++i;
        }
        PackageDoc cur_package = null;
        Iterator packageIterator = packages.iterator();
        while (packageIterator.hasNext()) {
            cur_package = (PackageDoc)packageIterator.next();
            tagCount += this.tagCountInClassesAndMethodsInAPackage_Impl(attributes, cur_package);
        }
        return tagCount;
    }

    private int tagCountInClassesAndMethodsInAPackage_Impl(Properties attributes, PackageDoc packageDoc) throws XDocletException {
        int tagCount = 0;
        String tag_name = attributes.getProperty("tagName");
        ClassDoc[] classes = packageDoc.allClasses();
        int i = 0;
        while (i < classes.length) {
            tagCount += this.tagCountInClass_Impl(attributes, classes[i], true);
            ++i;
        }
        return tagCount;
    }

    private int tagCountInClass_Impl(Properties attributes, ClassDoc classDoc, boolean countMethods) throws XDocletException {
        int tagCount = 0;
        String tag_name = attributes.getProperty("tagName");
        Tag[] classTags = DocletUtil.getTagsByName(classDoc, tag_name, false);
        if (classTags != null) {
            tagCount += classTags.length;
        }
        if (countMethods) {
            MethodDoc[] methods = classDoc.methods();
            int i = 0;
            while (i < methods.length) {
                Tag[] methodTags = DocletUtil.getTagsByName((MemberDoc)methods[i], tag_name);
                if (methodTags != null) {
                    tagCount += methodTags.length;
                }
                ++i;
            }
        }
        return tagCount;
    }
}

