/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public final class IOUtil {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void shutdownStream(OutputStream output) {
        if (output == null) {
            return;
        }
        try {
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void shutdownStream(InputStream input) {
        if (input == null) {
            return;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        IOUtil.copy(input, output, 4096);
    }

    public static void copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
    }

    public static void copy(Reader input, Writer output) throws IOException {
        IOUtil.copy(input, output, 4096);
    }

    public static void copy(Reader input, Writer output, int bufferSize) throws IOException {
        char[] buffer = new char[bufferSize];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
    }

    public static void copy(InputStream input, Writer output) throws IOException {
        IOUtil.copy(input, output, 4096);
    }

    public static void copy(InputStream input, Writer output, int bufferSize) throws IOException {
        InputStreamReader in = new InputStreamReader(input);
        IOUtil.copy((Reader)in, output, bufferSize);
    }

    public static void copy(InputStream input, Writer output, String encoding) throws IOException {
        InputStreamReader in = new InputStreamReader(input, encoding);
        IOUtil.copy((Reader)in, output);
    }

    public static void copy(InputStream input, Writer output, String encoding, int bufferSize) throws IOException {
        InputStreamReader in = new InputStreamReader(input, encoding);
        IOUtil.copy((Reader)in, output, bufferSize);
    }

    public static String toString(InputStream input) throws IOException {
        return IOUtil.toString(input, 4096);
    }

    public static String toString(InputStream input, int bufferSize) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtil.copy(input, (Writer)sw, bufferSize);
        return sw.toString();
    }

    public static String toString(InputStream input, String encoding) throws IOException {
        return IOUtil.toString(input, encoding, 4096);
    }

    public static String toString(InputStream input, String encoding, int bufferSize) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtil.copy(input, sw, encoding, bufferSize);
        return sw.toString();
    }

    public static void copy(String input, OutputStream output) throws IOException {
        IOUtil.copy(input, output, 4096);
    }

    public static void copy(String input, OutputStream output, int bufferSize) throws IOException {
        StringReader in = new StringReader(input);
        OutputStreamWriter out = new OutputStreamWriter(output);
        IOUtil.copy((Reader)in, (Writer)out, bufferSize);
        out.flush();
    }

    public static void copy(Reader input, OutputStream output) throws IOException {
        IOUtil.copy(input, output, 4096);
    }

    public static void copy(Reader input, OutputStream output, int bufferSize) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(output);
        IOUtil.copy(input, (Writer)out, bufferSize);
        out.flush();
    }

    public static String toString(Reader input) throws IOException {
        return IOUtil.toString(input, 4096);
    }

    public static String toString(Reader input, int bufferSize) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtil.copy(input, (Writer)sw, bufferSize);
        return sw.toString();
    }

    public static void copy(String input, Writer output) throws IOException {
        output.write(input);
    }

    public static void bufferedCopy(InputStream input, OutputStream output) throws IOException {
        BufferedInputStream in = new BufferedInputStream(input);
        BufferedOutputStream out = new BufferedOutputStream(output);
        IOUtil.copy((InputStream)in, (OutputStream)out);
        out.flush();
    }

    private IOUtil() {
    }
}

