/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component;

import org.apache.avalon.excalibur.component.RoleManageable;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.avalon.framework.thread.ThreadSafe;

public class DefaultComponentFactory
extends AbstractLoggable
implements ObjectFactory,
ThreadSafe {
    private Class m_componentClass;
    private Context m_context;
    private ComponentManager m_componentManager;
    private Configuration m_configuration;
    private RoleManager m_roles;

    public Object newInstance() throws Exception {
        Object component = this.m_componentClass.newInstance();
        this.getLogger().debug("ComponentFactory creating new instance of " + this.m_componentClass.getName() + ".");
        if (component instanceof Loggable) {
            ((Loggable)component).setLogger(this.getLogger());
        }
        if (component instanceof Contextualizable) {
            ((Contextualizable)component).contextualize(this.m_context);
        }
        if (component instanceof Composable) {
            ((Composable)component).compose(this.m_componentManager);
        }
        if (component instanceof RoleManageable) {
            ((RoleManageable)component).setRoleManager(this.m_roles);
        }
        if (component instanceof Configurable) {
            ((Configurable)component).configure(this.m_configuration);
        }
        if (component instanceof Initializable) {
            ((Initializable)component).initialize();
        }
        if (component instanceof Startable) {
            ((Startable)component).start();
        }
        return component;
    }

    public final Class getCreatedClass() {
        return this.m_componentClass;
    }

    public final void decommission(Object component) throws Exception {
        this.getLogger().debug("ComponentFactory decommissioning instance of " + this.m_componentClass.getName() + ".");
        if (component instanceof Startable) {
            ((Startable)component).stop();
        }
        if (component instanceof Disposable) {
            ((Disposable)component).dispose();
        }
    }

    public DefaultComponentFactory(Class componentClass, Configuration configuration, ComponentManager componentManager, Context context, RoleManager roles) {
        this.m_componentClass = componentClass;
        this.m_configuration = configuration;
        this.m_componentManager = componentManager;
        this.m_context = context;
        this.m_roles = roles;
    }
}

