/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipException;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipLong;
import org.apache.tools.zip.ZipShort;

public class ZipOutputStream
extends DeflaterOutputStream {
    private ZipEntry entry;
    private String comment = "";
    private int level = -1;
    private int method = 8;
    private Vector entries = new Vector();
    private CRC32 crc = new CRC32();
    private long written = 0L;
    private long dataStart = 0L;
    private ZipLong cdOffset = new ZipLong(0L);
    private ZipLong cdLength = new ZipLong(0L);
    private static final byte[] ZERO = new byte[]{0, 0};
    private static final byte[] LZERO = new byte[]{0, 0, 0, 0};
    private Hashtable offsets = new Hashtable();
    public static final int DEFLATED = 8;
    public static final int STORED = 0;
    protected static final ZipLong LFH_SIG = new ZipLong(67324752L);
    protected static final ZipLong DD_SIG = new ZipLong(134695760L);
    protected static final ZipLong CFH_SIG = new ZipLong(33639248L);
    protected static final ZipLong EOCD_SIG = new ZipLong(101010256L);
    private static final ZipLong DOS_TIME_MIN = new ZipLong(8448L);

    public ZipOutputStream(OutputStream outputStream) {
        super(outputStream, new Deflater(-1, true));
    }

    public void finish() throws IOException {
        this.closeEntry();
        this.cdOffset = new ZipLong(this.written);
        int n = 0;
        while (n < this.entries.size()) {
            this.writeCentralFileHeader((ZipEntry)this.entries.elementAt(n));
            ++n;
        }
        this.cdLength = new ZipLong(this.written - this.cdOffset.getValue());
        this.writeCentralDirectoryEnd();
        this.offsets.clear();
        this.entries.removeAllElements();
    }

    public void closeEntry() throws IOException {
        if (this.entry == null) {
            return;
        }
        long l = this.crc.getValue();
        this.crc.reset();
        if (this.entry.getMethod() == 8) {
            this.def.finish();
            while (!this.def.finished()) {
                this.deflate();
            }
            this.entry.setSize(this.def.getTotalIn());
            this.entry.setComprSize(this.def.getTotalOut());
            this.entry.setCrc(l);
            this.def.reset();
            this.written += this.entry.getCompressedSize();
        } else {
            if (this.entry.getCrc() != l) {
                throw new ZipException("bad CRC checksum for entry " + this.entry.getName() + ": " + Long.toHexString(this.entry.getCrc()) + " instead of " + Long.toHexString(l));
            }
            if (this.entry.getSize() != this.written - this.dataStart) {
                throw new ZipException("bad size for entry " + this.entry.getName() + ": " + this.entry.getSize() + " instead of " + (this.written - this.dataStart));
            }
        }
        this.writeDataDescriptor(this.entry);
        this.entry = null;
    }

    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        this.closeEntry();
        this.entry = zipEntry;
        this.entries.addElement(this.entry);
        if (this.entry.getMethod() == -1) {
            this.entry.setMethod(this.method);
        }
        if (this.entry.getTime() == -1L) {
            this.entry.setTime(System.currentTimeMillis());
        }
        if (this.entry.getMethod() == 0) {
            if (this.entry.getSize() == -1L) {
                throw new ZipException("uncompressed size is required for STORED method");
            }
            if (this.entry.getCrc() == -1L) {
                throw new ZipException("crc checksum is required for STORED method");
            }
            this.entry.setComprSize(this.entry.getSize());
        } else {
            this.def.setLevel(this.level);
        }
        this.writeLocalFileHeader(this.entry);
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public void setMethod(int n) {
        this.method = n;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.entry.getMethod() == 8) {
            super.write(byArray, n, n2);
        } else {
            this.out.write(byArray, n, n2);
            this.written += (long)n2;
        }
        this.crc.update(byArray, n, n2);
    }

    protected void writeLocalFileHeader(ZipEntry zipEntry) throws IOException {
        this.offsets.put(zipEntry, new ZipLong(this.written));
        this.out.write(LFH_SIG.getBytes());
        this.written += 4L;
        if (zipEntry.getMethod() == 8) {
            this.out.write(new ZipShort(20).getBytes());
            this.out.write(new ZipShort(8).getBytes());
        } else {
            this.out.write(new ZipShort(10).getBytes());
            this.out.write(ZERO);
        }
        this.written += 4L;
        this.out.write(new ZipShort(zipEntry.getMethod()).getBytes());
        this.written += 2L;
        this.out.write(ZipOutputStream.toDosTime(new Date(zipEntry.getTime())).getBytes());
        this.written += 4L;
        if (zipEntry.getMethod() == 8) {
            this.out.write(LZERO);
            this.out.write(LZERO);
            this.out.write(LZERO);
        } else {
            this.out.write(new ZipLong(zipEntry.getCrc()).getBytes());
            this.out.write(new ZipLong(zipEntry.getSize()).getBytes());
            this.out.write(new ZipLong(zipEntry.getSize()).getBytes());
        }
        this.written += 12L;
        byte[] byArray = zipEntry.getName().getBytes();
        this.out.write(new ZipShort(byArray.length).getBytes());
        this.written += 2L;
        byte[] byArray2 = zipEntry.getLocalFileDataExtra();
        this.out.write(new ZipShort(byArray2.length).getBytes());
        this.written += 2L;
        this.out.write(byArray);
        this.written += (long)byArray.length;
        this.out.write(byArray2);
        this.written += (long)byArray2.length;
        this.dataStart = this.written;
    }

    protected void writeDataDescriptor(ZipEntry zipEntry) throws IOException {
        if (zipEntry.getMethod() != 8) {
            return;
        }
        this.out.write(DD_SIG.getBytes());
        this.out.write(new ZipLong(this.entry.getCrc()).getBytes());
        this.out.write(new ZipLong(this.entry.getCompressedSize()).getBytes());
        this.out.write(new ZipLong(this.entry.getSize()).getBytes());
        this.written += 16L;
    }

    protected void writeCentralFileHeader(ZipEntry zipEntry) throws IOException {
        this.out.write(CFH_SIG.getBytes());
        this.written += 4L;
        this.out.write(new ZipShort(20).getBytes());
        this.written += 2L;
        if (zipEntry.getMethod() == 8) {
            this.out.write(new ZipShort(20).getBytes());
            this.out.write(new ZipShort(8).getBytes());
        } else {
            this.out.write(new ZipShort(10).getBytes());
            this.out.write(ZERO);
        }
        this.written += 4L;
        this.out.write(new ZipShort(zipEntry.getMethod()).getBytes());
        this.written += 2L;
        this.out.write(ZipOutputStream.toDosTime(new Date(zipEntry.getTime())).getBytes());
        this.written += 4L;
        this.out.write(new ZipLong(zipEntry.getCrc()).getBytes());
        this.out.write(new ZipLong(zipEntry.getCompressedSize()).getBytes());
        this.out.write(new ZipLong(zipEntry.getSize()).getBytes());
        this.written += 12L;
        byte[] byArray = zipEntry.getName().getBytes();
        this.out.write(new ZipShort(byArray.length).getBytes());
        this.written += 2L;
        byte[] byArray2 = zipEntry.getCentralDirectoryExtra();
        this.out.write(new ZipShort(byArray2.length).getBytes());
        this.written += 2L;
        String string = zipEntry.getComment();
        if (string == null) {
            string = "";
        }
        byte[] byArray3 = string.getBytes();
        this.out.write(new ZipShort(byArray3.length).getBytes());
        this.written += 2L;
        this.out.write(ZERO);
        this.written += 2L;
        this.out.write(new ZipShort(zipEntry.getInternalAttributes()).getBytes());
        this.written += 2L;
        this.out.write(new ZipLong(zipEntry.getExternalAttributes()).getBytes());
        this.written += 4L;
        this.out.write(((ZipLong)this.offsets.get(zipEntry)).getBytes());
        this.written += 4L;
        this.out.write(byArray);
        this.written += (long)byArray.length;
        this.out.write(byArray2);
        this.written += (long)byArray2.length;
        this.out.write(byArray3);
        this.written += (long)byArray3.length;
    }

    protected void writeCentralDirectoryEnd() throws IOException {
        this.out.write(EOCD_SIG.getBytes());
        this.out.write(ZERO);
        this.out.write(ZERO);
        byte[] byArray = new ZipShort(this.entries.size()).getBytes();
        this.out.write(byArray);
        this.out.write(byArray);
        this.out.write(this.cdLength.getBytes());
        this.out.write(this.cdOffset.getBytes());
        byte[] byArray2 = this.comment.getBytes();
        this.out.write(new ZipShort(byArray2.length).getBytes());
        this.out.write(byArray2);
    }

    protected static ZipLong toDosTime(Date date) {
        int n = date.getYear() + 1900;
        int n2 = date.getMonth() + 1;
        if (n < 1980) {
            return DOS_TIME_MIN;
        }
        long l = n - 1980 << 25 | n2 << 21 | date.getDate() << 16 | date.getHours() << 11 | date.getMinutes() << 5 | date.getSeconds() >> 1;
        byte[] byArray = new byte[]{(byte)(l & 0xFFL), (byte)((l & 0xFF00L) >> 8), (byte)((l & 0xFF0000L) >> 16), (byte)((l & 0xFF000000L) >> 24)};
        return new ZipLong(byArray);
    }
}

