/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.avalon.framework.configuration.AbstractConfiguration;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class DefaultConfiguration
extends AbstractConfiguration {
    protected static final Configuration[] EMPTY_ARRAY = new Configuration[0];
    protected final String m_name;
    protected final String m_location;
    protected HashMap m_attributes;
    protected ArrayList m_children;
    protected String m_value;

    public String getName() {
        return this.m_name;
    }

    public String getLocation() {
        return this.m_location;
    }

    public String getValue() throws ConfigurationException {
        if (this.m_value != null) {
            return this.m_value;
        }
        throw new ConfigurationException("No value is associated with the configuration element \"" + this.getName() + "\"");
    }

    public String[] getAttributeNames() {
        if (this.m_attributes == null) {
            return new String[0];
        }
        return this.m_attributes.keySet().toArray(new String[0]);
    }

    public Configuration[] getChildren() {
        if (this.m_children == null) {
            return new Configuration[0];
        }
        return this.m_children.toArray(new Configuration[0]);
    }

    public String getAttribute(String name) throws ConfigurationException {
        String value;
        String string = value = this.m_attributes != null ? (String)this.m_attributes.get(name) : null;
        if (value != null) {
            return value;
        }
        throw new ConfigurationException("No attribute named \"" + name + "\" is " + "associated with the configuration element \"" + this.getName() + "\"");
    }

    public Configuration getChild(String name, boolean createNew) {
        if (this.m_children != null) {
            int size = this.m_children.size();
            int i = 0;
            while (i < size) {
                Configuration configuration = (Configuration)this.m_children.get(i);
                if (name.equals(configuration.getName())) {
                    return configuration;
                }
                ++i;
            }
        }
        if (createNew) {
            return new DefaultConfiguration(name, "-");
        }
        return null;
    }

    public Configuration[] getChildren(String name) {
        if (this.m_children == null) {
            return new Configuration[0];
        }
        ArrayList<Configuration> children = new ArrayList<Configuration>();
        int size = this.m_children.size();
        int i = 0;
        while (i < size) {
            Configuration configuration = (Configuration)this.m_children.get(i);
            if (name.equals(configuration.getName())) {
                children.add(configuration);
            }
            ++i;
        }
        return children.toArray(new Configuration[0]);
    }

    public void appendValueData(String value) {
        this.m_value = this.m_value == null ? value : this.m_value + value;
    }

    public void setValue(String value) {
        this.m_value = value;
    }

    public void setAttribute(String name, String value) {
        if (this.m_attributes == null) {
            this.m_attributes = new HashMap();
        }
        this.m_attributes.put(name, value);
    }

    public String addAttribute(String name, String value) {
        if (this.m_attributes == null) {
            this.m_attributes = new HashMap();
        }
        return this.m_attributes.put(name, value);
    }

    public void addChild(Configuration configuration) {
        if (this.m_children == null) {
            this.m_children = new ArrayList();
        }
        this.m_children.add(configuration);
    }

    public void removeChild(Configuration configuration) {
        if (this.m_children == null) {
            return;
        }
        ((AbstractCollection)this.m_children).remove(configuration);
    }

    public int getChildCount() {
        if (this.m_children == null) {
            return 0;
        }
        return this.m_children.size();
    }

    public DefaultConfiguration(String name, String location) {
        this.m_name = name;
        this.m_location = location;
    }
}

