/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.avalon.framework.CascadingThrowable;

public final class ExceptionUtil {
    public static String printStackTrace(Throwable throwable) {
        return ExceptionUtil.printStackTrace(throwable, 0, true);
    }

    public static String printStackTrace(Throwable throwable, boolean printCascading) {
        return ExceptionUtil.printStackTrace(throwable, 0, printCascading);
    }

    public static String printStackTrace(Throwable throwable, int depth) {
        String[] lines = ExceptionUtil.captureStackTrace(throwable);
        if (depth == 0 || depth > lines.length) {
            depth = lines.length;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < depth) {
            sb.append(lines[i]);
            sb.append('\n');
            ++i;
        }
        return sb.toString();
    }

    public static String printStackTrace(Throwable throwable, int depth, boolean printCascading) {
        String result = ExceptionUtil.printStackTrace(throwable, depth);
        if (!printCascading || !(throwable instanceof CascadingThrowable)) {
            return result;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(result);
        throwable = ((CascadingThrowable)((Object)throwable)).getCause();
        while (throwable != null) {
            sb.append("rethrown from\n");
            sb.append(ExceptionUtil.printStackTrace(throwable, depth));
            throwable = throwable instanceof CascadingThrowable ? ((CascadingThrowable)((Object)throwable)).getCause() : null;
        }
        return sb.toString();
    }

    public static String[] captureStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)sw, true));
        return ExceptionUtil.splitString(sw.toString(), "\n");
    }

    public static String[] splitString(String string, String onToken) {
        StringTokenizer tokenizer = new StringTokenizer(string, onToken);
        ArrayList<String> lines = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            lines.add(tokenizer.nextToken());
        }
        return lines.toArray(new String[0]);
    }

    private ExceptionUtil() {
    }
}

