/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.pool;

import org.apache.avalon.excalibur.pool.DefaultPool;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.PoolController;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.excalibur.pool.Resizable;

public class SoftResourceLimitingPool
extends DefaultPool
implements Resizable {
    public SoftResourceLimitingPool(ObjectFactory objectFactory) throws Exception {
        this(objectFactory, 4);
    }

    public SoftResourceLimitingPool(ObjectFactory objectFactory, int n) throws Exception {
        this(objectFactory, null, n, n * 2);
    }

    public SoftResourceLimitingPool(ObjectFactory objectFactory, int n, int n2) throws Exception {
        this(objectFactory, null, n, n2);
    }

    public SoftResourceLimitingPool(ObjectFactory objectFactory, PoolController poolController, int n, int n2) throws Exception {
        super(objectFactory, poolController, n, n2);
    }

    public void initialize() throws Exception {
        this.grow(this.m_min);
        this.m_initialized = true;
    }

    public void grow(int n) {
        try {
            try {
                this.m_mutex.lock();
                int n2 = 0;
                while (n2 < n) {
                    block7: {
                        try {
                            this.m_ready.add(this.newPoolable());
                        }
                        catch (Exception exception) {
                            if (null == this.getLogger()) break block7;
                            this.getLogger().debug(this.m_factory.getCreatedClass().getName() + ": could not be instantiated.", (Throwable)exception);
                        }
                    }
                    ++n2;
                }
            }
            catch (InterruptedException interruptedException) {
                this.getLogger().warn("Interrupted while waiting on lock", (Throwable)interruptedException);
                Object var5_6 = null;
                this.m_mutex.unlock();
            }
            Object var5_5 = null;
            this.m_mutex.unlock();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.m_mutex.unlock();
            throw throwable;
        }
    }

    public void shrink(int n) {
        try {
            try {
                this.m_mutex.lock();
                int n2 = 0;
                while (n2 < n) {
                    block8: {
                        if (this.m_ready.size() > this.m_min) {
                            try {
                                this.removePoolable((Poolable)this.m_ready.remove(0));
                            }
                            catch (Exception exception) {
                                if (null == this.getLogger()) break block8;
                                this.getLogger().debug(this.m_factory.getCreatedClass().getName() + ": improperly decommissioned.", (Throwable)exception);
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (InterruptedException interruptedException) {
                this.getLogger().warn("Interrupted while waiting on lock", (Throwable)interruptedException);
                Object var5_6 = null;
                this.m_mutex.unlock();
            }
            Object var5_5 = null;
            this.m_mutex.unlock();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.m_mutex.unlock();
            throw throwable;
        }
    }
}

