/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.excalibur.datasource.JdbcConnectionFactory;
import org.apache.avalon.excalibur.datasource.JdbcConnectionPool;
import org.apache.avalon.excalibur.pool.DefaultPoolController;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLoggable;

public class JdbcDataSource
extends AbstractLoggable
implements DataSourceComponent {
    protected JdbcConnectionPool m_pool;

    public void configure(Configuration configuration) throws ConfigurationException {
        if (null == this.m_pool) {
            int n;
            int n2;
            String string = configuration.getChild("dburl").getValue();
            String string2 = configuration.getChild("user").getValue(null);
            String string3 = configuration.getChild("password").getValue(null);
            Configuration configuration2 = configuration.getChild("pool-controller");
            int n3 = configuration2.getAttributeAsInteger("min", 1);
            int n4 = configuration2.getAttributeAsInteger("max", 3);
            boolean bl = configuration.getChild("auto-commit").getValueAsBoolean(true);
            boolean bl2 = configuration2.getAttributeAsBoolean("oradb", false);
            if (n3 < 1) {
                this.getLogger().warn("Minumum number of connections specified must be at least 1 and must be greater than the minumum number of connections");
                n2 = 1;
            } else {
                n2 = n3;
            }
            if (n4 < 1) {
                this.getLogger().warn("Maximum number of connections specified must be at least 1 and must be greater than the minumum number of connections");
                n = 1;
            } else if (n4 < n3) {
                this.getLogger().warn("Maximum number of connections specified must be more than the minimum number of connections");
                n = n3 + 1;
            } else {
                n = n4;
            }
            JdbcConnectionFactory jdbcConnectionFactory = new JdbcConnectionFactory(string, string2, string3, bl, bl2);
            DefaultPoolController defaultPoolController = new DefaultPoolController(n / 4);
            jdbcConnectionFactory.setLogger(this.getLogger());
            try {
                this.m_pool = new JdbcConnectionPool(jdbcConnectionFactory, defaultPoolController, n2, n, bl);
                this.m_pool.setLogger(this.getLogger());
                this.m_pool.initialize();
            }
            catch (Exception exception) {
                this.getLogger().debug("Error on configuration", (Throwable)exception);
                throw new ConfigurationException("Error on configuration", (Throwable)exception);
            }
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            return (Connection)((Object)this.m_pool.get());
        }
        catch (Exception exception) {
            this.getLogger().error("Could not return Connection", (Throwable)exception);
            throw new SQLException(exception.getMessage());
        }
    }

    public void dispose() throws Exception {
        this.m_pool.dispose();
        this.m_pool = null;
    }
}

