/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource;

import org.apache.avalon.excalibur.datasource.JdbcConnection;
import org.apache.avalon.excalibur.datasource.JdbcConnectionFactory;
import org.apache.avalon.excalibur.pool.DefaultPoolController;
import org.apache.avalon.excalibur.pool.HardResourceLimitingPool;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;

public class JdbcConnectionPool
extends HardResourceLimitingPool
implements Runnable,
Disposable,
Initializable {
    private Thread m_initThread;
    private final boolean m_autoCommit;
    private final int m_min;

    public JdbcConnectionPool(JdbcConnectionFactory jdbcConnectionFactory, DefaultPoolController defaultPoolController, int n, int n2, boolean bl) throws Exception {
        super((ObjectFactory)jdbcConnectionFactory, defaultPoolController, n2);
        this.m_min = n;
        this.m_autoCommit = bl;
    }

    public void initialize() {
        this.m_initThread = new Thread(this);
        this.m_initThread.start();
    }

    protected final Poolable newPoolable() throws Exception {
        JdbcConnection jdbcConnection = (JdbcConnection)super.newPoolable();
        jdbcConnection.setPool(this);
        return jdbcConnection;
    }

    private void recycle(Recyclable recyclable) {
        this.getLogger().debug("JdbcConnection object recycled");
        recyclable.recycle();
    }

    public Poolable get() throws Exception {
        JdbcConnection jdbcConnection;
        if (!this.m_initialized) {
            if (this.m_initThread == null) {
                throw new IllegalStateException("You cannot get a Connection before the pool is initialized");
            }
            this.m_initThread.join();
        }
        if ((jdbcConnection = (JdbcConnection)super.get()).isClosed()) {
            this.getLogger().debug("JdbcConnection was closed, creating one to take its place");
            try {
                try {
                    this.m_mutex.lock();
                    if (this.m_active.contains(jdbcConnection)) {
                        this.m_active.remove(jdbcConnection);
                    }
                    this.m_factory.decommission(jdbcConnection);
                    jdbcConnection = (JdbcConnection)this.newPoolable();
                    this.m_active.add(jdbcConnection);
                }
                catch (Exception exception) {
                    this.getLogger().warn("Could not get an open connection", (Throwable)exception);
                    throw exception;
                }
                Object var4_2 = null;
                this.m_mutex.unlock();
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                this.m_mutex.unlock();
                throw throwable;
            }
        }
        if (jdbcConnection.getAutoCommit() != this.m_autoCommit) {
            jdbcConnection.setAutoCommit(this.m_autoCommit);
        }
        return jdbcConnection;
    }

    public void run() {
        try {
            this.grow(this.m_min);
            if (this.size() > 0) {
                this.m_initialized = true;
            }
        }
        catch (Exception exception) {
            this.getLogger().debug("JdbcConnectionPool.run()", (Throwable)exception);
        }
    }
}

