/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLoggable;

public class DefaultRoleManager
extends AbstractLoggable
implements RoleManager,
Configurable {
    private Map m_shorthands;
    private Map m_classNames;
    private Map m_hintClassNames;
    private final RoleManager m_parent;

    public DefaultRoleManager() {
        this.m_parent = null;
    }

    public DefaultRoleManager(RoleManager roleManager) {
        this.m_parent = roleManager;
    }

    public final String getRoleForName(String string) {
        String string2 = (String)this.m_shorthands.get(string);
        if (string2 == null && this.m_parent != null) {
            return this.m_parent.getRoleForName(string);
        }
        this.getLogger().debug("looking up shorthand " + string + ", returning " + string2);
        return string2;
    }

    public final String getDefaultClassNameForRole(String string) {
        String string2 = (String)this.m_classNames.get(string);
        if (string2 == null && this.m_parent != null) {
            return this.m_parent.getDefaultClassNameForRole(string);
        }
        return string2;
    }

    public final String getDefaultClassNameForHint(String string, String string2) {
        this.getLogger().debug("looking up hintmap for role " + string);
        Map map = (Map)this.m_hintClassNames.get(string);
        if (null == map) {
            if (this.m_parent != null) {
                return this.m_parent.getDefaultClassNameForHint(string, string2);
            }
            return "";
        }
        this.getLogger().debug("looking up classname for hint " + string2);
        return (String)map.get(string2);
    }

    public final void configure(Configuration configuration) throws ConfigurationException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        HashMap hashMap3 = new HashMap();
        Configuration[] configurationArray = configuration.getChildren("role");
        int n = 0;
        while (n < configurationArray.length) {
            Configuration[] configurationArray2;
            String string = configurationArray[n].getAttribute("name");
            String string2 = configurationArray[n].getAttribute("shorthand");
            String string3 = configurationArray[n].getAttribute("default-class", null);
            hashMap.put(string2, string);
            if (null != string3) {
                hashMap2.put(string, string3);
            }
            if ((configurationArray2 = configurationArray[n].getChildren("hint")).length > 0) {
                HashMap<String, String> hashMap4 = new HashMap<String, String>();
                int n2 = 0;
                while (n2 < configurationArray2.length) {
                    String string4 = configurationArray2[n2].getAttribute("shorthand").trim();
                    String string5 = configurationArray2[n2].getAttribute("class").trim();
                    hashMap4.put(string4, string5);
                    this.getLogger().debug("Adding hint type " + string4 + " associated with role " + string + " and class " + string5);
                    ++n2;
                }
                hashMap3.put(string, Collections.unmodifiableMap(hashMap4));
            }
            this.getLogger().debug("added Role " + string + " with shorthand " + string2 + " for " + string3);
            ++n;
        }
        this.m_shorthands = Collections.unmodifiableMap(hashMap);
        this.m_classNames = Collections.unmodifiableMap(hashMap2);
        this.m_hintClassNames = Collections.unmodifiableMap(hashMap3);
    }
}

