/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.collections;

import java.util.NoSuchElementException;
import org.apache.avalon.excalibur.collections.PriorityQueue;

public final class BinaryHeap
implements PriorityQueue {
    protected static final int DEFAULT_CAPACITY = 13;
    protected int m_size;
    protected Comparable[] m_elements;
    protected boolean m_isMinHeap;

    public BinaryHeap() {
        this(13, true);
    }

    public BinaryHeap(int n) {
        this(n, true);
    }

    public BinaryHeap(boolean bl) {
        this(13, bl);
    }

    public BinaryHeap(int n, boolean bl) {
        this.m_isMinHeap = bl;
        this.m_elements = new Comparable[n + 1];
    }

    public void clear() {
        this.m_size = 0;
    }

    public boolean isEmpty() {
        return 0 == this.m_size;
    }

    public boolean isFull() {
        return this.m_elements.length == this.m_size + 1;
    }

    public void insert(Comparable comparable) {
        if (this.isFull()) {
            this.grow();
        }
        if (this.m_isMinHeap) {
            this.percolateUpMinHeap(comparable);
        } else {
            this.percolateUpMaxHeap(comparable);
        }
    }

    public Comparable peek() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.m_elements[1];
    }

    public Comparable pop() throws NoSuchElementException {
        Comparable comparable = this.peek();
        this.m_elements[1] = this.m_elements[this.m_size--];
        this.m_elements[this.m_size + 1] = null;
        if (this.m_size != 0) {
            if (this.m_isMinHeap) {
                this.percolateDownMinHeap(1);
            } else {
                this.percolateDownMaxHeap(1);
            }
        }
        return comparable;
    }

    protected void percolateDownMinHeap(int n) {
        Comparable comparable = this.m_elements[n];
        int n2 = n;
        while (n2 * 2 <= this.m_size) {
            int n3 = n2 * 2;
            if (n3 != this.m_size && this.m_elements[n3 + 1].compareTo(this.m_elements[n3]) < 0) {
                ++n3;
            }
            if (this.m_elements[n3].compareTo(comparable) >= 0) break;
            this.m_elements[n2] = this.m_elements[n3];
            n2 = n3;
        }
        this.m_elements[n2] = comparable;
    }

    protected void percolateDownMaxHeap(int n) {
        Comparable comparable = this.m_elements[n];
        int n2 = n;
        while (n2 * 2 <= this.m_size) {
            int n3 = n2 * 2;
            if (n3 != this.m_size && this.m_elements[n3 + 1].compareTo(this.m_elements[n3]) > 0) {
                ++n3;
            }
            if (this.m_elements[n3].compareTo(comparable) <= 0) break;
            this.m_elements[n2] = this.m_elements[n3];
            n2 = n3;
        }
        this.m_elements[n2] = comparable;
    }

    protected void percolateUpMinHeap(Comparable comparable) {
        int n = ++this.m_size;
        this.m_elements[n] = comparable;
        while (n > 1 && comparable.compareTo(this.m_elements[n / 2]) < 0) {
            int n2 = n / 2;
            this.m_elements[n] = this.m_elements[n2];
            n = n2;
        }
        this.m_elements[n] = comparable;
    }

    protected void percolateUpMaxHeap(Comparable comparable) {
        int n = ++this.m_size;
        while (n > 1 && comparable.compareTo(this.m_elements[n / 2]) > 0) {
            int n2 = n / 2;
            this.m_elements[n] = this.m_elements[n2];
            n = n2;
        }
        this.m_elements[n] = comparable;
    }

    protected void grow() {
        Comparable[] comparableArray = new Comparable[this.m_elements.length * 2];
        System.arraycopy(this.m_elements, 0, comparableArray, 0, this.m_elements.length);
        this.m_elements = comparableArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        int n = 1;
        while (n < this.m_size + 1) {
            if (n != 1) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.m_elements[n]);
            ++n;
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

