/*
 * Decompiled with CFR 0.152.
 */
package junit.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageProducer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.swingui.AboutDialog;
import junit.swingui.ProgressBar;
import junit.swingui.TestBrowser;
import junit.swingui.TraceFrame;
import junit.util.StandardTestSuiteLoader;
import junit.util.StringUtil;
import junit.util.TestSuiteLoader;
import junit.util.Version;

public class TestRunner
implements TestListener,
DocumentListener {
    protected JFrame fFrame;
    private Thread fRunner;
    private TestResult fTestResult;
    private TestSuiteLoader fTestLoader;
    private TraceFrame fTraceFrame;
    private TestBrowser fTestBrowser;
    private JComboBox fSuiteCombo;
    private JButton fRun;
    private ProgressBar fProgressIndicator;
    private JList fFailureList;
    private DefaultListModel fFailures;
    private JLabel fLogo;
    private JTextField fNumberOfErrors;
    private JTextField fNumberOfFailures;
    private JTextField fNumberOfRuns;
    private JButton fQuitButton;
    private JButton fShowErrorButton;
    private JButton fRerunButton;
    private JTextField fStatusLine;
    private JPanel fPanel;
    private static Font PLAIN_FONT = new Font("dialog", 0, 12);
    private static Font BOLD_FONT = new Font("dialog", 1, 12);
    private static final int GAP = 4;
    private static final String SUITE_METHODNAME = "suite";
    static /* synthetic */ Class class$0;

    private void about() {
        AboutDialog about = new AboutDialog(this.fFrame);
        about.setModal(true);
        ((Component)about).setLocation(300, 300);
        about.show();
    }

    public void addError(Test test, Throwable t) {
        this.postError(test, t);
    }

    private void postError(final Test test, final Throwable t) {
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                TestRunner.this.fNumberOfErrors.setText(Integer.toString(TestRunner.this.fTestResult.errorCount()));
                TestRunner.this.appendFailure("Error", test, t);
            }
        });
    }

    public void addFailure(Test test, Throwable t) {
        this.postFailure(test, t);
    }

    private void postFailure(final Test test, final Throwable t) {
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                TestRunner.this.fNumberOfFailures.setText(Integer.toString(TestRunner.this.fTestResult.failureCount()));
                TestRunner.this.appendFailure("Failure", test, t);
            }
        });
    }

    private void addGrid(JPanel p, Component co, int x, int y, int w, int fill, double wx, int anchor) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = x;
        c.gridy = y;
        c.gridwidth = w;
        c.anchor = anchor;
        c.weightx = wx;
        c.fill = fill;
        if (fill == 1 || fill == 3) {
            c.weighty = 1.0;
        }
        c.insets = new Insets(y == 0 ? 4 : 0, x == 0 ? 4 : 0, 4, 4);
        p.add(co, c);
    }

    private void addToHistory(String suite) {
        int i = 0;
        while (i < this.fSuiteCombo.getItemCount()) {
            if (suite.equals(this.fSuiteCombo.getItemAt(i))) {
                this.fSuiteCombo.removeItemAt(i);
                this.fSuiteCombo.insertItemAt(suite, 0);
                this.fSuiteCombo.setSelectedIndex(0);
                return;
            }
            ++i;
        }
        this.fSuiteCombo.insertItemAt(suite, 0);
        i = this.fSuiteCombo.getItemCount() - 1;
        while (i > 5) {
            this.fSuiteCombo.removeItemAt(i);
            --i;
        }
    }

    private void appendFailure(String kind, Test test, Throwable t) {
        this.fFailures.addElement(new TestFailure(test, t));
    }

    public void changedUpdate(DocumentEvent event) {
        this.textChanged();
    }

    protected void connectTestBrowser(Test testSuite, boolean reload) {
        if (this.fTestBrowser != null && this.fTestBrowser.isVisible()) {
            if (reload) {
                this.fTestBrowser.showTestTree(testSuite);
            }
            this.fTestResult.addListener(this.fTestBrowser.getTestListener());
        }
    }

    protected JPanel createCounterPanel() {
        this.fNumberOfErrors = this.createOutputField();
        this.fNumberOfFailures = this.createOutputField();
        this.fNumberOfRuns = this.createOutputField();
        JPanel numbersPanel = new JPanel(new GridLayout(2, 3));
        numbersPanel.add(new JLabel("Runs:"));
        numbersPanel.add(new JLabel("Errors:"));
        numbersPanel.add(new JLabel("Failures: "));
        numbersPanel.add(this.fNumberOfRuns);
        numbersPanel.add(this.fNumberOfErrors);
        numbersPanel.add(this.fNumberOfFailures);
        return numbersPanel;
    }

    protected JPanel createFailedPanel() {
        JPanel failedPanel = new JPanel(new GridLayout(0, 1, 0, 2));
        this.fShowErrorButton = new JButton("Show...");
        this.fShowErrorButton.setEnabled(false);
        this.fShowErrorButton.setToolTipText("Show the Stack Trace");
        this.fShowErrorButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                TestRunner.this.showErrorTrace();
            }
        });
        this.fRerunButton = new JButton("Run");
        this.fRerunButton.setToolTipText("Run the Selected Test");
        this.fRerunButton.setEnabled(false);
        this.fRerunButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                TestRunner.this.rerun();
            }
        });
        failedPanel.add(this.fShowErrorButton);
        failedPanel.add(this.fRerunButton);
        return failedPanel;
    }

    protected JList createFailureList(ListModel model) {
        JList<Object> list = new JList<Object>(model);
        list.setFixedCellWidth(300);
        list.setSelectionMode(0);
        list.setCellRenderer(new FailureListCellRenderer());
        list.setToolTipText("Failure - grey X; Error - red X");
        list.setPreferredSize(new Dimension(200, 150));
        list.addMouseListener(new MouseAdapter(){

            public final void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    TestRunner.this.showErrorTrace();
                }
            }
        });
        list.addListSelectionListener(new ListSelectionListener(){

            public final void valueChanged(ListSelectionEvent e) {
                TestRunner.this.fShowErrorButton.setEnabled(TestRunner.this.isErrorSelected());
                TestRunner.this.fRerunButton.setEnabled(TestRunner.this.isErrorSelected());
            }
        });
        return list;
    }

    protected JMenu createJUnitMenu() {
        JMenu menu = new JMenu("JUnit");
        menu.setMnemonic('J');
        JMenuItem mi1 = new JMenuItem("About...");
        mi1.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent event) {
                TestRunner.this.about();
            }
        });
        mi1.setMnemonic('A');
        menu.add(mi1);
        JMenuItem mi2 = new JMenuItem("Show Test Browser");
        mi2.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent event) {
                TestRunner.this.showTestBrowser();
            }
        });
        mi2.setMnemonic('S');
        menu.add(mi2);
        menu.addSeparator();
        JMenuItem mi3 = new JMenuItem("Exit");
        mi3.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent event) {
                TestRunner.this.terminate();
            }
        });
        mi3.setMnemonic('x');
        menu.add(mi3);
        return menu;
    }

    protected JFrame createFrame(String title) {
        JFrame frame = new JFrame("Run Test Suite");
        Image icon = this.loadFrameIcon();
        if (icon != null) {
            ((Frame)frame).setIconImage(icon);
        }
        frame.getContentPane().setLayout(new BorderLayout(0, 0));
        ((Component)frame).setBackground(SystemColor.control);
        frame.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                TestRunner.this.terminate();
            }
        });
        return frame;
    }

    protected JLabel createLogo() {
        URL url = this.getClass().getResource("logo.gif");
        return new JLabel(new ImageIcon(url));
    }

    protected void createMenus(JMenuBar mb) {
        mb.add(this.createJUnitMenu());
    }

    private JTextField createOutputField() {
        JTextField field = new JTextField("0", 4);
        field.setHorizontalAlignment(2);
        field.setFont(BOLD_FONT);
        field.setEditable(false);
        field.setBorder(BorderFactory.createEmptyBorder());
        return field;
    }

    protected JButton createQuitButton() {
        JButton quit = new JButton("Exit");
        quit.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                TestRunner.this.terminate();
            }
        });
        return quit;
    }

    protected JButton createRunButton() {
        JButton run = new JButton("Run");
        run.setEnabled(true);
        run.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                TestRunner.this.runSuite();
            }
        });
        return run;
    }

    protected Component createRunExtension() {
        return null;
    }

    protected JTextField createStatusLine() {
        JTextField status = new JTextField();
        status.setFont(BOLD_FONT);
        status.setEditable(false);
        status.setForeground(Color.red);
        status.setBorder(BorderFactory.createBevelBorder(1));
        Dimension d = status.getPreferredSize();
        d.width = 420;
        status.setPreferredSize(d);
        return status;
    }

    protected JComboBox createSuiteCombo() {
        JComboBox combo = new JComboBox();
        combo.setEditable(true);
        combo.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public final void keyTyped(KeyEvent e) {
                TestRunner.this.textChanged();
                if (e.getKeyChar() == '\n') {
                    TestRunner.this.runSuite();
                }
            }
        });
        try {
            this.loadHistory(combo);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        combo.addItemListener(new ItemListener(){

            public final void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    TestRunner.this.textChanged();
                }
            }
        });
        return combo;
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    protected JFrame createUI(String suiteName) {
        JPanel panel;
        JFrame frame = this.createFrame("Run Test Suite");
        JMenuBar mb = new JMenuBar();
        this.createMenus(mb);
        frame.setJMenuBar(mb);
        JLabel suiteLabel = new JLabel("Enter the name of the Test class:");
        this.fSuiteCombo = this.createSuiteCombo();
        this.fRun = this.createRunButton();
        Component runExtension = this.createRunExtension();
        JLabel progressLabel = new JLabel("Progress:");
        this.fProgressIndicator = new ProgressBar();
        JPanel numbersPanel = this.createCounterPanel();
        JLabel failureLabel = new JLabel("Errors and Failures:");
        this.fFailures = new DefaultListModel();
        this.fFailureList = this.createFailureList(this.fFailures);
        JPanel failedPanel = this.createFailedPanel();
        this.fStatusLine = this.createStatusLine();
        this.fQuitButton = this.createQuitButton();
        this.fLogo = this.createLogo();
        this.fLogo.setToolTipText("JUnit Version " + Version.id());
        JScrollPane scrolledList = new JScrollPane(this.fFailureList, 20, 32);
        this.fPanel = panel = new JPanel(new GridBagLayout());
        this.addGrid(panel, suiteLabel, 0, 0, 2, 2, 1.0, 17);
        this.addGrid(panel, this.fSuiteCombo, 0, 1, 1, 2, 1.0, 17);
        if (runExtension != null) {
            this.addGrid(panel, runExtension, 1, 1, 1, 0, 0.0, 17);
        }
        this.addGrid(panel, this.fRun, 2, 1, 1, 2, 0.0, 10);
        this.addGrid(panel, progressLabel, 0, 2, 2, 2, 1.0, 17);
        this.addGrid(panel, this.fProgressIndicator, 0, 3, 2, 2, 1.0, 17);
        this.addGrid(panel, this.fLogo, 2, 3, 1, 0, 0.0, 11);
        this.addGrid(panel, numbersPanel, 0, 4, 2, 0, 0.0, 10);
        this.addGrid(panel, failureLabel, 0, 5, 2, 2, 1.0, 17);
        this.addGrid(panel, scrolledList, 0, 6, 2, 1, 1.0, 17);
        this.addGrid(panel, failedPanel, 2, 6, 1, 2, 0.0, 10);
        this.addGrid(panel, this.fStatusLine, 0, 7, 2, 2, 1.0, 10);
        this.addGrid(panel, this.fQuitButton, 2, 7, 1, 2, 0.0, 10);
        frame.setContentPane(panel);
        frame.pack();
        ((Component)frame).setLocation(200, 200);
        return frame;
    }

    public void endTest(Test test) {
        this.postEndTest(test);
    }

    private void postEndTest(Test test) {
        this.synchUI();
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                if (TestRunner.this.fTestResult != null) {
                    TestRunner.this.setLabelValue(TestRunner.this.fNumberOfRuns, TestRunner.this.fTestResult.runCount());
                    TestRunner.this.fProgressIndicator.step(TestRunner.this.fTestResult.wasSuccessful());
                }
            }
        });
    }

    protected String getSuiteText() {
        if (this.fSuiteCombo == null) {
            return "";
        }
        JTextField field = (JTextField)this.fSuiteCombo.getEditor().getEditorComponent();
        return field.getText();
    }

    protected Test getTest(String suiteClassName) {
        if (suiteClassName.length() <= 0) {
            this.fStatusLine.setText("");
            return null;
        }
        Class testClass = null;
        try {
            testClass = this.loadSuiteClass(suiteClassName);
        }
        catch (Exception e) {
            this.runFailed("Class \"" + suiteClassName + "\" not found");
            return null;
        }
        Method suiteMethod = null;
        try {
            suiteMethod = testClass.getMethod(SUITE_METHODNAME, new Class[0]);
        }
        catch (Exception e) {
            this.fStatusLine.setText("");
            return new TestSuite(testClass);
        }
        Test test = null;
        try {
            test = (Test)suiteMethod.invoke(null, (Object[])new Class[0]);
            if (test == null) {
                return test;
            }
        }
        catch (Exception e) {
            this.runFailed("Could not invoke the suite() method");
            return null;
        }
        this.fStatusLine.setText("");
        return test;
    }

    public void insertUpdate(DocumentEvent event) {
        this.textChanged();
    }

    private boolean isErrorSelected() {
        return this.fFailureList.getSelectedIndex() != -1;
    }

    private Image loadFrameIcon() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            URL url = this.getClass().getResource("smalllogo.gif");
            return toolkit.createImage((ImageProducer)url.getContent());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void loadHistory(JComboBox combo) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(this.getSettingsFile()));
        int itemCount = 0;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                combo.addItem(line);
                ++itemCount;
            }
            if (itemCount > 0) {
                combo.setSelectedIndex(0);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            br.close();
            throw throwable;
        }
        Object var4_7 = null;
        br.close();
    }

    private File getSettingsFile() {
        String home = System.getProperty("user.home");
        Assert.assertNotNull(home);
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            return new File(home, "junit.ini");
        }
        return new File(home, ".junit");
    }

    protected Class loadSuiteClass(String suiteClassName) throws ClassNotFoundException {
        return this.fTestLoader.load(suiteClassName);
    }

    public static void main(String[] args) {
        new TestRunner().start(args, new StandardTestSuiteLoader());
    }

    private void postInfo(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                TestRunner.this.showInfo(message);
            }
        });
    }

    private void postStatus(final String status) {
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                TestRunner.this.showStatus(status);
            }
        });
    }

    public void removeUpdate(DocumentEvent event) {
        this.textChanged();
    }

    private void rerun() {
        int index = this.fFailureList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        TestFailure failure = (TestFailure)this.fFailures.elementAt(index);
        Test test = failure.failedTest();
        if (!(test instanceof TestCase)) {
            this.showInfo("Could not reload " + test.toString());
            return;
        }
        Test reloadedTest = null;
        try {
            Class reloadedTestClass = this.fTestLoader.reload(test.getClass());
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class[] classArgs = classArray;
            Object[] args = new Object[]{((TestCase)test).name()};
            Constructor constructor = reloadedTestClass.getConstructor(classArgs);
            reloadedTest = (Test)constructor.newInstance(args);
        }
        catch (Exception e) {
            this.showInfo("Could not reload " + test.toString());
            return;
        }
        TestResult result = new TestResult();
        reloadedTest.run(result);
        String message = reloadedTest.toString();
        if (result.wasSuccessful()) {
            this.showInfo(String.valueOf(message) + " was successful");
        } else if (result.errorCount() == 1) {
            this.showStatus(String.valueOf(message) + " had an error");
        } else {
            this.showStatus(String.valueOf(message) + " had a failure");
        }
    }

    protected void reset() {
        this.setLabelValue(this.fNumberOfErrors, 0);
        this.setLabelValue(this.fNumberOfFailures, 0);
        this.setLabelValue(this.fNumberOfRuns, 0);
        this.fProgressIndicator.reset();
        this.fShowErrorButton.setEnabled(false);
        this.fRerunButton.setEnabled(false);
        this.fFailures.clear();
    }

    public void run() {
        this.runSuite();
    }

    private void runFailed(String message) {
        this.showStatus(message);
        this.fRun.setText("Run");
        this.fRunner = null;
    }

    public synchronized void runSuite() {
        if (this.fRunner != null) {
            this.fTestResult.stop();
        } else {
            this.reset();
            this.showInfo("Load Test Case...");
            String suiteName = this.getSuiteText();
            Test testSuite = this.getTest(suiteName);
            if (testSuite != null) {
                this.addToHistory(suiteName);
                this.doRunTest(testSuite, true);
            }
        }
    }

    protected synchronized void runTest(Test testSuite) {
        if (this.fRunner != null) {
            this.fTestResult.stop();
        } else {
            this.reset();
            if (testSuite != null) {
                this.doRunTest(testSuite, false);
            }
        }
    }

    private void doRunTest(final Test testSuite, final boolean reload) {
        this.setButtonLabel(this.fRun, "Stop");
        this.fRunner = new Thread(){

            public final void run() {
                TestRunner.this.fTestResult = TestRunner.this.createTestResult();
                TestRunner.this.fTestResult.addListener(TestRunner.this);
                TestRunner.this.connectTestBrowser(testSuite, reload);
                TestRunner.this.start(testSuite);
                TestRunner.this.postInfo("Running...");
                long startTime = System.currentTimeMillis();
                testSuite.run(TestRunner.this.fTestResult);
                if (TestRunner.this.fTestResult.shouldStop()) {
                    TestRunner.this.postStatus("Stopped");
                } else {
                    long endTime = System.currentTimeMillis();
                    long runTime = endTime - startTime;
                    TestRunner.this.postInfo("Finished: " + StringUtil.elapsedTimeAsString(runTime) + " seconds");
                }
                TestRunner.this.setButtonLabel(TestRunner.this.fRun, "Run");
                TestRunner.this.fRunner = null;
            }
        };
        this.fRunner.start();
    }

    private void saveHistory() throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.getSettingsFile()));
        try {
            int i = 0;
            while (i < this.fSuiteCombo.getItemCount()) {
                String testsuite = this.fSuiteCombo.getItemAt(i).toString();
                bw.write(testsuite, 0, testsuite.length());
                bw.newLine();
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            bw.close();
            throw throwable;
        }
        Object var2_6 = null;
        bw.close();
    }

    private void setButtonLabel(final JButton button, final String label) {
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                button.setText(label);
            }
        });
    }

    private void setLabelValue(final JTextField label, final int value) {
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                label.setText(Integer.toString(value));
            }
        });
    }

    public void setSuiteName(String suite) {
        this.fSuiteCombo.addItem(suite);
        this.fSuiteCombo.setSelectedItem(suite);
    }

    private void showErrorTrace() {
        int index = this.fFailureList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        TestFailure failure = (TestFailure)this.fFailures.elementAt(index);
        Throwable t = failure.thrownException();
        if (this.fTraceFrame == null) {
            this.fTraceFrame = new TraceFrame();
            ((Component)this.fTraceFrame).setLocation(100, 100);
        }
        this.fTraceFrame.showTrace(t);
        ((Component)this.fTraceFrame).setVisible(true);
    }

    private void showInfo(String message) {
        this.fStatusLine.setFont(PLAIN_FONT);
        this.fStatusLine.setForeground(Color.black);
        this.fStatusLine.setText(message);
    }

    private void showStatus(String status) {
        this.fStatusLine.setFont(BOLD_FONT);
        this.fStatusLine.setForeground(Color.red);
        this.fStatusLine.setText(status);
    }

    private void showTestBrowser() {
        String suiteName = this.getSuiteText();
        Test testSuite = this.getTest(suiteName);
        if (testSuite == null) {
            return;
        }
        if (this.fTestBrowser == null) {
            this.fTestBrowser = new TestBrowser(this);
            ((Component)this.fTestBrowser).setLocation(350, 100);
        }
        this.fTestBrowser.showTestTree(testSuite);
        ((Component)this.fTestBrowser).setVisible(true);
    }

    public void start(String[] args, TestSuiteLoader loader) {
        this.fTestLoader = loader;
        String suiteName = null;
        if (args.length == 1) {
            suiteName = args[0];
        } else if (args.length == 2 && args[0].equals("-c")) {
            suiteName = StringUtil.extractClassName(args[1]);
        }
        this.fFrame = this.createUI(suiteName);
        ((Component)this.fFrame).setVisible(true);
        if (suiteName != null) {
            this.setSuiteName(suiteName);
            this.runSuite();
        }
    }

    private void start(final Test test) {
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                TestRunner.this.fProgressIndicator.start(test.countTestCases());
            }
        });
    }

    public void startTest(Test test) {
        this.postInfo("Running: " + test);
    }

    private void synchUI() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public final void run() {
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void terminate() {
        this.fFrame.dispose();
        try {
            this.saveHistory();
        }
        catch (IOException e) {
            System.out.println("Couldn't save test run history");
        }
        System.exit(0);
    }

    public void textChanged() {
        this.fRun.setEnabled(this.getSuiteText().length() > 0);
        this.fStatusLine.setText("");
    }

    static class FailureListCellRenderer
    extends DefaultListCellRenderer {
        private ImageIcon fFailureIcon;
        private ImageIcon fErrorIcon;

        FailureListCellRenderer() {
            URL url = this.getClass().getResource("failure.gif");
            this.fFailureIcon = new ImageIcon(url);
            url = this.getClass().getResource("error.gif");
            this.fErrorIcon = new ImageIcon(url);
        }

        public Component getListCellRendererComponent(JList list, Object value, int modelIndex, boolean isSelected, boolean cellHasFocus) {
            TestFailure failure = (TestFailure)value;
            String text = failure.failedTest().toString();
            String msg = failure.thrownException().getMessage();
            if (msg != null) {
                text = String.valueOf(text) + ":" + StringUtil.truncate(msg, 200);
            }
            if (failure.thrownException() instanceof AssertionFailedError) {
                this.setIcon(this.fFailureIcon);
            } else {
                this.setIcon(this.fErrorIcon);
            }
            return super.getListCellRendererComponent((JList<?>)list, text, modelIndex, isSelected, cellHasFocus);
        }
    }
}

