/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.camelot;

import java.net.URL;
import java.net.URLClassLoader;
import org.apache.avalon.camelot.FactoryException;
import org.apache.avalon.camelot.Loader;
import org.apache.avalon.util.ObjectUtil;
import org.apache.avalon.util.StringUtil;

public class DefaultLoader
implements Loader {
    protected ClassLoader m_classLoader;

    public ClassLoader getClassLoader() {
        return this.m_classLoader;
    }

    public Object load(String classname, Class clazz) throws FactoryException {
        Object object = this.load(classname);
        if (!clazz.isInstance(object)) {
            throw new FactoryException("Created object of type " + object.getClass().getName() + " not compatable with type " + clazz.getName());
        }
        return object;
    }

    public Object load(String classname) throws FactoryException {
        try {
            return ObjectUtil.createObject(this.m_classLoader, classname);
        }
        catch (ClassNotFoundException cnfe) {
            throw new FactoryException("Failed to locate class " + classname, cnfe);
        }
        catch (InstantiationException ie) {
            throw new FactoryException("Failed to instantiate class " + classname, ie);
        }
        catch (IllegalAccessException iae) {
            throw new FactoryException("Failed to instantiate class " + classname + " as it does not have a publicly accesable " + "default constructor", iae);
        }
        catch (Throwable t) {
            throw new FactoryException("Failed to get class " + classname + " due to " + StringUtil.printStackTrace(t, 5, true), t);
        }
    }

    public DefaultLoader(ClassLoader classLoader) {
        this.m_classLoader = classLoader;
    }

    public DefaultLoader(URL location, ClassLoader classLoader) {
        this.m_classLoader = new URLClassLoader(new URL[]{location}, classLoader);
    }

    public DefaultLoader(URL location) {
        this(location, Thread.currentThread().getContextClassLoader());
    }

    public DefaultLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.m_classLoader = new URLClassLoader(new URL[0], classLoader);
    }
}

