/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.ejb;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import org.apache.log4j.Category;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.ejb.AbstractEjbCodeGeneratorSubTask;
import xdoclet.ejb.tags.PkTagsHandler;
import xdoclet.tags.PackageTagsHandler;
import xdoclet.util.DocletUtil;
import xdoclet.util.Log;
import xdoclet.util.Translator;

public class EntityPkSubTask
extends AbstractEjbCodeGeneratorSubTask {
    public static final String SUBTASK_NAME = "entitypk";
    public static final String DEFAULT_ENTITY_PK_CLASS_PATTERN = "{0}PK";
    protected static String DEFAULT_TEMPLATE_FILE = "/xdoclet/ejb/entitypk.j";
    protected String entityPkClassPattern;
    static /* synthetic */ Class class$xdoclet$ejb$EntityPkSubTask;

    public EntityPkSubTask() {
        this.setTemplateURL(this.getClass().getResource(DEFAULT_TEMPLATE_FILE));
        this.setDestinationFile(this.getEntityPkClassPattern() + ".java");
        this.setOfType("javax.ejb.EntityBean");
    }

    public String getSubTaskName() {
        return SUBTASK_NAME;
    }

    public String getEntityPkClassPattern() {
        if (this.entityPkClassPattern != null) {
            return this.entityPkClassPattern;
        }
        return DEFAULT_ENTITY_PK_CLASS_PATTERN;
    }

    public void setPattern(String new_pattern) {
        this.entityPkClassPattern = new_pattern;
    }

    public void validateOptions() throws XDocletException {
        super.validateOptions();
        if (this.getEntityPkClassPattern() == null || this.getEntityPkClassPattern().trim().equals("")) {
            throw new XDocletException(Translator.getString("parameter_missing_or_empty", new String[]{"pattern"}));
        }
        if (this.getEntityPkClassPattern().indexOf("{0}") == -1) {
            throw new XDocletException(Translator.getString("xdoclet.ejb.Messages", "pattern_has_no_placeholder"));
        }
    }

    protected String getGeneratedFileName(ClassDoc clazz) throws XDocletException {
        return PackageTagsHandler.packageNameAsPathFor(PkTagsHandler.getPkClassFor(this.getCurrentClass())) + ".java";
    }

    protected boolean matchesGenerationRules(ClassDoc clazz) throws XDocletException {
        if (!super.matchesGenerationRules(clazz)) {
            return false;
        }
        Category cat = Log.getCategory(class$xdoclet$ejb$EntityPkSubTask == null ? (class$xdoclet$ejb$EntityPkSubTask = EntityPkSubTask.class$("xdoclet.ejb.EntityPkSubTask")) : class$xdoclet$ejb$EntityPkSubTask, "matchesGenerationRules");
        String pk_class = PkTagsHandler.getPkClassFor(clazz);
        if ("false".equals(XDocletTagSupport.getParameterValue(clazz, DocletUtil.getText((Doc)this.getCurrentClass(), "ejb:pk", false), "generate", -1))) {
            cat.debug((Object)("Skip primary key for " + clazz.qualifiedName() + " because of false generate flag"));
            return false;
        }
        if (pk_class != null && pk_class.indexOf("java.lang") != -1) {
            cat.debug((Object)("Skip primary key for " + clazz.qualifiedName() + " because the pkClass (" + pk_class + ") is a system class."));
            return false;
        }
        return true;
    }

    protected void engineStarted() throws XDocletException {
        System.out.println(Translator.getString("xdoclet.ejb.Messages", "generating_pk_for", new String[]{this.getCurrentClass().qualifiedName()}));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

