/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.apache.ant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.types.EnumeratedAttribute;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.modules.apache.ant.AntSubTask;
import xdoclet.tagshandler.AbstractProgramElementTagsHandler;
import xdoclet.tagshandler.MethodTagsHandler;
import xdoclet.util.LogUtil;
import xjavadoc.XClass;
import xjavadoc.XCollections;
import xjavadoc.XMethod;
import xjavadoc.XParameter;
import xjavadoc.XTag;

public class TaskTagsHandler
extends XDocletTagSupport {
    public static final String DEFAULT_CATEGORY = "other";
    private static Map attributeDisplayMap = new HashMap();
    private static Map elementDisplayMap = new HashMap();
    private static String[] fluffPrefixes = new String[]{"set a", "set the", "sets a", "sets the"};
    static /* synthetic */ Class class$xdoclet$modules$apache$ant$TaskTagsHandler;

    public static final String getTaskName(XClass clazz) throws XDocletException {
        String tagValue = clazz.getDoc().getTagAttributeValue("ant.task", "name");
        if (tagValue == null) {
            tagValue = clazz.getName();
            if (tagValue.endsWith("Task")) {
                tagValue = tagValue.substring(0, tagValue.indexOf("Task"));
            }
            tagValue = tagValue.toLowerCase();
        }
        return tagValue;
    }

    public static final String getCategoryName(XClass clazz) throws XDocletException {
        String tagValue = clazz.getDoc().getTagAttributeValue("ant.task", "category");
        tagValue = tagValue != null ? tagValue.toLowerCase() : DEFAULT_CATEGORY;
        return tagValue;
    }

    public void forAllTasks(String template, Properties attributes) throws XDocletException {
        Collection classes = AbstractProgramElementTagsHandler.getAllClasses();
        XClass cur_class = null;
        Log log = LogUtil.getLog((Class)(class$xdoclet$modules$apache$ant$TaskTagsHandler == null ? (class$xdoclet$modules$apache$ant$TaskTagsHandler = TaskTagsHandler.class$("xdoclet.modules.apache.ant.TaskTagsHandler")) : class$xdoclet$modules$apache$ant$TaskTagsHandler), (String)"forAllTasks");
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            cur_class = (XClass)iter.next();
            log.info((Object)("Processing " + cur_class.getName()));
            XDocletTagSupport.setCurrentClass((XClass)cur_class);
            if (!AntSubTask.isAntTask(cur_class)) continue;
            this.generate(template);
        }
    }

    public void forAllAttributes(String template, Properties attributes) throws XDocletException {
        XClass cur_class = XDocletTagSupport.getCurrentClass();
        XMethod[] methods = this.getAttributeMethods(cur_class);
        int i = 0;
        while (i < methods.length) {
            XDocletTagSupport.setCurrentMethod((XMethod)methods[i]);
            this.generate(template);
            ++i;
        }
    }

    public void ifHasAttributes(String template, Properties attributes) throws XDocletException {
        XClass cur_class = XDocletTagSupport.getCurrentClass();
        XMethod[] methods = this.getAttributeMethods(cur_class);
        if (methods.length > 0) {
            this.generate(template);
        }
    }

    public void forAllElements(String template, Properties attributes) throws XDocletException {
        XClass cur_class = XDocletTagSupport.getCurrentClass();
        XMethod[] methods = this.getElementMethods(cur_class);
        int i = 0;
        while (i < methods.length) {
            XDocletTagSupport.setCurrentMethod((XMethod)methods[i]);
            this.generate(template);
            ++i;
        }
    }

    public String elementName() throws XDocletException {
        String methodName = XDocletTagSupport.getCurrentMethod().getName();
        String elementName = "<not a valid element>";
        if (methodName.startsWith("addConfigured")) {
            elementName = methodName.substring(13, methodName.length());
        } else if (methodName.startsWith("add")) {
            elementName = methodName.substring(3, methodName.length());
        } else if (methodName.startsWith("create")) {
            elementName = methodName.substring(6, methodName.length());
        }
        return elementName.toLowerCase();
    }

    public String displayAttributeType() throws XDocletException {
        Collection parameters = XDocletTagSupport.getCurrentMethod().getParameters();
        XParameter param = XCollections.parameterIterator((Collection)parameters).next();
        String methodType = param.getType().getQualifiedName();
        String display = (String)attributeDisplayMap.get(methodType);
        if (display == null) {
            Class clazz = this.getAttributeClass(methodType);
            if (clazz == null) {
                return methodType;
            }
            Object instance = null;
            try {
                instance = clazz.newInstance();
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            if (instance != null && instance instanceof EnumeratedAttribute) {
                EnumeratedAttribute enumeratedAttribute = instance;
                String[] values = enumeratedAttribute.getValues();
                display = "";
                int i = 0;
                while (i < values.length) {
                    display = display + "&quot;" + values[i] + "&quot;";
                    if (i != values.length - 1) {
                        display = display + ", ";
                    }
                    ++i;
                }
                return display;
            }
            display = "";
        }
        return display;
    }

    public String displayElementType() throws XDocletException {
        String elementType = this.elementType();
        String display = (String)elementDisplayMap.get(elementType);
        if (display == null) {
            display = "";
        }
        return display;
    }

    public String elementType() throws XDocletException {
        XClass clazz = this.elementClassDoc();
        if (clazz == null) {
            throw new XDocletException("Method is not an Ant element!");
        }
        return clazz.getQualifiedName();
    }

    public String taskName() throws XDocletException {
        return TaskTagsHandler.getTaskName(XDocletTagSupport.getCurrentClass());
    }

    public String propertyName() {
        return MethodTagsHandler.getPropertyNameFor((XMethod)XDocletTagSupport.getCurrentMethod()).toLowerCase();
    }

    public String shortMethodDescription() throws XDocletException {
        String desc = XDocletTagSupport.getCurrentMethod().getDoc().getFirstSentence();
        if (desc == null || desc.length() == 0) {
            desc = "no description";
        }
        desc = desc.trim();
        String descLower = desc.toLowerCase();
        int i = 0;
        while (i < fluffPrefixes.length) {
            String prefix = fluffPrefixes[i].toLowerCase() + " ";
            if (descLower.startsWith(prefix)) {
                desc = desc.substring(prefix.length());
                break;
            }
            ++i;
        }
        desc = desc.substring(0, 1).toUpperCase() + desc.substring(1);
        if (!desc.endsWith(".")) {
            desc = desc + ".";
        }
        return desc;
    }

    public String categoryName() throws XDocletException {
        return TaskTagsHandler.getCategoryName(XDocletTagSupport.getCurrentClass());
    }

    private Class getAttributeClass(String type) throws XDocletException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            int lastDotPosition = type.lastIndexOf(46);
            if (lastDotPosition < 0) {
                return null;
            }
            type = type.substring(0, lastDotPosition) + "$" + type.substring(lastDotPosition + 1);
            try {
                clazz = Class.forName(type);
            }
            catch (ClassNotFoundException e1) {
                throw new XDocletException(e1.getMessage());
            }
        }
        return clazz;
    }

    private XMethod[] getAttributeMethods(XClass cur_class) throws XDocletException {
        IntrospectionHelper is = null;
        Log log = LogUtil.getLog((Class)(class$xdoclet$modules$apache$ant$TaskTagsHandler == null ? (class$xdoclet$modules$apache$ant$TaskTagsHandler = TaskTagsHandler.class$("xdoclet.modules.apache.ant.TaskTagsHandler")) : class$xdoclet$modules$apache$ant$TaskTagsHandler), (String)"getAttributeMethods");
        try {
            log.info((Object)("Processing " + cur_class.getName()));
            is = IntrospectionHelper.getHelper(Class.forName(cur_class.getQualifiedName()));
        }
        catch (ClassNotFoundException e) {
            throw new XDocletException((Exception)e, e.getMessage());
        }
        Enumeration enumeration = is.getAttributes();
        Properties attributeTypeMap = new Properties();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            Class type = is.getAttributeType(name);
            attributeTypeMap.setProperty(name, type.getName());
        }
        XMethod[] allMethods = this.getMethods(cur_class);
        ArrayList<XMethod> attributeMethods = new ArrayList<XMethod>();
        int i = 0;
        while (i < allMethods.length) {
            XMethod method = allMethods[i];
            String methodName = method.getName();
            if (methodName.startsWith("set")) {
                String attributeName = methodName.substring(3).toLowerCase();
                if (method.getParameters().size() == 1 && method.isPublic()) {
                    String attributeType = XCollections.parameterIterator((Collection)method.getParameters()).next().getType().getQualifiedName();
                    String mapAttribute = attributeTypeMap.getProperty(attributeName);
                    if (mapAttribute != null && attributeType.equals(mapAttribute.replace('$', '.'))) {
                        attributeMethods.add(method);
                    }
                }
            }
            ++i;
        }
        return attributeMethods.toArray(new XMethod[0]);
    }

    private XMethod[] getElementMethods(XClass cur_class) throws XDocletException {
        IntrospectionHelper is = null;
        try {
            is = IntrospectionHelper.getHelper(Class.forName(cur_class.getQualifiedName()));
        }
        catch (ClassNotFoundException e) {
            throw new XDocletException(e.getMessage());
        }
        Enumeration enumeration = is.getNestedElements();
        Properties elementTypeMap = new Properties();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            Class type = is.getElementType(name);
            elementTypeMap.setProperty(name, type.getName());
        }
        XMethod[] allMethods = this.getMethods(cur_class);
        ArrayList<XMethod> elementMethods = new ArrayList<XMethod>();
        int i = 0;
        while (i < allMethods.length) {
            block8: {
                String mapElementType;
                String elementType;
                String elementName;
                XMethod method;
                block10: {
                    block9: {
                        method = allMethods[i];
                        String methodName = method.getName();
                        elementName = null;
                        boolean adder = false;
                        if (methodName.startsWith("create")) {
                            elementName = methodName.substring(6).toLowerCase();
                        }
                        if (methodName.startsWith("add")) {
                            int length = 3;
                            if (methodName.startsWith("addConfigured")) {
                                length = 13;
                            }
                            elementName = methodName.substring(length).toLowerCase();
                            adder = true;
                        }
                        if (elementName == null) break block8;
                        elementType = null;
                        if (!adder) break block9;
                        if (method.getParameters().size() != 1) break block8;
                        elementType = XCollections.parameterIterator((Collection)method.getParameters()).next().getType().getQualifiedName();
                        break block10;
                    }
                    elementType = method.getReturnType().getQualifiedName();
                }
                if (method.isPublic() && (mapElementType = elementTypeMap.getProperty(elementName)) != null && elementType.equals(mapElementType.replace('$', '.'))) {
                    elementMethods.add(method);
                }
            }
            ++i;
        }
        return elementMethods.toArray(new XMethod[0]);
    }

    private XMethod[] getMethods(XClass cur_class) throws XDocletException {
        HashMap<String, XMethod> already = new HashMap<String, XMethod>();
        ArrayList<XMethod> methods = new ArrayList<XMethod>();
        while (cur_class != null) {
            if (cur_class.getQualifiedName().equals("org.apache.tools.ant.Task") || cur_class.getQualifiedName().equals("org.apache.tools.ant.taskdefs.MatchingTask")) break;
            Collection curMethods = cur_class.getMethods();
            Iterator iter = curMethods.iterator();
            while (iter.hasNext()) {
                XMethod method = (XMethod)iter.next();
                if (this.isDeprecated(method) || this.shouldIgnore(method)) continue;
                String methodName = method.getName();
                if (method.getContainingClass() != cur_class || already.containsKey(methodName)) continue;
                already.put(methodName, method);
                methods.add(method);
            }
            cur_class = cur_class.getSuperclass();
        }
        return this.sortMethods(methods);
    }

    private boolean isDeprecated(XMethod method) {
        Collection tags = method.getDoc().getTags();
        Iterator iter = tags.iterator();
        while (iter.hasNext()) {
            XTag tag = (XTag)iter.next();
            if (!tag.getName().equals("@deprecated")) continue;
            return true;
        }
        return false;
    }

    private XClass elementClassDoc() {
        Collection params;
        XClass clazz = null;
        String methodName = XDocletTagSupport.getCurrentMethod().getName();
        if ((methodName.startsWith("addConfigured") || methodName.startsWith("add") || methodName.startsWith("create")) && "void".equals((clazz = XDocletTagSupport.getCurrentMethod().getReturnType()).getName()) && (params = XDocletTagSupport.getCurrentMethod().getParameters()).size() == 1) {
            clazz = XCollections.parameterIterator((Collection)params).next().getType();
        }
        return clazz;
    }

    private boolean shouldIgnore(XMethod method) throws XDocletException {
        String value = method.getDoc().getTagAttributeValue("ant.attribute", "ignore");
        if ("true".equals(value)) {
            return true;
        }
        value = method.getDoc().getTagAttributeValue("ant.element", "ignore");
        return "true".equals(value);
    }

    private XMethod[] sortMethods(List methods) {
        Collections.sort(methods, new Comparator(){

            public int compare(Object o1, Object o2) {
                XMethod m1 = (XMethod)o1;
                XMethod m2 = (XMethod)o2;
                return m1.getName().compareTo(m2.getName());
            }

            public boolean equals(Object obj) {
                return obj == this;
            }
        });
        return methods.toArray(new XMethod[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        attributeDisplayMap.put("java.lang.String", "String");
        attributeDisplayMap.put("boolean", "boolean");
        attributeDisplayMap.put("org.apache.tools.ant.types.Path", "Path");
        attributeDisplayMap.put("org.apache.tools.ant.types.Reference", "Reference");
        attributeDisplayMap.put("java.io.File", "File");
        attributeDisplayMap.put("java.util.Date", "Date");
        attributeDisplayMap.put("java.net.URL", "URL");
        attributeDisplayMap.put("java.lang.Long", "long");
        attributeDisplayMap.put("java.lang.Integer", "int");
        attributeDisplayMap.put("java.lang.Float", "float");
        attributeDisplayMap.put("java.lang.Double", "double");
        elementDisplayMap.put("org.apache.tools.ant.types.Path", "Path");
        elementDisplayMap.put("org.apache.tools.ant.types.FileSet", "Fileset");
        elementDisplayMap.put("org.apache.tools.ant.taskdefs.Property", "see &lt;property&gt;");
        elementDisplayMap.put("org.apache.tools.ant.types.Mapper", "Mapper");
        elementDisplayMap.put("org.apache.tools.ant.types.PatternSet", "Patternset");
        elementDisplayMap.put("org.apache.tools.ant.types.FileList", "Filelist");
        elementDisplayMap.put("org.apache.tools.ant.types.FilterChain", "FilterChain");
        elementDisplayMap.put("org.apache.tools.ant.types.FilterSet", "Filterset");
        elementDisplayMap.put("org.apache.tools.ant.types.ZipFileSet", "ZipFileset");
        elementDisplayMap.put("org.apache.tools.ant.types.DirSet", "Dirset");
        elementDisplayMap.put("org.apache.tools.ant.types.XMLCatalog", "XMLCatalog");
    }
}

