/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.DefaultReaderFactory;
import org.apache.xerces.readers.XMLDeclRecognizer;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.readers.XMLEntityReaderFactory;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.URI;
import org.apache.xerces.utils.XMLCharacterProperties;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;

public class DefaultEntityHandler
implements XMLEntityHandler,
XMLEntityHandler.DTDHandler {
    private ReaderState fReaderStateFreeList = null;
    private StringPool fStringPool = null;
    private EventHandler fEventHandler = null;
    private XMLEntityHandler.CharDataHandler fCharDataHandler = null;
    private XMLErrorReporter fErrorReporter = null;
    private EntityResolver fResolver = null;
    private EntityPool fEntityPool = null;
    private EntityPool fParameterEntityPool = null;
    private byte[] fEntityTypeStack = null;
    private int[] fEntityNameStack = null;
    private int fEntityStackDepth = 0;
    private Stack fReaderStack = new Stack();
    private XMLEntityHandler.EntityReader fReader = null;
    private InputSource fSource = null;
    private int fEntityName = -1;
    private int fEntityType = -1;
    private int fEntityContext = -1;
    private String fPublicId = null;
    private String fSystemId = null;
    private int fReaderId = -1;
    private int fReaderDepth = -1;
    private int fNextReaderId = 0;
    private NullReader fNullReader = null;
    protected XMLEntityReaderFactory fReaderFactory = null;
    private boolean fSendCharDataAsCharArray = false;
    static final int CHUNK_SHIFT = 5;
    static final int CHUNK_SIZE = 32;
    static final int CHUNK_MASK = 31;
    static final int INITIAL_CHUNK_COUNT = 32;

    public DefaultEntityHandler(StringPool stringPool, XMLErrorReporter xMLErrorReporter) {
        this.fStringPool = stringPool;
        this.fErrorReporter = xMLErrorReporter;
        this.fReaderFactory = new DefaultReaderFactory();
        this.fEntityPool = new EntityPool(this.fStringPool, this.fErrorReporter, true);
    }

    public int addExternalEntityDecl(int n, int n2, int n3, boolean bl) throws Exception {
        int n4 = this.fEntityPool.addEntityDecl(n, -1, n2, n3, this.fStringPool.addSymbol(this.fSystemId), -1, bl);
        return n4;
    }

    public int addExternalPEDecl(int n, int n2, int n3, boolean bl) throws Exception {
        if (this.fParameterEntityPool == null) {
            this.fParameterEntityPool = new EntityPool(this.fStringPool, this.fErrorReporter, false);
        }
        int n4 = this.fParameterEntityPool.addEntityDecl(n, -1, n2, n3, this.fStringPool.addSymbol(this.fSystemId), -1, bl);
        return n4;
    }

    public int addInternalEntityDecl(int n, int n2, boolean bl) throws Exception {
        int n3 = this.fEntityPool.addEntityDecl(n, n2, -1, -1, -1, -1, bl);
        return n3;
    }

    public int addInternalPEDecl(int n, int n2, boolean bl) throws Exception {
        if (this.fParameterEntityPool == null) {
            this.fParameterEntityPool = new EntityPool(this.fStringPool, this.fErrorReporter, false);
        }
        int n3 = this.fParameterEntityPool.addEntityDecl(n, n2, -1, -1, -1, -1, bl);
        return n3;
    }

    public int addNotationDecl(int n, int n2, int n3, boolean bl) throws Exception {
        int n4 = this.fEntityPool.addNotationDecl(n, n2, n3, this.fStringPool.addSymbol(this.fSystemId), bl);
        return n4;
    }

    public void addRecognizer(XMLDeclRecognizer xMLDeclRecognizer) {
        this.fReaderFactory.addRecognizer(xMLDeclRecognizer);
    }

    public void addRequiredNotation(int n, Locator locator, int n2, int n3, Object[] objectArray) {
        this.fEntityPool.addRequiredNotation(n, locator, n2, n3, objectArray);
    }

    public int addUnparsedEntityDecl(int n, int n2, int n3, int n4, boolean bl) throws Exception {
        int n5 = this.fEntityPool.addEntityDecl(n, -1, n2, n3, this.fStringPool.addSymbol(this.fSystemId), n4, bl);
        if (!this.fEntityPool.isNotationDeclared(n4)) {
            Object[] objectArray = new Object[]{this.fStringPool.toString(n), this.fStringPool.toString(n4)};
            this.fEntityPool.addRequiredNotation(n4, this.fErrorReporter.getLocator(), 114, 89, objectArray);
        }
        return n5;
    }

    public XMLEntityHandler.EntityReader changeReaders() throws Exception {
        this.fEventHandler.sendEndOfInputNotifications(this.fEntityName, this.fReaderStack.size() > 1);
        this.fEventHandler.endEntityReference(this.fEntityName, this.fEntityType, this.fEntityContext);
        this.popReader();
        this.fEventHandler.sendReaderChangeNotifications(this.fReader, this.fReaderId);
        this.popEntity();
        return this.fReader;
    }

    public void checkRequiredNotations() throws Exception {
        this.fEntityPool.checkRequiredNotations();
    }

    public void endEntityDecl() throws Exception {
        this.popEntity();
    }

    private String entityReferencePath(boolean bl, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(top-level)");
        int n2 = 0;
        while (n2 < this.fEntityStackDepth) {
            if (this.fEntityNameStack[n2] >= 0) {
                stringBuffer.append('-');
                stringBuffer.append(this.fEntityTypeStack[n2] == 1 ? (char)'%' : '&');
                stringBuffer.append(this.fStringPool.toString(this.fEntityNameStack[n2]));
                stringBuffer.append(';');
            }
            ++n2;
        }
        stringBuffer.append('-');
        stringBuffer.append(bl ? (char)'%' : '&');
        stringBuffer.append(this.fStringPool.toString(n));
        stringBuffer.append(';');
        return stringBuffer.toString();
    }

    public String expandSystemId(String string) {
        return this.expandSystemId(string, this.fSystemId);
    }

    private String expandSystemId(String string, String string2) {
        URI uRI;
        String string3 = string;
        if (string3 == null || string3.length() == 0) {
            return string;
        }
        try {
            uRI = new URI(string3);
            if (uRI != null) {
                return string;
            }
        }
        catch (URI.MalformedURIException malformedURIException) {}
        string3 = DefaultEntityHandler.fixURI(string3);
        uRI = null;
        URI uRI2 = null;
        try {
            if (string2 == null) {
                String string4;
                try {
                    string4 = DefaultEntityHandler.fixURI(System.getProperty("user.dir"));
                }
                catch (SecurityException securityException) {
                    string4 = "";
                }
                if (!string4.endsWith("/")) {
                    string4 = String.valueOf(string4) + "/";
                }
                uRI = new URI("file", "", string4, null, null);
            } else {
                uRI = new URI(string2);
            }
            uRI2 = new URI(uRI, string3);
        }
        catch (Exception exception) {}
        if (uRI2 == null) {
            return string;
        }
        return uRI2.toString();
    }

    public boolean externalReferenceInContent(int n) throws Exception {
        boolean bl = this.fEntityPool.isExternalEntity(n);
        if (this.fEventHandler.externalEntityStandaloneCheck()) {
            if (bl) {
                this.reportRecoverableXMLError(102, 80, this.fEntityName);
            } else if (this.fEntityPool.getEntityDeclIsExternal(n)) {
                this.reportRecoverableXMLError(132, 80, this.fEntityName);
            }
        }
        return bl;
    }

    private static String fixURI(String string) {
        char c;
        char c2;
        if ((string = string.replace(File.separatorChar, '/')).length() >= 2 && (c2 = string.charAt(1)) == ':' && (c = Character.toUpperCase(string.charAt(0))) >= 'A' && c <= 'Z') {
            string = "/" + string;
        }
        return string;
    }

    public boolean getAllowJavaEncodings() {
        return this.fReaderFactory.getAllowJavaEncodingName();
    }

    public XMLEntityHandler.CharDataHandler getCharDataHandler() {
        return this.fCharDataHandler;
    }

    public int getColumnNumber() {
        return this.fReader == null ? 0 : this.fReader.getColumnNumber();
    }

    public XMLEntityHandler.EntityReader getEntityReader() {
        return this.fReader;
    }

    public EntityResolver getEntityResolver() {
        return this.fResolver;
    }

    protected int getEntityValue(int n) {
        int n2 = this.fEntityPool.getEntityValue(n);
        return n2;
    }

    public int getLineNumber() {
        return this.fReader == null ? 0 : this.fReader.getLineNumber();
    }

    protected int getParameterEntityValue(int n) {
        int n2 = this.fParameterEntityPool.getEntityValue(n);
        return n2;
    }

    public String getPublicId() {
        return this.fPublicId;
    }

    protected String getPublicIdOfEntity(int n) {
        int n2 = this.fEntityPool.getPublicId(n);
        return this.fStringPool.toString(n2);
    }

    protected String getPublicIdOfParameterEntity(int n) {
        int n2 = this.fParameterEntityPool.getPublicId(n);
        return this.fStringPool.toString(n2);
    }

    public int getReaderDepth() {
        return this.fReaderDepth;
    }

    public int getReaderId() {
        return this.fReaderId;
    }

    public String getSystemId() {
        return this.fSystemId;
    }

    protected String getSystemIdOfEntity(int n) {
        int n2 = this.fEntityPool.getSystemId(n);
        return this.fStringPool.toString(n2);
    }

    protected String getSystemIdOfParameterEntity(int n) {
        int n2 = this.fParameterEntityPool.getSystemId(n);
        return this.fStringPool.toString(n2);
    }

    protected boolean isExternalEntity(int n) {
        boolean bl = this.fEntityPool.isExternalEntity(n);
        return bl;
    }

    protected boolean isExternalParameterEntity(int n) {
        boolean bl = this.fParameterEntityPool.isExternalEntity(n);
        return bl;
    }

    public boolean isNotationDeclared(int n) {
        return this.fEntityPool.isNotationDeclared(n);
    }

    public boolean isUnparsedEntity(int n) {
        int n2 = this.fEntityPool.lookupEntity(n);
        return n2 != -1 && this.fEntityPool.isUnparsedEntity(n2);
    }

    protected int lookupEntity(int n) {
        int n2 = this.fEntityPool.lookupEntity(n);
        return n2;
    }

    protected int lookupParameterEntity(int n) throws Exception {
        int n2 = -1;
        if (this.fParameterEntityPool != null) {
            n2 = this.fParameterEntityPool.lookupEntity(n);
        }
        return n2;
    }

    private void popEntity() throws Exception {
        --this.fEntityStackDepth;
    }

    private void popReader() {
        if (this.fReaderStack.empty()) {
            throw new RuntimeException("FWK004 cannot happen 19\n19");
        }
        ReaderState readerState = (ReaderState)this.fReaderStack.pop();
        this.fReader = readerState.reader;
        this.fSource = readerState.source;
        this.fEntityName = readerState.entityName;
        this.fEntityType = readerState.entityType;
        this.fEntityContext = readerState.entityContext;
        this.fPublicId = readerState.publicId;
        this.fSystemId = readerState.systemId;
        this.fReaderId = readerState.readerId;
        this.fReaderDepth = readerState.depth;
        readerState.nextReaderState = this.fReaderStateFreeList;
        this.fReaderStateFreeList = readerState;
    }

    private boolean pushEntity(boolean bl, int n) throws Exception {
        if (n >= 0) {
            int n2 = 0;
            while (n2 < this.fEntityStackDepth) {
                if (this.fEntityNameStack[n2] == n && this.fEntityTypeStack[n2] == (bl ? (byte)1 : 0)) {
                    return false;
                }
                ++n2;
            }
        }
        if (this.fEntityTypeStack == null) {
            this.fEntityTypeStack = new byte[8];
            this.fEntityNameStack = new int[8];
        } else if (this.fEntityStackDepth == this.fEntityTypeStack.length) {
            byte[] byArray = new byte[this.fEntityStackDepth * 2];
            System.arraycopy(this.fEntityTypeStack, 0, byArray, 0, this.fEntityStackDepth);
            this.fEntityTypeStack = byArray;
            int[] nArray = new int[this.fEntityStackDepth * 2];
            System.arraycopy(this.fEntityNameStack, 0, nArray, 0, this.fEntityStackDepth);
            this.fEntityNameStack = nArray;
        }
        this.fEntityTypeStack[this.fEntityStackDepth] = (byte)(bl ? 1 : 0);
        this.fEntityNameStack[this.fEntityStackDepth] = n;
        ++this.fEntityStackDepth;
        return true;
    }

    private void pushNullReader() {
        ReaderState readerState = this.fReaderStateFreeList;
        if (readerState == null) {
            readerState = new ReaderState();
        } else {
            this.fReaderStateFreeList = readerState.nextReaderState;
        }
        if (this.fNullReader == null) {
            this.fNullReader = new NullReader();
        }
        readerState.reader = this.fNullReader;
        readerState.source = null;
        readerState.entityName = -1;
        readerState.entityType = -1;
        readerState.entityContext = -1;
        readerState.publicId = "Null Entity";
        readerState.systemId = this.fSystemId;
        readerState.readerId = this.fNextReaderId++;
        readerState.depth = -1;
        readerState.nextReaderState = null;
        this.fReaderStack.push(readerState);
    }

    private void pushReader() {
        ReaderState readerState = this.fReaderStateFreeList;
        if (readerState == null) {
            readerState = new ReaderState();
        } else {
            this.fReaderStateFreeList = readerState.nextReaderState;
        }
        readerState.reader = this.fReader;
        readerState.source = this.fSource;
        readerState.entityName = this.fEntityName;
        readerState.entityType = this.fEntityType;
        readerState.entityContext = this.fEntityContext;
        readerState.publicId = this.fPublicId;
        readerState.systemId = this.fSystemId;
        readerState.readerId = this.fReaderId;
        readerState.depth = this.fReaderDepth;
        readerState.nextReaderState = null;
        this.fReaderStack.push(readerState);
    }

    private void reportRecoverableXMLError(int n, int n2, int n3) throws Exception {
        Object[] objectArray = new Object[]{this.fStringPool.toString(n3)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    public void reset(StringPool stringPool) {
        this.fStringPool = stringPool;
        this.fEntityPool.reset(this.fStringPool);
        this.fParameterEntityPool = null;
        this.fReaderStack.removeAllElements();
        this.fEntityStackDepth = 0;
        this.fReader = null;
        this.fSource = null;
        this.fEntityName = -1;
        this.fEntityType = -1;
        this.fEntityContext = -1;
        this.fPublicId = null;
        this.fSystemId = null;
        this.fReaderId = -1;
        this.fReaderDepth = -1;
        this.fNextReaderId = 0;
    }

    public void setAllowJavaEncodings(boolean bl) {
        this.fReaderFactory.setAllowJavaEncodingName(bl);
    }

    public void setCharDataHandler(XMLEntityHandler.CharDataHandler charDataHandler) {
        this.fCharDataHandler = charDataHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.fResolver = entityResolver;
    }

    public void setEventHandler(EventHandler eventHandler) {
        this.fEventHandler = eventHandler;
    }

    public void setReaderDepth(int n) {
        this.fReaderDepth = n;
    }

    public void setReaderFactory(XMLEntityReaderFactory xMLEntityReaderFactory) {
        this.fReaderFactory = xMLEntityReaderFactory;
        this.fReaderFactory.setSendCharDataAsCharArray(this.fSendCharDataAsCharArray);
    }

    public void setSendCharDataAsCharArray(boolean bl) {
        this.fSendCharDataAsCharArray = bl;
        this.fReaderFactory.setSendCharDataAsCharArray(this.fSendCharDataAsCharArray);
    }

    public boolean startEntityDecl(boolean bl, int n) throws Exception {
        if (!this.pushEntity(bl, n)) {
            int n2 = bl ? 72 : 71;
            Object[] objectArray = new Object[]{this.fStringPool.toString(n), this.entityReferencePath(bl, n)};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n2, 73, objectArray, 2);
            return false;
        }
        return true;
    }

    public boolean startReadingFromDocument(InputSource inputSource) throws Exception {
        this.pushEntity(false, -2);
        this.fSystemId = null;
        this.pushNullReader();
        this.fEntityName = -2;
        this.fEntityType = 5;
        this.fEntityContext = 6;
        this.fReaderDepth = 0;
        this.fReaderId = this.fNextReaderId++;
        this.fPublicId = inputSource.getPublicId();
        this.fSystemId = inputSource.getSystemId();
        this.fEventHandler.startEntityReference(this.fEntityName, this.fEntityType, this.fEntityContext);
        this.fSystemId = this.expandSystemId(this.fSystemId, null);
        this.fSource = inputSource;
        boolean bl = true;
        try {
            this.fReader = this.fReaderFactory.createReader(this, this.fErrorReporter, inputSource, this.fSystemId, bl, this.fStringPool);
        }
        catch (MalformedURLException malformedURLException) {
            String string = this.fSystemId;
            this.fEventHandler.endEntityReference(this.fEntityName, this.fEntityType, this.fEntityContext);
            this.popReader();
            this.popEntity();
            this.fReader = null;
            Object[] objectArray = new Object[]{string};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", 5, 0, objectArray, 2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = this.fSystemId;
            this.fEventHandler.endEntityReference(this.fEntityName, this.fEntityType, this.fEntityContext);
            this.popReader();
            this.popEntity();
            this.fReader = null;
            Object[] objectArray = new Object[]{string};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", 5, 0, objectArray, 2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.fEventHandler.endEntityReference(this.fEntityName, this.fEntityType, this.fEntityContext);
            this.popReader();
            this.popEntity();
            this.fReader = null;
            String string = unsupportedEncodingException.getMessage();
            if (string == null) {
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 70, 72, null, 2);
            }
            if (!XMLCharacterProperties.validEncName(string)) {
                Object[] objectArray = new Object[]{string};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 40, 42, objectArray, 2);
            }
            Object[] objectArray = new Object[]{string};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 61, 60, objectArray, 2);
        }
        this.fEventHandler.sendReaderChangeNotifications(this.fReader, this.fReaderId);
        return this.fReader != null;
    }

    public boolean startReadingFromEntity(int n, int n2, int n3) throws Exception {
        if (n3 > 2) {
            return this.startReadingFromParameterEntity(n, n2, n3);
        }
        int n4 = this.lookupEntity(n);
        if (n4 < 0) {
            int n5 = 62;
            int n6 = 1;
            if (this.fEntityContext == 6 || this.fEntityContext == 0) {
                n5 = 61;
                n6 = 2;
            } else if (!this.fEventHandler.getValidating()) {
                return false;
            }
            Object[] objectArray = new Object[]{this.fStringPool.toString(n)};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 62, n5, objectArray, n6);
            return false;
        }
        if (n3 == 2) {
            if (this.fEntityPool.isUnparsedEntity(n4)) {
                Object[] objectArray = new Object[]{this.fStringPool.toString(n)};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 63, 63, objectArray, 2);
                return false;
            }
        } else if (this.isExternalEntity(n4)) {
            Object[] objectArray = new Object[]{this.fStringPool.toString(n)};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 64, 64, objectArray, 2);
            return false;
        }
        if (!this.pushEntity(false, n)) {
            Object[] objectArray = new Object[]{this.fStringPool.toString(n), this.entityReferencePath(false, n)};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 71, 73, objectArray, 2);
            return false;
        }
        this.pushReader();
        this.fEntityName = n;
        this.fEntityContext = n3;
        this.fReaderDepth = n2;
        this.fReaderId = this.fNextReaderId++;
        if (n3 != 2 || !this.externalReferenceInContent(n4)) {
            this.fEntityType = 2;
            this.fPublicId = null;
            this.fSystemId = this.fSystemId;
            int n7 = -1;
            n7 = n3 == 2 || n3 == 1 ? this.getEntityValue(n4) : this.valueOfReferenceInAttValue(n4);
            this.startReadingFromInternalEntity(n7, false);
            return false;
        }
        this.fEntityType = 3;
        this.fPublicId = this.getPublicIdOfEntity(n4);
        this.fSystemId = this.getSystemIdOfEntity(n4);
        return this.startReadingFromExternalEntity(true, n4);
    }

    private boolean startReadingFromExternalEntity(boolean bl, int n) throws Exception {
        Object[] objectArray;
        String string;
        this.fEventHandler.startEntityReference(this.fEntityName, this.fEntityType, this.fEntityContext);
        String string2 = null;
        if (n != -1) {
            string2 = this.fEntityType == 1 ? this.fParameterEntityPool.getBaseSystemId(n) : this.fEntityPool.getBaseSystemId(n);
        }
        if (string2 == null) {
            ReaderState readerState = (ReaderState)this.fReaderStack.peek();
            string2 = readerState.systemId;
        }
        this.fSystemId = this.expandSystemId(this.fSystemId, string2);
        InputSource inputSource = this.fSource = this.fResolver == null ? null : this.fResolver.resolveEntity(this.fPublicId, this.fSystemId);
        if (this.fSource == null) {
            this.fSource = new InputSource(this.fSystemId);
            if (this.fPublicId != null) {
                this.fSource.setPublicId(this.fPublicId);
            }
        } else {
            if (this.fSource.getSystemId() != null) {
                this.fSystemId = this.expandSystemId(this.fSource.getSystemId(), string2);
            }
            if (this.fSource.getPublicId() != null) {
                this.fPublicId = this.fSource.getPublicId();
            }
        }
        boolean bl2 = false;
        try {
            this.fReader = this.fReaderFactory.createReader(this, this.fErrorReporter, this.fSource, this.fSystemId, bl2, this.fStringPool);
        }
        catch (MalformedURLException malformedURLException) {
            string = this.fSystemId;
            this.fEventHandler.endEntityReference(this.fEntityName, this.fEntityType, this.fEntityContext);
            this.popReader();
            this.popEntity();
            this.fReader = null;
            objectArray = new Object[]{string};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", 5, 0, objectArray, 2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            string = this.fSystemId;
            this.fEventHandler.endEntityReference(this.fEntityName, this.fEntityType, this.fEntityContext);
            this.popReader();
            this.popEntity();
            this.fReader = null;
            objectArray = new Object[]{string};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", 5, 0, objectArray, 2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.fEventHandler.endEntityReference(this.fEntityName, this.fEntityType, this.fEntityContext);
            this.popReader();
            this.popEntity();
            this.fReader = null;
            objectArray = unsupportedEncodingException.getMessage();
            if (objectArray == null) {
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 70, 72, null, 2);
            }
            if (!XMLCharacterProperties.validEncName((String)objectArray)) {
                Object[] objectArray2 = new Object[]{objectArray};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 40, 42, objectArray2, 2);
            }
            Object[] objectArray3 = new Object[]{objectArray};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 61, 60, objectArray3, 2);
        }
        if (this.fReader == null || !bl) {
            this.fEventHandler.sendReaderChangeNotifications(this.fReader, this.fReaderId);
            return false;
        }
        int n2 = this.fReaderId;
        this.fEventHandler.sendReaderChangeNotifications(this.fReader, this.fReaderId);
        boolean bl3 = this.fReader.lookingAtChar('<', false);
        if (n2 != this.fReaderId) {
            bl3 = false;
        }
        return bl3;
    }

    public void startReadingFromExternalSubset(String string, String string2, int n) throws Exception {
        this.pushEntity(true, -1);
        this.pushReader();
        this.pushNullReader();
        this.fEntityName = -1;
        this.fEntityType = 6;
        this.fEntityContext = 7;
        this.fReaderDepth = n;
        this.fReaderId = this.fNextReaderId++;
        this.fPublicId = string;
        this.fSystemId = string2;
        this.startReadingFromExternalEntity(false, -1);
    }

    private void startReadingFromInternalEntity(int n, boolean bl) throws Exception {
        this.fSource = null;
        this.fEventHandler.startEntityReference(this.fEntityName, this.fEntityType, this.fEntityContext);
        this.fReader = this.fReaderFactory.createStringReader(this, this.fErrorReporter, this.fSendCharDataAsCharArray, this.getLineNumber(), this.getColumnNumber(), n, this.fStringPool, bl);
        this.fEventHandler.sendReaderChangeNotifications(this.fReader, this.fReaderId);
    }

    private boolean startReadingFromParameterEntity(int n, int n2, int n3) throws Exception {
        int n4 = this.lookupParameterEntity(n);
        if (n4 == -1) {
            if (this.fEventHandler.getValidating()) {
                this.reportRecoverableXMLError(62, 62, n);
            }
            return false;
        }
        if (!this.pushEntity(true, n)) {
            Object[] objectArray = new Object[]{this.fStringPool.toString(n), this.entityReferencePath(true, n)};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 72, 73, objectArray, 2);
            return false;
        }
        this.pushReader();
        this.fEntityName = n;
        this.fEntityContext = n3;
        this.fReaderDepth = n2;
        this.fReaderId = this.fNextReaderId++;
        if (!this.isExternalParameterEntity(n4)) {
            this.fEntityType = 0;
            this.fPublicId = null;
            this.fSystemId = this.fSystemId;
            int n5 = this.getParameterEntityValue(n4);
            this.startReadingFromInternalEntity(n5, this.fEntityContext != 4);
            return false;
        }
        this.fEntityType = 1;
        this.fPublicId = this.getPublicIdOfParameterEntity(n4);
        this.fSystemId = this.getSystemIdOfParameterEntity(n4);
        return this.startReadingFromExternalEntity(true, n4);
    }

    public void stopReadingFromExternalSubset() throws Exception {
        if (!(this.fReader instanceof NullReader)) {
            throw new RuntimeException("FWK004 cannot happen 18\n18");
        }
        this.popReader();
        this.fEventHandler.sendReaderChangeNotifications(this.fReader, this.fReaderId);
    }

    protected int valueOfReferenceInAttValue(int n) throws Exception {
        if (this.fEventHandler.externalEntityStandaloneCheck() && this.fEntityPool.getEntityDeclIsExternal(n)) {
            this.reportRecoverableXMLError(132, 80, this.fEntityName);
        }
        int n2 = this.fEntityPool.getEntityValue(n);
        return n2;
    }

    public static interface EventHandler {
        public void endEntityReference(int var1, int var2, int var3) throws Exception;

        public boolean externalEntityStandaloneCheck();

        public boolean getValidating();

        public void sendEndOfInputNotifications(int var1, boolean var2) throws Exception;

        public void sendReaderChangeNotifications(XMLEntityHandler.EntityReader var1, int var2) throws Exception;

        public void startEntityReference(int var1, int var2, int var3) throws Exception;
    }

    private class ReaderState {
        XMLEntityHandler.EntityReader reader;
        InputSource source;
        int entityName;
        int entityType;
        int entityContext;
        String publicId;
        String systemId;
        int readerId;
        int depth;
        ReaderState nextReaderState;

        ReaderState() {
        }
    }

    private final class NullReader
    implements XMLEntityHandler.EntityReader {
        public int addString(int n, int n2) {
            return -1;
        }

        public int addSymbol(int n, int n2) {
            return -1;
        }

        public void append(XMLEntityHandler.CharBuffer charBuffer, int n, int n2) {
        }

        public int currentOffset() {
            return -1;
        }

        public int getColumnNumber() {
            return -1;
        }

        public boolean getInCDSect() {
            return false;
        }

        public int getLineNumber() {
            return -1;
        }

        public boolean lookingAtChar(char c, boolean bl) {
            return false;
        }

        public boolean lookingAtSpace(boolean bl) {
            return false;
        }

        public boolean lookingAtValidChar(boolean bl) {
            return false;
        }

        public int scanAttValue(char c, boolean bl) {
            return -3;
        }

        public int scanCharRef(boolean bl) {
            return -2;
        }

        public int scanContent(QName qName) throws Exception {
            return 9;
        }

        public int scanEntityValue(int n, boolean bl) {
            return -4;
        }

        public boolean scanExpectedName(char c, StringPool.CharArrayRange charArrayRange) {
            return false;
        }

        public int scanInvalidChar() {
            return -1;
        }

        public int scanName(char c) {
            return -1;
        }

        public void scanQName(char c, QName qName) {
            qName.clear();
        }

        public int scanStringLiteral() {
            return -1;
        }

        public void setInCDSect(boolean bl) {
        }

        public void skipPastName(char c) {
        }

        public void skipPastNmtoken(char c) {
        }

        public void skipPastSpaces() {
        }

        public void skipToChar(char c) {
        }

        public boolean skippedString(char[] cArray) {
            return false;
        }
    }

    public final class EntityPool {
        private StringPool fStringPool = null;
        private XMLErrorReporter fErrorReporter = null;
        private int fEntityCount = 0;
        private int[][] fName = new int[32][];
        private int[][] fValue = new int[32][];
        private int[][] fPublicId = new int[32][];
        private int[][] fSystemId = new int[32][];
        private int[][] fBaseSystemId = new int[32][];
        private int[][] fNotationName = new int[32][];
        private byte[][] fDeclIsExternal = new byte[32][];
        private int fNotationListHead = -1;
        private boolean fCreateStandardEntities = false;
        private Vector fRequiredNotations = null;

        public EntityPool(StringPool stringPool, XMLErrorReporter xMLErrorReporter, boolean bl) {
            this.fStringPool = stringPool;
            this.fErrorReporter = xMLErrorReporter;
            this.fCreateStandardEntities = bl;
            if (this.fCreateStandardEntities) {
                this.createInternalEntity("lt", "&#60;");
                this.createInternalEntity("gt", ">");
                this.createInternalEntity("amp", "&#38;");
                this.createInternalEntity("apos", "'");
                this.createInternalEntity("quot", "\"");
            }
        }

        public int addEntityDecl(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
            int n7 = this.fEntityCount >> 5;
            int n8 = this.fEntityCount & 0x1F;
            this.ensureCapacity(n7);
            this.fName[n7][n8] = n;
            this.fValue[n7][n8] = n2;
            this.fPublicId[n7][n8] = n3;
            this.fSystemId[n7][n8] = n4;
            this.fBaseSystemId[n7][n8] = n5;
            this.fNotationName[n7][n8] = n6;
            this.fDeclIsExternal[n7][n8] = bl ? -128 : 0;
            int n9 = this.fEntityCount++;
            return n9;
        }

        public int addNotationDecl(int n, int n2, int n3, int n4, boolean bl) {
            int n5;
            int n6;
            int n7 = this.fNotationListHead;
            while (n7 != -1) {
                n6 = n7 >> 5;
                n5 = n7 & 0x1F;
                if (this.fNotationName[n6][n5] == n) {
                    return -1;
                }
                n7 = this.fValue[n6][n5];
            }
            n6 = this.fEntityCount >> 5;
            n5 = this.fEntityCount & 0x1F;
            this.ensureCapacity(n6);
            this.fName[n6][n5] = -1;
            this.fValue[n6][n5] = this.fNotationListHead;
            this.fPublicId[n6][n5] = n2;
            this.fSystemId[n6][n5] = n3;
            this.fBaseSystemId[n6][n5] = n4;
            this.fNotationName[n6][n5] = n;
            this.fDeclIsExternal[n6][n5] = bl ? -128 : 0;
            this.fNotationListHead = this.fEntityCount++;
            return this.fNotationListHead;
        }

        public void addRequiredNotation(int n, Locator locator, int n2, int n3, Object[] objectArray) {
            if (this.fRequiredNotations == null) {
                this.fRequiredNotations = new Vector();
            }
            int n4 = 0;
            while (n4 < this.fRequiredNotations.size()) {
                RequiredNotation requiredNotation = (RequiredNotation)this.fRequiredNotations.elementAt(n4);
                if (requiredNotation.fNotationName == n) {
                    return;
                }
                ++n4;
            }
            this.fRequiredNotations.addElement(new RequiredNotation(n, locator, n2, n3, objectArray));
        }

        public void checkRequiredNotations() throws Exception {
            if (this.fRequiredNotations == null) {
                return;
            }
            int n = 0;
            while (n < this.fRequiredNotations.size()) {
                RequiredNotation requiredNotation = (RequiredNotation)this.fRequiredNotations.elementAt(n);
                if (!this.isNotationDeclared(requiredNotation.fNotationName)) {
                    this.fErrorReporter.reportError(requiredNotation.fLocator, "http://www.w3.org/TR/1998/REC-xml-19980210", requiredNotation.fMajorCode, requiredNotation.fMinorCode, requiredNotation.fArgs, 1);
                }
                ++n;
            }
        }

        private void createInternalEntity(String string, String string2) {
            int n = this.fEntityCount >> 5;
            int n2 = this.fEntityCount & 0x1F;
            this.ensureCapacity(n);
            this.fName[n][n2] = this.fStringPool.addSymbol(string);
            this.fValue[n][n2] = this.fStringPool.addString(string2);
            this.fPublicId[n][n2] = -1;
            this.fSystemId[n][n2] = -1;
            this.fBaseSystemId[n][n2] = -1;
            this.fNotationName[n][n2] = -1;
            ++this.fEntityCount;
        }

        private boolean ensureCapacity(int n) {
            try {
                return this.fName[n][0] == 0;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                int[][] nArray = new int[n * 2][];
                System.arraycopy(this.fName, 0, nArray, 0, n);
                this.fName = nArray;
                nArray = new int[n * 2][];
                System.arraycopy(this.fValue, 0, nArray, 0, n);
                this.fValue = nArray;
                nArray = new int[n * 2][];
                System.arraycopy(this.fPublicId, 0, nArray, 0, n);
                this.fPublicId = nArray;
                nArray = new int[n * 2][];
                System.arraycopy(this.fSystemId, 0, nArray, 0, n);
                nArray = new int[n * 2][];
                System.arraycopy(this.fBaseSystemId, 0, nArray, 0, n);
                this.fBaseSystemId = nArray;
                this.fSystemId = nArray;
                nArray = new int[n * 2][];
                System.arraycopy(this.fNotationName, 0, nArray, 0, n);
                this.fNotationName = nArray;
                byte[][] byArray = new byte[n * 2][];
                System.arraycopy(this.fDeclIsExternal, 0, byArray, 0, n);
                this.fDeclIsExternal = byArray;
            }
            catch (NullPointerException nullPointerException) {}
            this.fName[n] = new int[32];
            this.fValue[n] = new int[32];
            this.fPublicId[n] = new int[32];
            this.fSystemId[n] = new int[32];
            this.fBaseSystemId[n] = new int[32];
            this.fNotationName[n] = new int[32];
            this.fDeclIsExternal[n] = new byte[32];
            return true;
        }

        public String getBaseSystemId(int n) {
            int n2 = n >> 5;
            int n3 = n & 0x1F;
            int n4 = this.fBaseSystemId[n2][n3];
            if (n4 == -1) {
                return null;
            }
            return this.fStringPool.toString(n4);
        }

        public boolean getEntityDeclIsExternal(int n) {
            int n2 = n >> 5;
            int n3 = n & 0x1F;
            return this.fDeclIsExternal[n2][n3] < 0;
        }

        public int getEntityName(int n) {
            int n2 = n >> 5;
            int n3 = n & 0x1F;
            return this.fName[n2][n3];
        }

        public int getEntityValue(int n) {
            int n2 = n >> 5;
            int n3 = n & 0x1F;
            return this.fValue[n2][n3];
        }

        public boolean getNotationDeclIsExternal(int n) {
            int n2 = n >> 5;
            int n3 = n & 0x1F;
            return this.fDeclIsExternal[n2][n3] < 0;
        }

        public int getNotationName(int n) {
            int n2 = n >> 5;
            int n3 = n & 0x1F;
            return this.fNotationName[n2][n3];
        }

        public int getPublicId(int n) {
            int n2 = n >> 5;
            int n3 = n & 0x1F;
            return this.fPublicId[n2][n3];
        }

        public int getSystemId(int n) {
            int n2 = n >> 5;
            int n3 = n & 0x1F;
            return this.fSystemId[n2][n3];
        }

        public boolean isExternalEntity(int n) {
            int n2 = n >> 5;
            int n3 = n & 0x1F;
            return this.fValue[n2][n3] == -1;
        }

        public boolean isNotationDeclared(int n) {
            int n2 = this.fNotationListHead;
            while (n2 != -1) {
                int n3 = n2 >> 5;
                int n4 = n2 & 0x1F;
                if (this.fNotationName[n3][n4] == n) {
                    return true;
                }
                n2 = this.fValue[n3][n4];
            }
            return false;
        }

        public boolean isUnparsedEntity(int n) {
            int n2 = n >> 5;
            int n3 = n & 0x1F;
            return this.fNotationName[n2][n3] != -1;
        }

        public int lookupEntity(int n) {
            if (n == -1) {
                return -1;
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.fEntityCount) {
                if (this.fName[n2][n3] == n) {
                    return n4;
                }
                if (++n3 == 32) {
                    ++n2;
                    n3 = 0;
                }
                ++n4;
            }
            return -1;
        }

        public void reset(StringPool stringPool) {
            this.fStringPool = stringPool;
            this.fEntityCount = 0;
            this.fNotationListHead = -1;
            if (this.fRequiredNotations != null) {
                this.fRequiredNotations.removeAllElements();
            }
            if (this.fCreateStandardEntities) {
                this.createInternalEntity("lt", "&#60;");
                this.createInternalEntity("gt", ">");
                this.createInternalEntity("amp", "&#38;");
                this.createInternalEntity("apos", "'");
                this.createInternalEntity("quot", "\"");
            }
        }

        class RequiredNotation {
            int fNotationName;
            LocatorImpl fLocator;
            int fMajorCode;
            int fMinorCode;
            Object[] fArgs;

            RequiredNotation(int n, Locator locator, int n2, int n3, Object[] objectArray) {
                this.fNotationName = n;
                this.fLocator = new LocatorImpl(locator);
                this.fMajorCode = n2;
                this.fMinorCode = n3;
                this.fArgs = objectArray;
            }
        }
    }
}

