/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.mail.MailMessage;

public class SendEmail
extends Task {
    private String from;
    private String mailhost = "localhost";
    private String message;
    private String toList;
    private String subject;
    private Vector files = new Vector();

    public void setToList(String toList) {
        this.toList = toList;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setMailhost(String mailhost) {
        this.mailhost = mailhost;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setFiles(String filenames) {
        StringTokenizer t = new StringTokenizer(filenames, ", ");
        while (t.hasMoreTokens()) {
            this.files.addElement(this.project.resolveFile(t.nextToken()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void execute() {
        try {
            PrintStream out;
            MailMessage mailMessage = new MailMessage(this.mailhost);
            if (this.from == null) {
                throw new BuildException("Attribute \"from\" is required.");
            }
            mailMessage.from(this.from);
            if (this.toList != null) {
                StringTokenizer t = new StringTokenizer(this.toList, ", ", false);
                while (t.hasMoreTokens()) {
                    mailMessage.to(t.nextToken());
                }
            } else {
                throw new BuildException("Attribute \"toList\" is required.");
            }
            if (this.subject != null) {
                mailMessage.setSubject(this.subject);
            }
            if (!this.files.isEmpty()) {
                out = mailMessage.getPrintStream();
                Enumeration e = this.files.elements();
                while (e.hasMoreElements()) {
                    File file = (File)e.nextElement();
                    if (file.exists() && file.canRead()) {
                        int bufsize = 1024;
                        byte[] buf = new byte[bufsize];
                        BufferedInputStream in = null;
                        try {
                            int length;
                            in = new BufferedInputStream(new FileInputStream(file), bufsize);
                            while ((length = in.read(buf, 0, bufsize)) != -1) {
                                void var6_7;
                                out.write(buf, 0, (int)var6_7);
                            }
                            continue;
                        }
                        finally {
                            Object var10_10 = null;
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    throw new BuildException("File \"" + file.getName() + "\" does not exist or is not readable.");
                }
            } else if (this.message != null) {
                out = mailMessage.getPrintStream();
                out.print(this.message);
            } else {
                throw new BuildException("Attribute \"file\" or \"message\" is required.");
            }
            this.log("Sending email");
            mailMessage.sendAndClose();
        }
        catch (IOException ioe) {
            throw new BuildException("IO error sending mail: " + ioe.getMessage());
        }
    }
}

